<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Change default size for single image shortcode
add_action('init', 'vc_update_defaults', 100);
function vc_update_defaults() {
	if ( class_exists( 'WPBMap' ) )  {
		// Set full size for single image by default
		$param = WPBMap::getParam( 'vc_single_image', 'img_size' );
		$param['value'] = 'full';
		vc_update_shortcode_param( 'vc_single_image', $param );
	}
}

// Add moreparams
add_action('init', 'vc_add_new_para', 100);
function vc_add_new_para() {
	// Add Number param
	vc_add_shortcode_param( 'number', 'logistix_param_number' );
	function logistix_param_number( $settings, $value ) {
		$dependency = '';
		$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
		$type = isset($settings['type']) ? $settings['type'] : '';
		$suffix = isset($settings['suffix']) ? $settings['suffix'] : '';
		$class = isset($settings['class']) ? $settings['class'] : '';
		$output = '<input type="number" class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '" value="'. $value.'" style="max-width:100px; margin-right: 10px;" />'. $suffix;
		return $output;
	}

	// Add Heading param
	vc_add_shortcode_param( 'headings', 'logistix_param_heading' );
	function logistix_param_heading( $settings, $value ) {
		$dependency = '';
		$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
		$class = isset($settings['class']) ? $settings['class'] : '';
		$text = isset($settings['text']) ? $settings['text'] : '';
		$output = '<h4 '. $dependency .' class="wpb_vc_param_value '. $class .'" style="margin: 10px 0 0;padding:10px;font-size:14px; background:#ebebeb;color:#666;">'. $text .'</h4>';
		$output .= '<input type="hidden" name="'. $settings['param_name'].'" class="wpb_vc_param_value ultimate-param-heading '. $settings['param_name'] .' '. $settings['type'] .'_field" value="'. $value.'" '. $dependency.'/>';
		return $output;
	}
}

// Register Backend and Frontend CSS Styles
add_action( 'vc_base_register_front_css', 'leadinjection_vc_iconpicker_base_register_css' );
add_action( 'vc_base_register_admin_css', 'leadinjection_vc_iconpicker_base_register_css' );
function leadinjection_vc_iconpicker_base_register_css(){
    wp_enqueue_style('extraicon', plugin_dir_url( __FILE__ ) . '/assets/content-icons.css');
}

// Enqueue CSS in Frontend when it's used
add_action('vc_enqueue_font_icon_element', 'leadinjection_enqueue_font_extraicon');
function leadinjection_enqueue_font_extraicon($font){
    switch ( $font ) {
        case 'extraicon': wp_enqueue_style( 'extraicon' );
    }
}

// Define the Icons for VC Iconpicker
add_filter( 'vc_iconpicker-type-extraicon', 'vc_iconpicker_type_extraicon' );
function vc_iconpicker_type_extraicon() {
    return array(
		array("logistixs-bank-support" => "bank-support"),
		array("logistixs-badge" => "badge"),
		array("logistixs-location" => "location"),
		array("logistixs-world" => "world"),
		array("logistixs-size1" => "size1"),
		array("logistixs-size2" => "size2"),
		array("logistixs-fragile" => "fragile"),
		array("logistixs-recycling" => "recycling"),
		array("logistixs-scan-package" => "scan-package"),
		array("logistixs-stack-in-depot" => "stack-in-depot"),
		array("logistixs-this-side-up" => "this-side-up"),
		array("logistixs-hand-truck" => "hand-truck"),
		array("logistixs-danger-sign" => "danger-sign"),
		array("logistixs-keep-dry" => "keep-dry"),
		array("logistixs-delivery-truck" => "delivery-truck"),
		array("logistixs-airplane" => "airplane"),
		array("logistixs-anchor-shape" => "anchor-shape"),
		array("logistixs-bookmark-ribbon" => "bookmark-ribbon"),
		array("logistixs-calculator" => "calculator"),
		array("logistixs-call-center-man" => "call-center-man"),
		array("logistixs-car-front" => "car-front"),
		array("logistixs-cargo-boat" => "cargo-boat"),
		array("logistixs-cogwheel" => "cogwheel"),
		array("logistixs-compass" => "compass"),
		array("logistixs-flash" => "flash"),
		array("logistixs-front-bus" => "front-bus"),
		array("logistixs-google-drive-file" => "google-drive-file"),
		array("logistixs-manufacturer" => "manufacturer"),
		array("logistixs-notifications-button" => "notifications-button"),
		array("logistixs-package-box" => "package-box"),
		array("logistixs-percentage" => "percentage"),
		array("logistixs-public-transport-subway" => "public-transport-subway"),
		array("logistixs-report-symbol" => "report-symbol"),
		array("logistixs-scale" => "scale"),
		array("logistixs-school-calendar" => "school-calendar"),
		array("logistixs-shop" => "shop"),
		array("logistixs-simple-calculator" => "simple-calculator"),
		array("logistixs-startup" => "startup"),
		array("logistixs-stock" => "stock"),
		array("logistixs-traffic-light" => "traffic-light"),
		array("logistixs-wallet" => "wallet"),
		array("logistixs-warehouse" => "warehouse"),
		array("logistixs-weight" => "weight"),
		array("logistixs-box" => "box"),
		array("logistixs-credit-card" => "credit-card"),
		array("logistixs-notepad" => "notepad"),
		array("logistixs-open" => "open"),
		array("logistixs-piggy-bank" => "piggy-bank"),
		array("logistixs-price-tag" => "price-tag"),
		array("logistixs-telephone" => "telephone"),
		array("logistixs-truck" => "truck")
    );
}

// Return simple fonts array
if ( ! function_exists('logistix_plugin_google_font') ) {
	function logistix_plugin_google_font() {
		if ( function_exists('logistix_google_fonts_array') ) {
			$default = array( 0 => 'Default' );
			return array_merge( $default, logistix_google_fonts_array() );
		} else {
			return array(
				'Default', 'Arial, Helvetica, sans-serif', 'Arial Black, Gadget, sans-serif',
				'Bookman Old Style, serif', 'Comic Sans MS, cursive', 'Courier, monospace',
				'Georgia, serif', 'Garamond, serif', 'Impact, Charcoal, sans-serif', 'Lucida Console, Monaco, monospace',
				'Lucida Sans Unicode, Lucida Grande, sans-serif', 'MS Sans Serif, Geneva, sans-serif', 'MS Serif, New York, sans-serif',
				'Palatino Linotype, Book Antiqua, Palatino, serif', 'Tahoma, Geneva, sans-serif', 'Times New Roman, Times, serif',
				'Trebuchet MS, Helvetica, sans-serif', 'Verdana, Geneva, sans-serif', 'Paratina Linotype', 'Trebuchet MS',
			);
		}
	}
}

// Retrun animate classes
if ( ! function_exists('logistix_animation') ) {
	function logistix_animation() {
		return array(
			'fadeIn', 'fadeInDown', 'fadeInDownBig', 'fadeInLeftSmall', 'fadeInLeft', 'fadeInLeftBig', 'fadeInRightSmall', 'fadeInRight',
			'fadeInRightBig', 'fadeInUp', 'fadeInUpBig', 'fadeOut', 'fadeOutDown', 'fadeOutDownBig', 'fadeOutLeft', 'fadeOutLeftBig',
			'fadeOutRight', 'fadeOutRightBig', 'fadeOutUp', 'fadeOutUpBig', 'flash', 'pulse', 'rubberBand', 'shake', 'swing', 'tada', 'wobble',
			'jello', 'hinge', 'rollIn', 'rollOut', 'bounce', 'bounceIn', 'bounceInDown', 'bounceInLeft', 'bounceInRight',
			'bounceInUp', 'bounceOut', 'bounceOutDown', 'bounceOutLeft','bounceOutRight', 'bounceOutUp', 
			'flip', 'flipInX', 'flipInY', 'flipOutX', 'flipOutY', 'lightSpeedIn', 'lightSpeedOut', 'rotateIn', 'rotateInDownLeft', 'rotateInDownRight',
			'rotateInUpLeft', 'rotateInUpRight', 'rotateOut', 'rotateOutDownLeft', 'rotateOutDownRight', 'rotateOutUpLeft', 'rotateOutUpRight',
			'slideInUp', 'slideInDown', 'slideInLeft', 'slideInRight', 'slideOutUp', 'slideOutDown', 'slideOutLeft', 'slideOutRight',
			'zoomIn', 'zoomInDown', 'zoomInLeft', 'zoomInRight', 'zoomInUp', 'zoomOut', 'zoomOutDown', 'zoomOutLeft', 'zoomOutRight', 'zoomOutUp'
		);
	}
}

// Get icon font base on font icon type
if ( ! function_exists('logistix_get_icon_class') ) {
	function logistix_get_icon_class( $atts, $icon_location ) {
		// Define vars
		$icon = '';
		$icon_type = ! empty( $atts['icon_type'] ) ? $atts['icon_type'] : 'fontawesome';

		// Generate fontawesome icon class
		if ( 'fontawesome' == $icon_type && ! empty( $atts[$icon_location] ) ) {
			$icon = $atts[$icon_location];
		} elseif ( ! empty( $atts[ $icon_location .'_'. $icon_type ] ) ) {
			$icon = $atts[ $icon_location .'_'. $icon_type ];
		}

		// Sanitize
		$icon = in_array( $icon, array( 'icon', 'none' ) ) ? '' : $icon;

		// Return icon class
		return $icon;
	}
}

// Spacing
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Spacing', 'thecraft'),
        'description' => esc_html__('Empty space with custom height.', 'thecraft'),
        'base' => 'spacing',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
        'params' => array(
	        array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Desktop: Height', 'thecraft'),
				'param_name' => 'desktop_height',
				'value' => '',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Mobile: Height', 'thecraft'),
				'param_name' => 'mobile_height',
				'value' => '',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Small Mobile: Height', 'thecraft'),
				'param_name' => 'smobile_height',
				'value' => '',
	        ),
        )
    ) );
} );

// Carousel Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_carouselbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Carousel Box', 'thecraft'),
		'description' => esc_html__('Scrolling anything.', 'thecraft'),
		'base' => 'carouselbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('only' => 'contentbox, gridbox, imagebox, iconbox, advimage, testimonials, headings, fancytext, singleheading, pricetable, counter'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'thecraft' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'thecraft' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'thecraft' ),
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'thecraft'),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Spacing Between', 'thecraft'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'thecraft' ),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'thecraft'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'thecraft' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'thecraft' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'thecraft' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'thecraft'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'thecraft' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Style', 'thecraft' ),
				'param_name' => 'arrow_style',
				'value'      => array(
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'dark',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'thecraft' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'thecraft' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Column
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'thecraft' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'thecraft' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'thecraft' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Portfolio Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Portfolio Carousel', 'thecraft'),
        'description' => esc_html__('Displaying project posts in carousel.', 'thecraft'),
        'base' => 'portfolio',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Showcase', 'thecraft' ),
				'param_name' => 'showcase',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'thecraft' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'400 x 400' => 'square2',
					'590 x 550' => 'rectangle',
					'590 x 520' => 'rectangle2',
					'590 x 440' => 'rectangle3',
					'590 x 405' => 'rectangle4',
					'600 x auto' => 'auto2',
				),
				'std'		=> 'rectangle',
				'description'	=> esc_html__('Choose auto option to keep the same aspect ratio when cropping.', 'thecraft'),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'thecraft'),
				'param_name' => 'gap',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'thecraft'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'thecraft'),
				'param_name' => 'items',
				'value' => '8',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'thecraft'),
				'param_name' => 'cat_slug',
				'value' => '',
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'thecraft'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'thecraft' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show hidden items?', 'thecraft' ),
				'param_name' => 'grid_full',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'thecraft'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'thecraft' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'thecraft' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'thecraft' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'thecraft'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'thecraft' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Style', 'thecraft' ),
				'param_name' => 'arrow_style',
				'value'      => array(
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'dark',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'thecraft' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'thecraft' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'thecraft' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'thecraft' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'thecraft' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Portfolio Grid
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Portfolio Grid', 'thecraft'),
        'description' => esc_html__('Displaying project posts in grid with filter bar.', 'thecraft'),
        'base' => 'portfoliogrid',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Showcase', 'thecraft' ),
				'param_name' => 'showcase',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'thecraft' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'400 x 400' => 'square2',
					'590 x 550' => 'rectangle',
					'590 x 520' => 'rectangle2',
					'590 x 440' => 'rectangle3',
					'590 x 405' => 'rectangle4',
					'600 x auto' => 'auto2',
				),
				'std'		=> 'rectangle',
				'description'	=> esc_html__('Choose auto option to keep the same aspect ratio when cropping.', 'thecraft'),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'thecraft'),
				'param_name' => 'gapv',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'thecraft'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'thecraft'),
				'param_name' => 'gaph',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'thecraft'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Box Shadow?', 'thecraft' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
				'dependency' => array( 'element' => 'showcase', 'value' => 'style-2' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'thecraft'),
				'param_name' => 'items',
				'group'      => esc_html__( 'Query', 'thecraft' ),
				'value' => '8',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'thecraft'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'thecraft' ),
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'thecraft'),
	        ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Pagination?', 'thecraft' ),
				'param_name' => 'pagination',
				'group' => esc_html__( 'Query', 'thecraft' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'false',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Filter Bar?', 'thecraft' ),
				'param_name' => 'show_filter',
				'group' => esc_html__( 'Filter', 'thecraft' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'true',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter Style', 'thecraft' ),
				'param_name' => 'filter_style',
				'value'      => array(
					'White' => 'filter-style-1',
					'Grey' => 'filter-style-2',
				),
				'std'		=> 'filter-style-1',
				'group' => esc_html__( 'Filter', 'thecraft' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Filter posts by default?', 'thecraft' ),
				'param_name' => 'filter_by_default',
				'group' => esc_html__( 'Filter', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug', 'thecraft'),
				'param_name' => 'filter_cat_slug',
				'value' => '',
				'group' => esc_html__( 'Filter', 'thecraft' ),
				'dependency' => array( 'element' => 'filter_by_default', 'value' => 'yes' ),
				'description'	=> esc_html__('Filter posts from this category by default. Using category-slug.', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: All', 'thecraft'),
				'param_name' => 'filter_button_all',
				'value' => 'All',
				'group' => esc_html__( 'Filter', 'thecraft' ),
				'description'	=> esc_html__('Leave it empty to disable.', 'thecraft'),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'thecraft'),
				'param_name' => 'bottom_filter',
				'group' => esc_html__( 'Filter', 'thecraft' ),
				'value' => '',
				'description'	=> esc_html__('Ex: 45px.', 'thecraft'),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
            ),
            // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Font Family', 'thecraft' ),
				'param_name' => 'filter_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Font Weight', 'thecraft' ),
				'param_name' => 'filter_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Font Size', 'thecraft'),
				'param_name' => 'filter_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Line-Height', 'thecraft'),
				'param_name' => 'filter_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Letter Spacing', 'thecraft'),
				'param_name' => 'filter_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Text Transform', 'thecraft' ),
				'param_name' => 'filter_text_tranform',
				'value'      => array(
					'Capitalize' => 'capitalize',
					'Uppercase' => 'uppercase',
				),
				'std'		=> 'uppercase',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px', 'thecraft' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c'
				),
				'std'		=> '4c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px', 'thecraft' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px', 'thecraft' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px', 'thecraft' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Testimonials
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Testimonials', 'thecraft'),
	    'description' => esc_html__('Displaying testimonials box.', 'thecraft'),
	    'base' => 'testimonials',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'thecraft'),
	    'params' => array(
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'thecraft'),
				'param_name' => 'image',
				'value' => '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width (Optional)', 'thecraft'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Default: 70px.', 'thecraft'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Style', 'thecraft' ),
				'param_name' => 'image_style',
				'value'      => array(
					'Square' => 'image-square',
					'Circle' => 'image-circle',
				),
				'std'		=> 'image-circle',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap: Background', 'thecraft'),
				'param_name' => 'wrap_background',
				'value' => '#f0f0f0',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap: Padding', 'thecraft'),
				'param_name' => 'wrap_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 40px 40px 50px 50px', 'thecraft'),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap: Rounded', 'thecraft'),
				'param_name' => 'wrap_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 6px', 'thecraft'),
            ),
	        // Text
			array(
				'type' 		=> 'textarea',
				'heading' 	=> esc_html__('Text', 'thecraft'),
				'param_name' 	=> 'text',
				'value' 		=> '',
				'group' => esc_html__( 'Text', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'thecraft'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Text', 'thecraft' ),
            ),
            // Name
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Name', 'thecraft'),
				'param_name' => 'name',
				'value' => 'JOHN ROE',
				'group' => esc_html__( 'Name & Position', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Name Color', 'thecraft'),
				'param_name' => 'name_color',
				'value' => '',
				'group' => esc_html__( 'Name & Position', 'thecraft' ),
            ),
            // Position
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Position', 'thecraft'),
				'param_name' => 'position',
				'value' => 'Sale Manager',
				'group' => esc_html__( 'Name & Position', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Position Color', 'thecraft'),
				'param_name' => 'position_color',
				'value' => '',
				'group' => esc_html__( 'Name & Position', 'thecraft' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'thecraft'),
				'param_name' => 'text_typography',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Family', 'thecraft' ),
				'param_name' => 'text_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Weight', 'thecraft' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text Font Size', 'thecraft'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Style', 'thecraft' ),
				'param_name' => 'text_font_style',
				'value'      => array(
					'Normal' => 'normal',
					'Italic' => 'italic',
				),
				'std'		=> 'normal',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text Line-height', 'thecraft'),
				'param_name' => 'text_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Name', 'thecraft'),
				'param_name' => 'name_typography',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Family', 'thecraft' ),
				'param_name' => 'name_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Weight', 'thecraft' ),
				'param_name' => 'name_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Font Size', 'thecraft'),
				'param_name' => 'name_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Line-height', 'thecraft'),
				'param_name' => 'name_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'thecraft'),
				'param_name' => 'position_typography',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Family', 'thecraft' ),
				'param_name' => 'position_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Weight', 'thecraft' ),
				'param_name' => 'company_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Font Size', 'thecraft'),
				'param_name' => 'position_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Line-height', 'thecraft'),
				'param_name' => 'position_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	    )
	) );
} );

// News Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('News Carousel', 'thecraft'),
	    'description' => esc_html__('Displaying blog posts in carousel.', 'thecraft'),
	    'base' => 'news',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'thecraft'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Thumbnail Cropping', 'thecraft' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'600 x 600' => 'square',
					'590 x 550' => 'rectangle',
					'480 x 470' => 'postgrid',
					'590 x 520' => 'rectangle2',
				),
				'std'		=> 'rectangle',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding.', 'thecraft'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 23px 30px 28px 30px', 'thecraft'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Background', 'thecraft'),
				'param_name' => 'content_background',
				'value' => '#f7f7f7',
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Hide Meta Post?', 'thecraft' ),
				'param_name' => 'hide_meta',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Box Shadow?', 'thecraft' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
	        // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'thecraft'),
				'param_name' => 'items',
				'value' => '3',
				'group' => esc_html__( 'Query', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'thecraft'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'thecraft' ),
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Excerpt Length', 'thecraft'),
				'param_name' => 'excerpt_lenght',
				'value' => '15',
				'description' => esc_html('The number of words you wish to display in the excerpt. Enter "0" to hide the excerpt.', 'thecraft'),
				'group' => esc_html__( 'Query', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Space Between', 'thecraft'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'thecraft' ),
				'description'	=> esc_html__('Important! Include the blur distance of the shadow.', 'thecraft'),
	        ),
			// Button
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text', 'thecraft'),
				'param_name' => 'button_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'thecraft' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'thecraft' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Simple Link' => 'simple_link',
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
				),
				'std'		=> 'accent',
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'thecraft' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'thecraft' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'small',
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Padding: Left & Right', 'thecraft' ),
				'param_name' => 'button_padding',
				'value'      => array(
					'Default' => '',
					'10px' => 'p10px',
					'15px' => 'p15px',
					'20px' => 'p20px',
					'25px' => 'p25px',
					'30px' => 'p30px',
					'35px' => 'p35px',
					'40px' => 'p40px',
					'45px' => 'p45px',
					'50px' => 'p50px',
					'55px' => 'p55px',
					'60px' => 'p60px',
					'65px' => 'p65px',
					'70px' => 'p70px',
					'75px' => 'p75px',
					'80px' => 'p80px',
					'85px' => 'p85px',
					'90px' => 'p90px',
					'95px' => 'p95px',
					'100px' => 'p100px',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'thecraft'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'thecraft'),
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Link Color', 'thecraft'),
				'param_name' => 'link_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'simple_link' ),
            ),
	        // Controls
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'thecraft' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'thecraft'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'thecraft' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'thecraft' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'thecraft' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'thecraft'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'thecraft' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Style', 'thecraft' ),
				'param_name' => 'arrow_style',
				'value'      => array(
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'dark',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'thecraft' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'thecraft' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'thecraft' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'thecraft' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'thecraft' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'thecraft' ),
				'param_name' => 'heading_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'thecraft' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'thecraft'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'thecraft'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'thecraft'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Excerpt', 'thecraft'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Excerpt Font Family', 'thecraft' ),
				'param_name' => 'desc_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Excerpt Font Weight', 'thecraft' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Excerpt Color', 'thecraft'),
				'param_name' => 'desc_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Excerpt Font Size', 'thecraft'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Excerpt Line-height', 'thecraft'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'thecraft'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'thecraft' ),
				'param_name' => 'button_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'thecraft' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'thecraft'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'thecraft'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'thecraft'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'thecraft'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'thecraft'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'thecraft'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	    )
	) );
} );

// ProgressBar
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Progress Bar', 'thecraft'),
        'description' => esc_html__('Displaying progress bars.', 'thecraft'),
        'base' => 'progressbar',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
        'params' => array(
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'thecraft'),
				'param_name' => 'title',
				'value' => esc_html__('Title', 'thecraft'),
				'description' => esc_html__('Title of the ProgressBar.', 'thecraft')
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'thecraft'),
				'param_name' => 'title_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Percentage', 'thecraft'),
				'param_name' => 'percent',
				'value' => '90',
				'description' => esc_html__('Percentage value of the ProgressBar', 'thecraft')
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Percentage Style', 'thecraft' ),
				'param_name' => 'percent_style',
				'value'      => array(
					'Simple' => 'pstyle-1',
					'Accent' => 'pstyle-2',
					'Grey' => 'pstyle-3',
				),
				'std'		=> 'pstyle-1',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Percentage Color', 'thecraft'),
				'param_name' => 'per_color',
				'value' => '',
				'dependency' => array( 'element' => 'percent_style', 'value' => 'style-1' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height of Bars', 'thecraft'),
				'param_name' => 'height',
				'value' => '10px',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Space between Text & Line', 'thecraft'),
				'param_name' => 'space_between',
				'value' => '10px',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'thecraft'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 5px', 'thecraft'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'thecraft'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'description'	=> esc_html__('Ex: 20px', 'thecraft'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 1', 'thecraft'),
				'param_name' => 'line_one',
				'value' => '#636363',
				'group' => esc_html__( 'Line Color', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 2', 'thecraft'),
				'param_name' => 'line_two',
				'value' => '#e5e5e5',
				'group' => esc_html__( 'Line Color', 'thecraft' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'thecraft' ),
				'param_name' => 'font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'thecraft' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'thecraft'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
        )
    ) );
} );

// Accordions
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_accordions extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Accordions', 'thecraft' ),
        'description' => esc_html__('Displaying Accordions', 'thecraft'),
		'base'        => 'accordions',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'accordion' ),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'thecraft' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
		)
	) );
} );

// Accordion
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Accordion', 'thecraft' ),
    'description' => esc_html__('Displaying Accordion', 'thecraft'),
		'base'        => 'accordion',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'js_composer'),
		'as_child'    => array( 'only' => 'accordions' ),
		'params'      => array(
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Active by default?', 'thecraft' ),
				'param_name' => 'open',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Bottom Margin', 'thecraft'),
				'param_name' => 'bottom_margin',
				'value' => 10,
				'suffix' => 'px',
				'description'	=> esc_html__('Default: 10px', 'thecraft'),
		  	),
			// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'thecraft' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading',
				'value' => '',
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Padding', 'thecraft'),
				'param_name' => 'heading_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 22px 15px 12px 60px', 'thecraft'),
				'group' => esc_html__( 'Heading', 'thecraft' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'thecraft'),
				'param_name' => 'heading_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 25px', 'thecraft'),
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
			// Icon
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Heading Icon?', 'thecraft' ),
				'param_name' => 'show_icon',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'thecraft' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'thecraft' ),
				'value' => array(
					esc_html__( '', 'thecraft' ) => '',
					esc_html__( 'Logistix Icons', 'thecraft' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'thecraft' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'thecraft' ) => 'openiconic',
					esc_html__( 'Typicons', 'thecraft' ) => 'typicons',
					esc_html__( 'Entypo', 'thecraft' ) => 'entypo',
					esc_html__( 'Linecons', 'thecraft' ) => 'linecons',
				),
				'group' => esc_html__( 'Heading', 'thecraft' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'thecraft' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Heading', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'thecraft'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Heading', 'thecraft' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between the heading and the icon', 'thecraft'),
				'param_name' => 'heading_left_padding',
				'value' => '30',
				'group' => esc_html__( 'Heading', 'thecraft' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
	        ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'thecraft'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'thecraft'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 20px 0px 23px 0px', 'thecraft'),
				'group' => esc_html__( 'Content', 'thecraft' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'thecraft' ),
				'param_name' => 'heading_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'thecraft' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'thecraft'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'thecraft'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
		)
	) );
} );

// Member Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Member Carousel', 'thecraft'),
	    'description' => esc_html__('Displaying member posts in carousel.', 'thecraft'),
	    'base' => 'member',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'thecraft'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'thecraft' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'590 x 550' => 'rectangle',
					'590 x 520' => 'rectangle2',
				),
				'std'		=> 'full',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'thecraft'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 8px 20px 35px 20px', 'thecraft'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'thecraft'),
				'param_name' => 'content_background',
				'value' => '#f6f6f6',
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Box Shadow?', 'thecraft' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
            // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'thecraft'),
				'param_name' => 'items',
				'value' => '4',
				'group' => esc_html__( 'Query', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'thecraft'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'thecraft' ),
				'description'	=> esc_html__('Display posts that have this category. Using category-slug.', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'thecraft'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'thecraft' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'thecraft' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'thecraft' ),
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'thecraft'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'thecraft' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'thecraft' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'thecraft' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'thecraft'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'thecraft' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Style', 'thecraft' ),
				'param_name' => 'arrow_style',
				'value'      => array(
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'dark',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'thecraft' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'thecraft' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'thecraft' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'thecraft' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'thecraft' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Name', 'thecraft'),
				'param_name' => 'name_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Family', 'thecraft' ),
				'param_name' => 'name_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Weight', 'thecraft' ),
				'param_name' => 'name_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Name Color', 'thecraft'),
				'param_name' => 'name_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Font Size', 'thecraft'),
				'param_name' => 'name_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Line-Height', 'thecraft'),
				'param_name' => 'name_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'thecraft'),
				'param_name' => 'position_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Family', 'thecraft' ),
				'param_name' => 'position_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Weight', 'thecraft' ),
				'param_name' => 'position_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Position Color', 'thecraft'),
				'param_name' => 'position_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Font Size', 'thecraft'),
				'param_name' => 'position_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Line-Height', 'thecraft'),
				'param_name' => 'position_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			// Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Top Margin', 'thecraft'),
				'param_name' => 'name_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Bottom Margin', 'thecraft'),
				'param_name' => 'name_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Top Margin', 'thecraft'),
				'param_name' => 'position_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Bottom Margin', 'thecraft'),
				'param_name' => 'position_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	    )
	) );
} );

// Member Grid
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Member Grid', 'thecraft'),
	    'description' => esc_html__('Displaying member posts in grid.', 'thecraft'),
	    'base' => 'membergrid',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'thecraft'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'thecraft' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'590 x 550' => 'rectangle',
					'590 x 520' => 'rectangle2',
				),
				'std'		=> 'full',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'thecraft'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 8px 20px 35px 20px', 'thecraft'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'thecraft'),
				'param_name' => 'content_background',
				'value' => '#f6f6f6',
            ),
            array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Box Shadow?', 'thecraft' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
            // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'thecraft'),
				'param_name' => 'items',
				'value' => '3',
				'group' => esc_html__( 'Query', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'thecraft'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'thecraft' ),
				'description'	=> esc_html__('Display posts that have this category. Using category-slug.', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'thecraft'),
				'param_name' => 'gapv',
				'value' => '30',
				'group' => esc_html__( 'Query', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'thecraft'),
				'param_name' => 'gaph',
				'value' => '40',
				'group' => esc_html__( 'Query', 'thecraft' ),
	        ),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Column(s)', 'thecraft' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '3c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Name', 'thecraft'),
				'param_name' => 'name_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Family', 'thecraft' ),
				'param_name' => 'name_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Weight', 'thecraft' ),
				'param_name' => 'name_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Name Color', 'thecraft'),
				'param_name' => 'name_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Font Size', 'thecraft'),
				'param_name' => 'name_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Line-Height', 'thecraft'),
				'param_name' => 'name_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'thecraft'),
				'param_name' => 'position_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Family', 'thecraft' ),
				'param_name' => 'position_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Weight', 'thecraft' ),
				'param_name' => 'position_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Position Color', 'thecraft'),
				'param_name' => 'position_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Font Size', 'thecraft'),
				'param_name' => 'position_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Line-Height', 'thecraft'),
				'param_name' => 'position_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			// Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Top Margin', 'thecraft'),
				'param_name' => 'name_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Bottom Margin', 'thecraft'),
				'param_name' => 'name_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Top Margin', 'thecraft'),
				'param_name' => 'position_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Bottom Margin', 'thecraft'),
				'param_name' => 'position_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	    )
	) );
} );

// Action Box
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Action Box', 'thecraft'),
	    'description' => esc_html__('Displaying Action-Box or Promo-Box.', 'thecraft'),
	    'base' => 'actionbox',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'thecraft'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Showcase', 'thecraft' ),
				'param_name' => 'showcase',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Padding', 'thecraft'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'thecraft'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap Background Color', 'thecraft'),
				'param_name' => 'background',
				'value' => '',
            ),
            // Content
			array(
				'type' => 'number',
				'heading' => esc_html__('Content Wrap: Width', 'thecraft'),
				'param_name' => 'left_width',
				'value' => 65,
				'suffix' => '%',
				'group' => esc_html__( 'Content', 'thecraft' ),
		  	),
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading_content',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'thecraft' ),
				'param_name' => 'heading_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading Text', 'thecraft'),
				'param_name' => 'heading_text',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'thecraft'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
			// Icon
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Heading Icon?', 'thecraft' ),
				'param_name' => 'show_icon',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'thecraft' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'thecraft' ),
				'value' => array(
					esc_html__( '', 'thecraft' ) => '',
					esc_html__( 'Logistix Icons', 'thecraft' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'thecraft' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'thecraft' ) => 'openiconic',
					esc_html__( 'Typicons', 'thecraft' ) => 'typicons',
					esc_html__( 'Entypo', 'thecraft' ) => 'entypo',
					esc_html__( 'Linecons', 'thecraft' ) => 'linecons',
				),
				'group' => esc_html__( 'Content', 'thecraft' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'thecraft' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'thecraft'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'thecraft'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
	        ),
            // Button
			array(
				'type' => 'number',
				'heading' => esc_html__('Button Wrap: Width', 'thecraft'),
				'param_name' => 'right_width',
				'value' => 35,
				'suffix' => '%',
				'group' => esc_html__( 'Button', 'thecraft' ),
		  	),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'thecraft' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Padding: Left & Right', 'thecraft' ),
				'param_name' => 'button_padding',
				'value'      => array(
					'Default' => '',
					'10px' => 'p10px',
					'15px' => 'p15px',
					'20px' => 'p20px',
					'25px' => 'p25px',
					'30px' => 'p30px',
					'35px' => 'p35px',
					'40px' => 'p40px',
					'45px' => 'p45px',
					'50px' => 'p50px',
					'55px' => 'p55px',
					'60px' => 'p60px',
					'65px' => 'p65px',
					'70px' => 'p70px',
					'75px' => 'p75px',
					'80px' => 'p80px',
					'85px' => 'p85px',
					'90px' => 'p90px',
					'95px' => 'p95px',
					'100px' => 'p100px',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'thecraft' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'thecraft' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Button Text', 'thecraft'),
				'param_name' => 'button_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'thecraft' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'thecraft'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'thecraft'),
				'group' => esc_html__( 'Button', 'thecraft' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button link (URL):', 'thecraft'),
				'param_name' => 'button_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'thecraft' ),
            ),
            // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'thecraft' ),
				'param_name' => 'heading_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'thecraft' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'thecraft'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line-Height', 'thecraft'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Letter Spacing', 'thecraft'),
				'param_name' => 'heading_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        // Buttons
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'thecraft'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button: Font Family', 'thecraft' ),
				'param_name' => 'button_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button: Font Weight', 'thecraft' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: Font Size', 'thecraft'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: Line-Height', 'thecraft'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'thecraft'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'thecraft'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: Top Margin', 'thecraft'),
				'param_name' => 'button_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: Bottom Margin', 'thecraft'),
				'param_name' => 'button_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	    )
	) );
} );

// Menu List
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Menu List', 'thecraft'),
	    'description' => esc_html__('Menu List.', 'thecraft'),
	    'base' => 'menulist',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'params'      => array(
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'thecraft'),
				'param_name' => 'background',
				'value' => '#f8f8f8',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'thecraft'),
				'param_name' => 'border_color',
				'value' => '#f1f1f1',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'thecraft'),
				'param_name' => 'border_width',
				'value' => '1px',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'thecraft' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'thecraft'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 12px 30px 12px 30px', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'thecraft'),
				'param_name' => 'bottom_margin',
				'value' => '10',
	        ),
	        // Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'thecraft'),
				'param_name' => 'text_content',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Text', 'thecraft'),
				'param_name' => 'text',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'thecraft'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Top Padding', 'thecraft'),
				'param_name' => 'text_padding',
				'value' => '5px',
				'group' => esc_html__( 'Content', 'thecraft' ),
				'dependency' => array( 'element' => 'value_style', 'value' => 'background' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Value', 'thecraft'),
				'param_name' => 'value_content',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value Style', 'thecraft' ),
				'param_name' => 'value_style',
				'value'      => array(
					'Background' => 'background',
					'Simple' => 'simple',
				),
				'std'		=> 'background',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Value', 'thecraft'),
				'param_name' => 'value',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'thecraft'),
				'param_name' => 'value_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'thecraft'),
				'param_name' => 'value_background',
				'value' => '',
				'dependency' => array( 'element' => 'value_style', 'value' => 'background' ),
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'thecraft'),
				'param_name' => 'value_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 3px 10px 3px 10px', 'thecraft'),
				'dependency' => array( 'element' => 'value_style', 'value' => 'background' ),
				'group' => esc_html__( 'Content', 'thecraft' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'thecraft'),
				'param_name' => 'value_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 3px', 'thecraft'),
				'dependency' => array( 'element' => 'value_style', 'value' => 'background' ),
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'thecraft'),
				'param_name' => 'text_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Family', 'thecraft' ),
				'param_name' => 'text_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Weight', 'thecraft' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Font Size', 'thecraft'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Value', 'thecraft'),
				'param_name' => 'value_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value: Font Family', 'thecraft' ),
				'param_name' => 'value_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value: Font Weight', 'thecraft' ),
				'param_name' => 'value_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Value: Font Size', 'thecraft'),
				'param_name' => 'value_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
		)
	) );
} );

// Info List
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Info List', 'thecraft'),
	    'description' => esc_html__('Information List.', 'thecraft'),
	    'base' => 'infolist',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow', 'thecraft' ),
				'param_name' => 'arrow',
				'value'      => array(
					'No Arrow'		=> 'simple',
					'Arrow Style 1'		=> 'style-1',
					'Arrow Style 2'		=> 'style-2',
				),
				'std'		=> 'simple',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'thecraft'),
				'param_name' => 'padding',
				'value' => '10px 0px 10px 0px',
				'description'	=> esc_html__('Top Right Bottom Left.', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'thecraft'),
				'param_name' => 'margin',
				'value' => '0px 0px 0px 0px',
				'description'	=> esc_html__('Top Right Bottom Left.', 'thecraft'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'thecraft'),
				'param_name' => 'border_color',
				'value' => '#dddddd',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'thecraft'),
				'param_name' => 'border_width',
				'value' => '1px 0px 1px 0px',
				'description'	=> esc_html__('Ex: 1px 0px 1px 0px', 'thecraft'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'thecraft' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
	        // Title
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'thecraft'),
				'param_name' => 'title',
				'value' => '',
				'group' => esc_html__( 'Title', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Title Color', 'thecraft'),
				'param_name' => 'title_color',
				'value' => '',
				'group' => esc_html__( 'Title', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title: Width', 'thecraft'),
				'param_name' => 'title_width',
				'value' => '150px',
				'group' => esc_html__( 'Title', 'thecraft' ),
	        ),
	        // Text
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Text', 'thecraft'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Text', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'thecraft'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Text', 'thecraft' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Title', 'thecraft'),
				'param_name' => 'title_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title: Font Family', 'thecraft' ),
				'param_name' => 'title_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title: Font Weight', 'thecraft' ),
				'param_name' => 'title_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title: Font Size', 'thecraft'),
				'param_name' => 'title_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'thecraft'),
				'param_name' => 'text_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Family', 'thecraft' ),
				'param_name' => 'text_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Weight', 'thecraft' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Font Size', 'thecraft'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
		)
	) );
} );

// Image Box
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Image Box', 'thecraft'),
	    'description' => esc_html__('Displaying image box.', 'thecraft'),
	    'base' => 'imagebox',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'thecraft'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
			),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'thecraft'),
				'param_name' => 'image',
				'value' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'thecraft' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'590 x 550' => 'rectangle',
					'590 x 520' => 'rectangle2',
					'870 x auto' => 'auto1',
					'600 x auto' => 'auto2',
					'480 x auto' => 'auto3',
				),
				'std'		=> 'full',
				'description'	=> esc_html__('Select "auto" to keep the same aspect ratio when cropping.', 'thecraft'),
			),
			// Icon
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Icon?', 'thecraft' ),
				'param_name' => 'show_icon',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'thecraft' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'thecraft' ),
				'value' => array(
					esc_html__( '', 'thecraft' ) => '',
					esc_html__( 'Logistix Icons', 'thecraft' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'thecraft' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'thecraft' ) => 'openiconic',
					esc_html__( 'Typicons', 'thecraft' ) => 'typicons',
					esc_html__( 'Entypo', 'thecraft' ) => 'entypo',
					esc_html__( 'Linecons', 'thecraft' ) => 'linecons',
				),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'thecraft' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Box Shadow?', 'thecraft' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			// Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'hading_content',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'thecraft'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 23px 30px 28px 30px', 'thecraft'),
				'group' => esc_html__( 'Content', 'thecraft' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Background Style', 'thecraft' ),
				'param_name' => 'background',
				'value'      => array(
					'Transparent' => 'style-1',
					'Accent' => 'style-2',
					'Dark Accent' => 'style-3',
					'Light Accent' => 'style-4',
					'Custom' => 'style-5',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Background Color', 'thecraft'),
				'param_name' => 'background_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
				'dependency' => array( 'element' => 'background', 'value' => 'style-5' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'thecraft' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Style', 'thecraft' ),
				'param_name' => 'heading_style',
				'value'      => array(
					'Simple' => 'style-1',
					'Background' => 'style-2',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background: Color', 'thecraft'),
				'param_name' => 'line_bg_color',
				'value' => '#b9e9e9',
				'dependency' => array( 'element' => 'heading_style', 'value' => 'style-2' ),
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Background: Height', 'thecraft'),
				'param_name' => 'line_bg_height',
				'value' => '13px',
				'dependency' => array( 'element' => 'heading_style', 'value' => 'style-2' ),
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Padding', 'thecraft'),
				'param_name' => 'heading_padding',
				'value' => '0px 5% 3px 5%',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'thecraft'),
				'dependency' => array( 'element' => 'heading_style', 'value' => 'style-2' ),
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading',
				'value' => 'Heading Text',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'thecraft'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Separator', 'thecraft'),
				'param_name' => 'separator_content',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator', 'thecraft' ),
				'param_name' => 'separator',
				'value'      => array(
					'No Separator' => '',
					'Line' => 'line'
				),
				'std'		=> '',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line: Full-width', 'thecraft' ),
				'param_name' => 'line_full',
				'value'      => array(
					'No' => 'no',
					'Yes' => 'yes',
				),
				'std'		=> 'no',
				'group' => esc_html__( 'Content', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'thecraft'),
				'param_name' => 'line_width',
				'value' => '50',
				'group' => esc_html__( 'Content', 'thecraft' ),
				'dependency' => array( 'element' => 'line_full', 'value' => 'no' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'thecraft'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Content', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'thecraft'),
				'param_name' => 'line_color',
				'value' => '#eee',
				'group' => esc_html__( 'Content', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'thecraft'),
				'param_name' => 'desc_content',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type' 		=> 'textarea',
				'heading' 	=> esc_html__('Description', 'thecraft'),
				'param_name' 	=> 'description',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'thecraft'),
				'param_name' => 'desc_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
	        // Button
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text', 'thecraft'),
				'param_name' => 'button_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'thecraft' ),
				'description'	=> esc_html__('Leave it empty to disable.', 'thecraft'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'thecraft' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Simple Link' => 'simple_link',
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
				),
				'std'		=> 'accent',
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Padding: Left & Right', 'thecraft' ),
				'param_name' => 'button_padding',
				'value'      => array(
					'Default' => '',
					'10px' => 'p10px',
					'15px' => 'p15px',
					'20px' => 'p20px',
					'25px' => 'p25px',
					'30px' => 'p30px',
					'35px' => 'p35px',
					'40px' => 'p40px',
					'45px' => 'p45px',
					'50px' => 'p50px',
					'55px' => 'p55px',
					'60px' => 'p60px',
					'65px' => 'p65px',
					'70px' => 'p70px',
					'75px' => 'p75px',
					'80px' => 'p80px',
					'85px' => 'p85px',
					'90px' => 'p90px',
					'95px' => 'p95px',
					'100px' => 'p100px',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array('element' => 'button_style', 'value' => array('accent','dark','light','very-light','white','outline','outline_dark','outline_light','outline_very-light','outline_white' ) ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'thecraft' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'thecraft' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'small',
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'thecraft'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'thecraft'),
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Link Color', 'thecraft'),
				'param_name' => 'link_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'simple_link' ),
            ),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'thecraft'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'thecraft' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'thecraft' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Hyperlink', 'thecraft' ),
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'thecraft' ),
				'param_name' => 'heading_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'thecraft' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'thecraft'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'thecraft'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'thecraft'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Family', 'thecraft' ),
				'param_name' => 'desc_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Weight', 'thecraft' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Font Size', 'thecraft'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'thecraft'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'thecraft'),
				'param_name' => 'btn_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'thecraft' ),
				'param_name' => 'button_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'thecraft' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'thecraft'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'thecraft'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'thecraft'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'thecraft'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Separator: Top Margin', 'thecraft'),
				'param_name' => 'sep_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Separator: Bottom Margin', 'thecraft'),
				'param_name' => 'sep_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'thecraft'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'thecraft'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	    )
	) );
} );

// Images Grid
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name' => esc_html__( 'Images Grid', 'thecraft' ),
		'description' => esc_html__('Displaying images in masonry or mosaic grid.', 'thecraft'),
		'base' => 'imagesgrid',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Layout', 'thecraft' ),
				'param_name' => 'mode',
				'value'      => array(
					'Masonry' => 'grid',
					'Slider' => 'slider',
				),
				'std'		=> 'grid',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'thecraft' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'600 x 600' => 'square',
					'590 x 550' => 'rectangle',
					'590 x 520' => 'rectangle2',
					'870 x auto' => 'auto1',
					'600 x auto' => 'auto2',
					'480 x auto' => 'auto3',
					'Full' => 'full',
				),
				'std'		=> 'auto2',
				'description'	=> esc_html__('Choose auto option to keep the same aspect ratio when cropping.', 'thecraft'),
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Images', 'thecraft'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for Images Grid.', 'thecraft')
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'thecraft'),
				'param_name' => 'gapv',
				'value' => '30',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'thecraft'),
				'param_name' => 'gaph',
				'value' => '30',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Auto Scroll?', 'thecraft' ),
				'param_name' => 'auto',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'dependency' => array( 'element' => 'mode', 'value' => 'slider' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px.', 'thecraft' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Column Options', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '4c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px.', 'thecraft' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Column Options', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px.', 'thecraft' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Column Options', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px.', 'thecraft' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Column Options', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
		)
	) );
} );

// List Advanced
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'List Advanced', 'thecraft' ),
        'description' => esc_html__('Displaying Icon lists with custom icon.', 'thecraft'),
		'base'        => 'advlist',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'thecraft' ),
				'param_name' => 'style',
				'value'      => array(
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
				),
				'std'		=> 'icon-left',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'thecraft' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'Icon Font' => 'icon-font',
					'Icon Image' => 'icon-image',
				),
				'std'		=> 'icon-font',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'thecraft'),
				'param_name' => 'content_background_color',
				'value' => '#f8f8f8',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'thecraft' ),
				'param_name' => 'content_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'thecraft'),
				'param_name' => 'content_border_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'thecraft'),
				'param_name' => 'content_border_width',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 1px 2px 2px 1px', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'thecraft'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 12px 30px 12px 30px', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'thecraft'),
				'param_name' => 'content_bottom_margin',
				'value' => '10',
	        ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'thecraft'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Image', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width', 'thecraft'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 50px', 'thecraft'),
				'group' => esc_html__( 'Image', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
	        ),
			// Icon
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Style', 'thecraft' ),
				'param_name' => 'icon_style',
				'value'      => array(
					'Simple' => 'style-1',
					'Circle Accent' => 'style-2',
					'Circle Light' => 'style-3',
					'Circle Dark' => 'style-4',
					'Square Accent' => 'style-5',
					'Square Light' => 'style-6',
					'Square Dark' => 'style-7',
				),
				'std'		=> 'style-2',
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'thecraft' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'thecraft' ),
				'value' => array(
					esc_html__( '', 'thecraft' ) => '',
					esc_html__( 'Logistix Icons', 'thecraft' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'thecraft' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'thecraft' ) => 'openiconic',
					esc_html__( 'Typicons', 'thecraft' ) => 'typicons',
					esc_html__( 'Entypo', 'thecraft' ) => 'entypo',
					esc_html__( 'Linecons', 'thecraft' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'thecraft' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'thecraft'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'thecraft'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Position', 'thecraft' ),
				'param_name' => 'icon_position',
				'value'      => array(
					'Middle' => 'middle',
					'Top' => 'top',
				),
				'std'		=> 'middle',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			// Content
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Content', 'thecraft' ),
				'param_name' => 'content',
				'group' => esc_html__( 'Content', 'thecraft' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Color', 'thecraft'),
				'param_name' => 'content_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Left Padding', 'thecraft'),
				'param_name' => 'content_left_padding',
				'value' => '30',
				'group' => esc_html__( 'Content', 'thecraft' ),
				'description'	=> esc_html__('Spacing between the icon and the content', 'thecraft'),
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left' ),
	        ),
	        // Hyperlink
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Hyperlink on text?', 'thecraft' ),
				'param_name' => 'hyperlink',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
				'group' => esc_html__( 'Hyperlink', 'thecraft' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'thecraft'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'thecraft' ),
				'dependency' => array( 'element' => 'hyperlink', 'value' => 'yes' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Font Family', 'thecraft' ),
				'param_name' => 'content_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Font Weight', 'thecraft' ),
				'param_name' => 'content_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Font Size', 'thecraft'),
				'param_name' => 'content_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Line-Height', 'thecraft'),
				'param_name' => 'content_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
		)
	) );
} );

// Icon Box
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icon Box', 'thecraft' ),
        'description' => esc_html__('Displaying Icon Box with custom icon.', 'thecraft'),
		'base'        => 'iconbox',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'thecraft' ),
				'param_name' => 'style',
				'value'      => array(
					'Icon Top' => 'icon-top',
					'Icon Top 2' => 'icon-top2',
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
					'Icon Left 2' => 'icon-left2',
				),
				'std'		=> 'icon-top',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'thecraft' ),
				'param_name' => 'text_align',
				'value'      => array(
					'Left' => 'align-left',
					'Center' => 'align-center',
					'Right' => 'align-right',
				),
				'std'		=> 'align-left',
				'dependency' => array( 'element' => 'style', 'value' => 'icon-top' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap Background', 'thecraft'),
				'param_name' => 'wrap_background',
				'value' => '#f7f7f7',
				'dependency' => array( 'element' => 'style', 'value' => 'icon-top2' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Padding', 'thecraft'),
				'param_name' => 'wrap_padding',
				'description'	=> esc_html__('Top Right Bottom Left.', 'thecraft'),
				'dependency' => array( 'element' => 'style', 'value' => 'icon-top2' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'thecraft' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'Icon Font' => 'icon-font',
					'Icon Image' => 'icon-image',
				),
				'std'		=> 'icon-font',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Showcase', 'thecraft' ),
				'param_name' => 'icon_showcase',
				'value'      => array(
					'Simple' => 'simple',
					'Accent Background' => 'accent-bg',
					'Dark Background' => 'dark-bg',
					'Grey Background' => 'grey-bg',
					'Accent Outline' => 'accent-outline',
					'Dark Outline' => 'dark-outline',
					'Grey Outline' => 'grey-outline',
				),
				'std'		=> 'accent-bg',
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Wrap Width', 'thecraft' ),
				'param_name' => 'icon_width',
				'value'      => array(
					'50px' => 'w50',
					'55px' => 'w55',
					'60px' => 'w60',
					'65px' => 'w65',
					'70px' => 'w70',
					'70px' => 'w70',
					'73px' => 'w73',
					'80px' => 'w80',
					'85px' => 'w85',
					'90px' => 'w90',
					'95px' => 'w95',
					'100px' => 'w100',
					'105px' => 'w105',
					'110px' => 'w110',
					'115px' => 'w115',
					'120px' => 'w120',
					'125px' => 'w125',
					'130px' => 'w130',
				),
				'std'		=> 'w60',
				'dependency' => array( 'element' => 'icon_showcase', 'value' => array( 'accent-bg', 'dark-bg', 'grey-bg', 'accent-outline', 'dark-outline', 'grey-outline' ) ),
			),
	        array(
				'type'       => 'dropdown',
				'heading' => esc_html__('Icon Wrap Rounded', 'thecraft'),
				'param_name' => 'icon_rounded',
				'value'      => array(
					'Square' => '',
					'Circle ' => 'rounded-100',
					'1 Pixel' => 'rounded-1',
					'2 Pixels' => 'rounded-2',
					'3 Pixels' => 'rounded-3',
					'5 Pixels' => 'rounded-5',
					'10 Pixels' => 'rounded-10',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'icon_showcase', 'value' => array( 'accent-bg', 'dark-bg', 'grey-bg', 'accent-outline', 'dark-outline', 'grey-outline' ) ),
	        ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'thecraft' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'thecraft' ),
				'value' => array(
					esc_html__( '', 'thecraft' ) => '',
					esc_html__( 'Logistix Icons', 'thecraft' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'thecraft' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'thecraft' ) => 'openiconic',
					esc_html__( 'Typicons', 'thecraft' ) => 'typicons',
					esc_html__( 'Entypo', 'thecraft' ) => 'entypo',
					esc_html__( 'Linecons', 'thecraft' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'thecraft' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'thecraft'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_showcase', 'value' => 'simple' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'thecraft'),
				'param_name' => 'icon_font_size',
				'value' => '30px',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'thecraft'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Image', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width', 'thecraft'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 100px', 'thecraft'),
				'group' => esc_html__( 'Image', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
	        ),
			// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Style', 'thecraft' ),
				'param_name' => 'heading_style',
				'value'      => array(
					'Simple' => 'style-1',
					'Background' => 'style-2',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background: Color', 'thecraft'),
				'param_name' => 'gb_color',
				'value' => '#b9e9e9',
				'dependency' => array( 'element' => 'heading_style', 'value' => 'style-2' ),
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Background: Height', 'thecraft'),
				'param_name' => 'bg_height',
				'value' => '13px',
				'dependency' => array( 'element' => 'heading_style', 'value' => 'style-2' ),
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Padding', 'thecraft'),
				'param_name' => 'padding',
				'value' => '0px 5% 3px 5%',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'thecraft'),
				'dependency' => array( 'element' => 'heading_style', 'value' => 'style-2' ),
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'thecraft' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading',
				'value' => '',
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'thecraft'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
			// Description
			array(
				'type' => 'textarea',
				'heading' => esc_html__( 'Description', 'thecraft' ),
				'param_name' => 'description',
				'group' => esc_html__( 'Content', 'thecraft' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'thecraft'),
				'param_name' => 'desc_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
			// Button
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show button?', 'thecraft' ),
				'param_name' => 'show_button',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'thecraft' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Simple Link' => 'simple_link',
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
				),
				'std'		=> 'accent',
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array( 'element' => 'show_button', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'thecraft' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'thecraft' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'small',
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Padding: Left & Right', 'thecraft' ),
				'param_name' => 'button_padding',
				'value'      => array(
					'Default' => '',
					'10px' => 'p10px',
					'15px' => 'p15px',
					'20px' => 'p20px',
					'25px' => 'p25px',
					'30px' => 'p30px',
					'35px' => 'p35px',
					'40px' => 'p40px',
					'45px' => 'p45px',
					'50px' => 'p50px',
					'55px' => 'p55px',
					'60px' => 'p60px',
					'65px' => 'p65px',
					'70px' => 'p70px',
					'75px' => 'p75px',
					'80px' => 'p80px',
					'85px' => 'p85px',
					'90px' => 'p90px',
					'95px' => 'p95px',
					'100px' => 'p100px',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array('element' => 'button_style', 'value' => array('accent','dark','light','very-light','white','outline','outline_dark','outline_light','outline_very-light','outline_white' ) ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'thecraft'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'thecraft'),
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Link Color', 'thecraft'),
				'param_name' => 'link_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'simple_link' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text (Required)', 'thecraft'),
				'param_name' => 'button_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'thecraft' ),
				'dependency' => array( 'element' => 'show_button', 'value' => 'yes' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link URL (Required):', 'thecraft'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'thecraft' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'thecraft' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'thecraft' ),
				'param_name' => 'heading_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'thecraft' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'thecraft'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'thecraft'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'thecraft'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Family', 'thecraft' ),
				'param_name' => 'desc_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Weight', 'thecraft' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Font Size', 'thecraft'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'thecraft'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'thecraft'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'thecraft' ),
				'param_name' => 'button_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'thecraft' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'thecraft'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'thecraft'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Left Padding', 'thecraft'),
				'param_name' => 'content_left_padding',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'thecraft' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Right Padding', 'thecraft'),
				'param_name' => 'content_right_padding',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'thecraft' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-right' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Left Margin', 'thecraft'),
				'param_name' => 'heading_left_margin',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'thecraft' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left2' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'thecraft'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'thecraft'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'thecraft'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'thecraft'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
		)
	) );
} );

// PriceTable
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Price Table', 'thecraft' ),
        'description' => esc_html__('Displaying Price Tables.', 'thecraft'),
		'base'        => 'pricetable',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'params'      => array(
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap: Border Color', 'thecraft'),
				'param_name' => 'border_color',
				'value' => '',
            ),
			// Heading
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading',
				'value' => 'GOLD',
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'thecraft'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading: Background', 'thecraft'),
				'param_name' => 'heading_background',
				'value' => '',
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
			// Price
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Price', 'thecraft'),
				'param_name' => 'price',
				'value' => '25',
				'description'	=> esc_html__('The price for this package.', 'thecraft'),
				'group' => esc_html__( 'Price', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Price Color', 'thecraft'),
				'param_name' => 'price_color',
				'value' => '',
				'group' => esc_html__( 'Price', 'thecraft' ),
            ),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Price Unit', 'thecraft' ),
				'param_name' => 'price_unit',
				'value' => '/MO',
				'description'	=> esc_html__('The price unit for this package.', 'thecraft'),
				'group' => esc_html__( 'Price', 'thecraft' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Price Unit Color', 'thecraft'),
				'param_name' => 'unit_color',
				'value' => '',
				'group' => esc_html__( 'Price', 'thecraft' ),
            ),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Price Wrap: Background', 'thecraft'),
				'param_name' => 'price_background',
				'value' => '',
				'group' => esc_html__( 'Price', 'thecraft' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Price Wrap: Padding', 'thecraft' ),
				'param_name' => 'price_padding',
				'value' => '78px 0 52px 0',
				'description'	=> esc_html__('Top Right Bottom Left.', 'thecraft'),
				'group' => esc_html__( 'Price', 'thecraft' ),
			),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'thecraft'),
				'param_name' 	=> 'content',
				'description'	=> esc_html__('Create the features list using un-ordered list elements.', 'thecraft'),
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Wrap: Background', 'thecraft'),
				'param_name' => 'content_background',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Color', 'thecraft'),
				'param_name' => 'content_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Content Wrap: Padding', 'thecraft' ),
				'param_name' => 'content_padding',
				'value' => '33px 42px 42px 46px',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 30px 0px 30px 0px', 'thecraft'),
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			// Button
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'thecraft' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'thecraft' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'thecraft' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Padding: Left & Right', 'thecraft' ),
				'param_name' => 'btn_padding',
				'value'      => array(
					'Default' => '',
					'10px' => 'p10px',
					'15px' => 'p15px',
					'20px' => 'p20px',
					'25px' => 'p25px',
					'30px' => 'p30px',
					'35px' => 'p35px',
					'40px' => 'p40px',
					'45px' => 'p45px',
					'50px' => 'p50px',
					'55px' => 'p55px',
					'60px' => 'p60px',
					'65px' => 'p65px',
					'70px' => 'p70px',
					'75px' => 'p75px',
					'80px' => 'p80px',
					'85px' => 'p85px',
					'90px' => 'p90px',
					'95px' => 'p95px',
					'100px' => 'p100px',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'thecraft'),
				'param_name' => 'btn_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 10px', 'thecraft'),
				'group' => esc_html__( 'Button', 'thecraft' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Button: Margin', 'thecraft' ),
				'param_name' => 'btn_margin',
				'value' => '37px 0px 0px 0px',
				'description'	=> esc_html__('Top Right Bottom Left.', 'thecraft'),
				'group' => esc_html__( 'Button', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text', 'thecraft'),
				'param_name' => 'button_text',
				'value' => 'CHOOSE PLAN',
				'group' => esc_html__( 'Button', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Link (URL)', 'thecraft'),
				'param_name' => 'button_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'thecraft' ),
	        ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'thecraft' ),
				'param_name' => 'heading_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'thecraft' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'thecraft'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'thecraft'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Price', 'thecraft'),
				'param_name' => 'price_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Price Font Family', 'thecraft' ),
				'param_name' => 'price_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Price Font Weight', 'thecraft' ),
				'param_name' => 'price_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Price Font Size', 'thecraft'),
				'param_name' => 'price_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Price Line-Height', 'thecraft'),
				'param_name' => 'price_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Unit', 'thecraft'),
				'param_name' => 'unit_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Unit Font Family', 'thecraft' ),
				'param_name' => 'unit_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Unit Font Weight', 'thecraft' ),
				'param_name' => 'unit_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Unit Font Size', 'thecraft'),
				'param_name' => 'unit_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Unit Line-Height', 'thecraft'),
				'param_name' => 'unit_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
		)
	) );
} );

// Grid Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_gridbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Grid Box', 'thecraft'),
		'description' => esc_html__('Grid Box.', 'thecraft'),
		'base' => 'gridbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'gridbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Width', 'thecraft' ),
				'param_name' => 'border_width',
				'value' => array(
					'1px' => 'w1',
					'2px' => 'w2',
				),
				'std'		=> 'w1',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Color', 'thecraft' ),
				'param_name' => 'border_color',
				'value' => array(
					'Light' => 'light',
					'Very Light' => 'very-light',
				),
				'std'		=> 'light',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Style', 'thecraft' ),
				'param_name' => 'border_style',
				'value' => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'dotted',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Border Wrap?', 'thecraft' ),
				'param_name' => 'wrap',
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'true',
			),
        )
    ) );
} );

// Content Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_contentbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Content Box', 'thecraft'),
		'description' => esc_html__('Content Box.', 'thecraft'),
		'base' => 'contentbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'contentbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'js_view' => 'VcColumnView',
		'params' => array(
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'thecraft'),
				'param_name' => 'border_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'thecraft'),
				'param_name' => 'border_width',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 1px 1px 1px 1px', 'thecraft'),
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Hide Border on Moblie?', 'thecraft' ),
				'param_name' => 'hide_boder',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'thecraft'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 6px', 'thecraft'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Hide This Box on Moblie?', 'thecraft' ),
				'param_name' => 'hide_on_mobile',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
            // Background
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Background Color Style', 'thecraft' ),
				'param_name' => 'background',
				'value'      => array(
					'Transparent' => 'style-1',
					'Accent' => 'style-2',
					'Dark Accent' => 'style-3',
					'Light Accent' => 'style-4',
					'Custom' => 'style-5',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Background', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'thecraft'),
				'param_name' => 'background_color',
				'value' => '',
				'group' => esc_html__( 'Background', 'thecraft' ),
				'dependency' => array( 'element' => 'background', 'value' => 'style-5' ),
            ),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'thecraft'),
				'param_name' => 'bg_image',
				'value' => '',
				'group' => esc_html__( 'Background', 'thecraft' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Position', 'thecraft' ),
				'param_name'  => 'bg_position',
				'value'       => array(
					'Left Top' => 'lt',
					'Right Top' => 'rt',
					'Center Top' => 'ct',
					'Center Center' => 'cc',
					'Center Bottom'   => 'cb',
					'Left Bottom' => 'lb',
					'Right Bottom'   => 'rb',
				),
				'std'		=> 'lt',
				'group' => esc_html__( 'Background', 'thecraft' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Repeat', 'thecraft' ),
				'param_name'  => 'bg_repeat',
				'value'       => array(
					'No Repeat' => 'no-repeat',
					'Repeat'   => 'repeat',
					'Repeat X'   => 'repeat-x',
					'Repeat Y'   => 'repeat-y',
				),
				'std'		=> 'no-repeat',
				'group' => esc_html__( 'Background', 'thecraft' ),
			),
            // Padding & Margin
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'thecraft'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'thecraft'),
				'group' => esc_html__( 'Padding & Margins', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding on mobile', 'thecraft'),
				'param_name' => 'mobile_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'thecraft'),
				'group' => esc_html__( 'Padding & Margins', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'thecraft'),
				'param_name' => 'margin',
				'value' => '',
				'group' => esc_html__( 'Padding & Margins', 'thecraft' ),
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin on mobile', 'thecraft'),
				'param_name' => 'mobile_margin',
				'value' => '',
				'group' => esc_html__( 'Padding & Margins', 'thecraft' ), 
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'thecraft'),
	        ),
			// Box Shadow
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'thecraft'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'thecraft' ),
				'description'	=> esc_html__('Ex: 0px', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'thecraft'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'thecraft' ),
				'description'	=> esc_html__('Ex: 5px', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'thecraft'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'thecraft' ),
				'description'	=> esc_html__('Ex: 30px', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'thecraft'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'thecraft' ),
				'description'	=> esc_html__('Ex: 0px', 'thecraft'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Box Shadow Color (Required)', 'thecraft'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'thecraft' ),
				'description'	=> esc_html__('Ex: #eeeeee', 'thecraft'),
            ),
        )
    ) );
} );

// Single Heading
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Single Heading', 'thecraft' ),
        'description' => esc_html__('Displaying Single Heading.', 'thecraft'),
		'base'        => 'singleheading',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'params'      => array(
	        // Content
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'thecraft' ),
				'param_name' => 'style',
				'value'      => array(
					'Simple' => 'style-1',
					'Line' => 'style-2',
					'Background' => 'style-3',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background: Color', 'thecraft'),
				'param_name' => 'gb_color',
				'value' => '#b9e9e9',
				'dependency' => array( 'element' => 'style', 'value' => 'style-3' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Background: Height', 'thecraft'),
				'param_name' => 'bg_height',
				'value' => '13px',
				'dependency' => array( 'element' => 'style', 'value' => 'style-3' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'thecraft'),
				'param_name' => 'padding',
				'value' => '0px 5% 3px 5%',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'thecraft'),
				'dependency' => array( 'element' => 'style', 'value' => 'style-3' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Max Width', 'thecraft'),
				'param_name' => 'max_width',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'thecraft'),
				'param_name' => 'bottom_margin',
				'value' => '',
	        ),
            // Content
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Tag', 'thecraft' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
					'div' => 'div',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'thecraft'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'holder' => 'div',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content: Color', 'thecraft'),
				'param_name' => 'content_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'thecraft' ),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'thecraft' ),
				'param_name' => 'font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'thecraft' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'thecraft'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line-Height', 'thecraft'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Letter Spacing', 'thecraft'),
				'param_name' => 'letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
		)
	) );
} );

// Headings
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Headings', 'thecraft' ),
        'description' => esc_html__('Displaying awesome heading styles.', 'thecraft'),
		'base'        => 'headings',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Style', 'thecraft' ),
				'param_name' => 'heading_style',
				'value'      => array(
					'Simple' => 'style-1',
					'Background' => 'style-2',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background: Color', 'thecraft'),
				'param_name' => 'gb_color',
				'value' => '#b9e9e9',
				'dependency' => array( 'element' => 'heading_style', 'value' => 'style-2' ),
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Background: Height', 'thecraft'),
				'param_name' => 'bg_height',
				'value' => '13px',
				'dependency' => array( 'element' => 'heading_style', 'value' => 'style-2' ),
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Padding', 'thecraft'),
				'param_name' => 'padding',
				'value' => '0px 5% 3px 5%',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'thecraft'),
				'dependency' => array( 'element' => 'heading_style', 'value' => 'style-2' ),
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'thecraft' ),
				'param_name' => 'heading',
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'thecraft'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
            // SubHeading
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Sub-Heading (Optional)', 'thecraft' ),
				'param_name' => 'subheading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Sub-Heading Color', 'thecraft'),
				'param_name' => 'subheading_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading Max-Width', 'thecraft'),
				'param_name' => 'subheading_width',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator', 'thecraft' ),
				'param_name' => 'separator',
				'value'      => array(
					'No Separator' => '',
					'Line' => 'line',
					'Image' => 'image',
				),
				'std'		=> '',
				'group' => esc_html__( 'Separator', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator Position', 'thecraft' ),
				'param_name' => 'sep_position',
				'value'      => array(
					'Top' => 'top',
					'Between Heading & Sub-Heading' => 'between',
					'Bottom' => 'bottom',
					'Left' => 'left',
				),
				'std'		=> 'between',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => array( 'line', 'image' ) ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'thecraft'),
				'param_name' => 'line_width',
				'value' => '50',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'thecraft'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Right Margin', 'thecraft'),
				'param_name' => 'line_right_margin',
				'value' => '20',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'sep_position', 'value' => 'left' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'thecraft'),
				'param_name' => 'line_color',
				'value' => '',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'thecraft'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width (Optional)', 'thecraft'),
				'param_name' => 'image_width',
				'value' => '',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
	        ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'thecraft'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'thecraft' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'thecraft' ),
				'param_name' => 'heading_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'thecraft' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'thecraft'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size on Mobile', 'thecraft'),
				'param_name' => 'heading_font_size_mobile',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'thecraft'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Sub-Heading', 'thecraft'),
				'param_name' => 'subheading_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Family', 'thecraft' ),
				'param_name' => 'subheading_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Weight', 'thecraft' ),
				'param_name' => 'subheading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Font Size', 'thecraft'),
				'param_name' => 'subheading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Line Height', 'thecraft'),
				'param_name' => 'subheading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Style', 'thecraft' ),
				'param_name' => 'subheading_font_style',
				'value'      => array(
					'Normal' => 'normal',
					'Italic' => 'italic',
				),
				'std'		=> 'normal',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'thecraft'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'thecraft'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Top Margin', 'thecraft'),
				'param_name' => 'subheading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Bottom Margin', 'thecraft'),
				'param_name' => 'subheading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
		)
	) );
} );

// Animation Block
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_animationblock extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Animation Block', 'thecraft'),
		'description' => esc_html__('Apply animations anywhere.', 'thecraft'),
		'base' => 'animationblock',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'animationblock'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'thecraft' ),
				'param_name' => 'animation',
				'value'      =>  logistix_animation(),
				'std'		 => 'fadeInLeft'
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Animation Duration', 'thecraft'),
				'param_name' => 'duration',
				'value' => 1,
				'suffix' => 's'
		  	),
	        array(
				'type' => 'number',
				'heading' => esc_html__('Animation Delay', 'thecraft'),
				'param_name' => 'delay',
				'value' => 0.6,
				'suffix' => 's'
	        ),
	        array(
				'type' => 'number',
				'heading' => esc_html__('Viewport Position', 'thecraft'),
				'param_name' => 'position',
				'value' => 90,
				'suffix' => '%'
	        ),
         )
    ) );
} );

// Counter
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Counter', 'thecraft' ),
        'description' => esc_html__('Displaying a running counter.', 'thecraft'),
		'base'        => 'counter',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Order', 'thecraft' ),
				'param_name' => 'style',
				'value'      => array(
					'No Icon' => 'no-icon',
					'Icon Top' => 'icon-top',
					'Icon Left' => 'icon-left',
				),
				'std'		=> '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Order', 'thecraft' ),
				'param_name' => 'order',
				'value'      => array(
					'Number & Heading' => 'nh',
					'Heading & Number' => 'hn',
				),
				'std'		=> 'nh',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
				'dependency' => array( 'element' => 'style', 'value' => array('no-icon','icon-top')  ),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Wrap: Margin', 'thecraft' ),
				'param_name' => 'wrap_margin',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'thecraft'),
			),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'thecraft' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'thecraft' ),
				'value' => array(
					esc_html__( '', 'thecraft' ) => '',
					esc_html__( 'Logistix Icons', 'thecraft' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'thecraft' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'thecraft' ) => 'openiconic',
					esc_html__( 'Typicons', 'thecraft' ) => 'typicons',
					esc_html__( 'Entypo', 'thecraft' ) => 'entypo',
					esc_html__( 'Linecons', 'thecraft' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-top','icon-left')  ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'thecraft' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'thecraft'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-top','icon-left')  ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'thecraft'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-top','icon-left')  ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Line-height', 'thecraft'),
				'param_name' => 'icon_line_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-top','icon-left')  ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Right Margin', 'thecraft'),
				'param_name' => 'icon_right_margin',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'description'	=> esc_html__('Spacing between the icon and the heading.', 'thecraft'),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-left')  ),
	        ),
			// Number
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Number', 'thecraft' ),
				'param_name' => 'number',
				'group' => esc_html__( 'Number', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Number Color', 'thecraft'),
				'param_name' => 'number_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'thecraft' ),
            ),
			array(
				'type' => 'number',
				'heading' => esc_html__('Rolling Time', 'thecraft'),
				'param_name' => 'time',
				'value' => 5000,
				'suffix' => 'ms',
				'group' => esc_html__( 'Number', 'thecraft' ),
		  	),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Prefix (Optional)', 'thecraft' ),
				'param_name' => 'number_prefix',
				'group' => esc_html__( 'Number', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Prefix Color', 'thecraft'),
				'param_name' => 'prefix_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'thecraft' ),
            ),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Suffix (Optional)', 'thecraft' ),
				'param_name' => 'number_suffix',
				'group' => esc_html__( 'Number', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Suffix Color', 'thecraft'),
				'param_name' => 'suffix_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'thecraft' ),
            ),
		  	// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'thecraft' ),
				'param_name' => 'heading_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
					'div' => 'div',
				),
				'std'		=> 'div',
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading', 'thecraft' ),
				'param_name' => 'heading',
				'group' => esc_html__( 'Heading', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'thecraft'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'thecraft' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator', 'thecraft' ),
				'param_name' => 'separator',
				'value'      => array(
					'No Separator' => '',
					'Line' => 'line',
					'Image' => 'image',
				),
				'std'		=> '',
				'group' => esc_html__( 'Separator', 'thecraft' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'thecraft'),
				'param_name' => 'line_width',
				'value' => '50',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'thecraft'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'thecraft'),
				'param_name' => 'line_color',
				'value' => '',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'thecraft'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width (Optional)', 'thecraft'),
				'param_name' => 'image_width',
				'value' => '',
				'group' => esc_html__( 'Separator', 'thecraft' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
	        ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Number Settings', 'thecraft'),
				'param_name' => 'number_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Family', 'thecraft' ),
				'param_name' => 'number_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Weight', 'thecraft' ),
				'param_name' => 'number_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Font Size', 'thecraft'),
				'param_name' => 'number_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Line Height', 'thecraft'),
				'param_name' => 'number_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading Settings', 'thecraft'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'thecraft' ),
				'param_name' => 'heading_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'thecraft' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'thecraft'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'thecraft'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Prefix Settings', 'thecraft'),
				'param_name' => 'prefix_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Prefix: Font Family', 'thecraft' ),
				'param_name' => 'prefix_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Prefix: Font Weight', 'thecraft' ),
				'param_name' => 'prefix_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Prefix: Font Size', 'thecraft'),
				'param_name' => 'prefix_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Prefix: Line Height', 'thecraft'),
				'param_name' => 'prefix_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Suffix Settings', 'thecraft'),
				'param_name' => 'suffix_typograpy',
				'group' => esc_html__( 'Typography', 'thecraft' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Suffix: Font Family', 'thecraft' ),
				'param_name' => 'suffix_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Suffix: Font Weight', 'thecraft' ),
				'param_name' => 'suffix_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Suffix: Font Size', 'thecraft'),
				'param_name' => 'suffix_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Suffix: Line Height', 'thecraft'),
				'param_name' => 'suffix_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Top Margin', 'thecraft'),
				'param_name' => 'number_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Bottom Margin', 'thecraft'),
				'param_name' => 'number_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'thecraft'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'thecraft'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
		)
	) );
} );

// Icons
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icons', 'thecraft' ),
        'description' => esc_html__('Displaying Icon lists with custom icon.', 'thecraft'),
		'base'        => 'icons',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'left',
					'Center' => 'center',
					'Right' => 'right',
					'Center Grid' => 'center2',
				),
				'std'		=> 'left',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'thecraft' ),
				'param_name' => 'style',
				'value'      => array(
					'Simple or Ouline' => 'outline',
					'Background' => 'background',
				),
				'std'		=> 'background',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width', 'thecraft'),
				'param_name' => 'width',
				'value' => '60',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height', 'thecraft'),
				'param_name' => 'height',
				'value' => '60',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'thecraft'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'thecraft'),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'thecraft'),
				'param_name' => 'background_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'background' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'thecraft'),
				'param_name' => 'border_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'outline' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'thecraft'),
				'param_name' => 'border_width',
				'value' => '2px',
				'dependency' => array( 'element' => 'style', 'value' => 'outline' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'thecraft' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
				'dependency' => array( 'element' => 'style', 'value' => 'outline' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'thecraft'),
				'param_name' => 'margin',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'thecraft'),
	        ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Enable Pulse Effect Infinity?', 'thecraft' ),
				'param_name' => 'icon_effect',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'no',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'thecraft' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'thecraft' ),
				'value' => array(
					esc_html__( '', 'thecraft' ) => '',
					esc_html__( 'Logistix Icons', 'thecraft' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'thecraft' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'thecraft' ) => 'openiconic',
					esc_html__( 'Typicons', 'thecraft' ) => 'typicons',
					esc_html__( 'Entypo', 'thecraft' ) => 'entypo',
					esc_html__( 'Linecons', 'thecraft' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'thecraft' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon: Color', 'thecraft'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Font Size', 'thecraft'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
	        ),
	        // Hyperlink
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hyperlink Style', 'thecraft' ),
				'param_name' => 'hyperlink',
				'value'      => array(
					'Simple Link' => 'simple',
					'Video Link' => 'video',
				),
				'std'		=> 'simple',
				'group' => esc_html__( 'Hyperlink', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Youtube/Vimeo (URL)', 'thecraft'),
				'param_name' => 'video_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'thecraft' ),
				'dependency' => array( 'element' => 'hyperlink', 'value' => 'video' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'thecraft'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'thecraft' ),
				'dependency' => array( 'element' => 'hyperlink', 'value' => 'simple' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'thecraft' ),
				'param_name' => 'new_tab',
				'group' => esc_html__( 'Hyperlink', 'thecraft' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'dependency' => array( 'element' => 'hyperlink', 'value' => 'simple' ),
			),
		)
	) );
} );

// Image Advanced
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Image Advanced', 'thecraft' ),
        'description' => esc_html__('Display image with video popup.', 'thecraft'),
		'base'        => 'advimage',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'params'      => array(
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'thecraft'),
				'param_name' => 'image',
				'value' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Caption Text', 'thecraft'),
				'param_name' => 'caption_text',
				'value' => 'Caption Text',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Caption Color', 'thecraft'),
				'param_name' => 'caption_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Caption Background', 'thecraft'),
				'param_name' => 'caption_background',
				'value' => '#f5f5f5',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Caption Padding', 'thecraft'),
				'param_name' => 'caption_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 13px 40px 13px 40px', 'thecraft'),
	        ),
			// Video Icon
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Video Icon?', 'thecraft' ),
				'param_name' => 'show_icon',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
				'group' => esc_html__( 'Video Icon', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hyperlink Style', 'thecraft' ),
				'param_name' => 'hyperlink',
				'value'      => array(
					'Simple Link' => 'simple',
					'Video Link' => 'video',
				),
				'std'		=> 'simple',
				'group' => esc_html__( 'Video Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Youtube/Vimeo (URL)', 'thecraft'),
				'param_name' => 'video_url',
				'value' => '',
				'group' => esc_html__( 'Video Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'hyperlink', 'value' => 'video' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'thecraft'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Video Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'hyperlink', 'value' => 'simple' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'thecraft' ),
				'param_name' => 'new_tab',
				'group' => esc_html__( 'Video Icon', 'thecraft' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'dependency' => array( 'element' => 'hyperlink', 'value' => 'simple' ),
			),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'thecraft' ),
				'param_name' => 'font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'thecraft' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'thecraft'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line-Height', 'thecraft'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Letter Spacing', 'thecraft'),
				'param_name' => 'letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
		)
	) );
} );

// Lines
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Lines', 'thecraft'),
        'description' => esc_html__('Displaying Lines with custom width and height.', 'thecraft'),
        'base' => 'lines',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'left',
					'Center' => 'center',
					'Right' => 'right',
				),
				'std'		=> 'left',
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Line 1:', 'thecraft'),
				'param_name' => 'line1_heading',
				'class' => '',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line 1: Width', 'thecraft'),
				'param_name' => 'line1_width',
				'value' => '70',
				'dependency' => array( 'element' => 'line_1_full', 'value' => 'no' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line 1: Height', 'thecraft'),
				'param_name' => 'line1_height',
				'value' => '2',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 1: Color', 'thecraft'),
				'param_name' => 'line1_color',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line 1: Full-width', 'thecraft' ),
				'param_name' => 'line_1_full',
				'value'      => array(
					'No' => 'no',
					'Yes' => 'yes',
				),
				'std'		=> 'no',
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Line 2:', 'thecraft'),
				'param_name' => 'line2_heading',
				'class' => '',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line 2: Width', 'thecraft'),
				'param_name' => 'line2_width',
				'value' => '170',
				'dependency' => array( 'element' => 'line_2_full', 'value' => 'no' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line 2: Height', 'thecraft'),
				'param_name' => 'line2_height',
				'value' => '2',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 2: Color', 'thecraft'),
				'param_name' => 'line2_color',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line 2: Full-width', 'thecraft' ),
				'param_name' => 'line_2_full',
				'value'      => array(
					'No' => 'no',
					'Yes' => 'yes',
				),
				'std'		=> 'no',
			),
	        // Spacing
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Top Margin', 'thecraft'),
				'param_name' => 'top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
				'description' => esc_html__( 'Ex: 20px', 'thecraft' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'thecraft'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
				'description' => esc_html__( 'Ex: 20px', 'thecraft' ),
            ),
        )
    ) );
} );

// Divider
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Divider', 'thecraft'),
        'description' => esc_html__('Displaying lines separator.', 'thecraft'),
        'base' => 'divider',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'left',
					'Center' => 'center',
					'Right' => 'right',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'icon_display', 'value' => 'no-icon' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line Style', 'thecraft' ),
				'param_name' => 'style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
					'Double Dotted' => 'double-dotted',
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Width (Optional)', 'thecraft'),
				'param_name' => 'width',
				'value' => '',
				'description' => esc_html__( 'You can use % or px value (Ex: 150px). Leave it empty to set full-width.', 'thecraft' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Height', 'thecraft'),
				'param_name' => 'height',
				'value' => '',
				'description'	=> esc_html__('Ex: 2px', 'thecraft'),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line: Color', 'thecraft'),
				'param_name' => 'color',
				'value' => '',
            ),
			// Icon
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'thecraft' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'No Icon' => 'no-icon',
					'Icon Font' => 'icon-font',
					'Icon Image' => 'icon-image',
				),
				'std'		=> 'no-icon',
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'thecraft' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'thecraft' ),
				'value' => array(
					esc_html__( '', 'thecraft' ) => '',
					esc_html__( 'Logistix Icons', 'thecraft' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'thecraft' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'thecraft' ) => 'openiconic',
					esc_html__( 'Typicons', 'thecraft' ) => 'typicons',
					esc_html__( 'Entypo', 'thecraft' ) => 'entypo',
					esc_html__( 'Linecons', 'thecraft' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'thecraft' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon: Color', 'thecraft'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Font Size', 'thecraft'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Icon Image', 'thecraft'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Image: Width', 'thecraft'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 50px', 'thecraft'),
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Padding', 'thecraft'),
				'param_name' => 'icon_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 0px 12px 0px 12px', 'thecraft'),
				'dependency' => array( 'element' => 'icon_display', 'value' => array( 'icon-font', 'icon-image' ) ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Top Margin', 'thecraft'),
				'param_name' => 'top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Bottom Margin', 'thecraft'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'thecraft' ),
	        ),
        )
    ) );
} );

// Alignment Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_alignbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Alignment Box', 'thecraft' ),
        'description' => esc_html__('Align elements.', 'thecraft'),
		'base'        => 'alignbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'alignbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
		)
	) );
} );

// Buttons
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Buttons', 'thecraft'),
        'description' => esc_html__('Advanced Buttons.', 'thecraft'),
        'base' => 'buttons',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
        'params' => array(
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Text', 'thecraft'),
				'param_name' => 'text',
				'value' => 'Button Text',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'thecraft' ),
				'param_name' => 'style',
				'value'      => array(
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
					'Design your own' => 'custom',
				),
				'std'		=> 'accent',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Size', 'thecraft' ),
				'param_name' => 'size',
				'value'      => array(
					'Small' => 'small',
					'Medium' => 'medium',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'dependency' => array(
					'element' => 'style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Padding: Left & Right', 'thecraft' ),
				'param_name' => 'width_style',
				'value'      => array(
					'Default' => '',
					'10px' => 'p10px',
					'15px' => 'p15px',
					'20px' => 'p20px',
					'25px' => 'p25px',
					'30px' => 'p30px',
					'35px' => 'p35px',
					'40px' => 'p40px',
					'45px' => 'p45px',
					'50px' => 'p50px',
					'55px' => 'p55px',
					'60px' => 'p60px',
					'65px' => 'p65px',
					'70px' => 'p70px',
					'75px' => 'p75px',
					'80px' => 'p80px',
					'85px' => 'p85px',
					'90px' => 'p90px',
					'95px' => 'p95px',
					'100px' => 'p100px',
				),
				'std'		=> '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'thecraft'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 13px 40px 13px 40px', 'thecraft'),
				'dependency' => array( 'element' => 'style', 'value' => 'custom' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'thecraft'),
				'param_name' => 'background_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'custom' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'thecraft'),
				'param_name' => 'border_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'custom' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'thecraft'),
				'param_name' => 'text_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'custom' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'thecraft'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'thecraft'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'thecraft'),
				'param_name' => 'border_width',
				'value' => '',
				'description'	=> esc_html__('ex: 2px', 'thecraft'),
				'dependency' => array(
					'element' => 'style',
					'value' => array (
						'custom',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'thecraft' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
				'dependency' => array(
					'element' => 'style',
					'value' => array (
						'custom',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'thecraft'),
				'param_name' => 'margin',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'thecraft'),
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Full-width Button?', 'thecraft' ),
				'param_name' => 'full_width',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'thecraft' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'thecraft' ),
				'value' => array(
					esc_html__( '', 'thecraft' ) => '',
					esc_html__( 'Logistix Icons', 'thecraft' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'thecraft' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'thecraft' ) => 'openiconic',
					esc_html__( 'Typicons', 'thecraft' ) => 'typicons',
					esc_html__( 'Entypo', 'thecraft' ) => 'entypo',
					esc_html__( 'Linecons', 'thecraft' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'thecraft' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'thecraft' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'thecraft'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array( 'element' => 'style', 'value' => 'custom' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'thecraft'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Position', 'thecraft' ),
				'param_name' => 'icon_position',
				'value'      => array(
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
				),
				'std'		=> 'icon-right',
				'group' => esc_html__( 'Icon', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Right Padding', 'thecraft'),
				'param_name' => 'icon_right_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'description'	=> esc_html__('Spacing between the icon and the text. Ex: 40px.', 'thecraft'),
				'dependency' => array( 'element' => 'icon_position', 'value' => 'icon-left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Left Padding', 'thecraft'),
				'param_name' => 'icon_left_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'description'	=> esc_html__('Spacing between the icon and the text. Ex: 40px.', 'thecraft'),
				'dependency' => array( 'element' => 'icon_position', 'value' => 'icon-right' ),
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable separate line?', 'thecraft' ),
				'param_name' => 'separate',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
				'group' => esc_html__( 'Icon', 'thecraft' ),
				'dependency' => array(
					'element' => 'style',
					'value' => array (
						'accent',
						'dark',
					)
				),
			),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'thecraft'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'thecraft' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'thecraft' ),
				'param_name' => 'new_tab',
				'group' => esc_html__( 'Hyperlink', 'thecraft' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
			),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'thecraft' ),
				'param_name' => 'font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'thecraft' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'thecraft'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line-Height', 'thecraft'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
        )
    ) );
} );

// Hero Section
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_hero extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Hero Section', 'thecraft'),
        'description' => esc_html__('Hero Section.', 'thecraft'),
        'base' => 'hero',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'hero'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hero Height', 'thecraft' ),
				'param_name' => 'hero_height',
				'value'      => array(
					'Full Height' => 'full-height',
					'Custom Height' => 'custom-height',
				),
				'std'		=> 'full-height',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Hero Custom Height', 'thecraft'),
				'param_name' => 'hero_custom_height',
				'value' => '',
				'description'	=> esc_html__('Ex: 600px.', 'thecraft'),
				'dependency' => array( 'element' => 'hero_height', 'value' => 'custom-height' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Showcase', 'thecraft' ),
				'param_name' => 'showcase',
				'value'      => array(
					'Background Slideshow' => 'slideshow',
					'Background Video' => 'video',
				),
				'std'		=> 'slideshow',
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Background Images', 'thecraft'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for background slideshow.', 'thecraft'),
				'dependency' => array( 'element' => 'showcase', 'value' => 'slideshow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Effects', 'thecraft' ),
				'param_name' => 'effect',
				'value'      => array(
					'fade' => 'fade',
					'fade2' => 'fade2',
					'slideLeft' => 'slideLeft',
					'slideLeft2' => 'slideLeft2',
					'slideRight' => 'slideRight',
					'slideRight2' => 'slideRight2',
					'slideUp' => 'slideUp',
					'slideDown' => 'slideDown',
					'slideDown2' => 'slideDown2',
					'zoomIn' => 'zoomIn',
					'zoomIn2' => 'zoomIn2',
					'zoomOut' => 'zoomOut',
					'zoomOut2' => 'zoomOut2',
					'swirlLeft' => 'swirlLeft',
					'swirlLeft2' => 'swirlLeft2',
					'swirlRight' => 'swirlRight',
					'swirlRight2' => 'swirlRight2',
					'burn' => 'burn',
					'burn2' => 'burn2',
					'blur' => 'blur',
					'blur2' => 'blur2',
					'flash' => 'flash',
					'flash2' => 'flash2'
				),
				'std'		=> 'fade',
				'dependency' => array( 'element' => 'showcase', 'value' => 'slideshow' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Youtube link (URL)', 'thecraft'),
				'param_name' => 'video_link',
				'value' => '',
				'description' => esc_html__('Youtube link or ID. Ex: https://www.youtube.com/watch?v=vQqZIFCab9o', 'thecraft'),
				'dependency' => array( 'element' => 'showcase', 'value' => 'video' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Pattern Overlay', 'thecraft' ),
				'param_name' => 'pattern_overlay',
				'value'      => array(
					'No Parttern' => '',
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
					'Style 5' => 'style-5',
					'Style 6' => 'style-6',
					'Style 7' => 'style-7',
					'Style 8' => 'style-8',
					'Style 9' => 'style-9',
				),
				'std'		=> 'style-1',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color Overlay', 'thecraft'),
				'param_name' => 'color_overlay',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Top Margin', 'thecraft'),
				'param_name' => 'content_top',
				'value' => '',
				'description'	=> esc_html__('Ex: 50px. In case you want to set a spacing above the content area.', 'thecraft'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Content area into Grid?', 'thecraft' ),
				'param_name' => 'grid',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			// Arrow
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show arrow?', 'thecraft' ),
				'param_name' => 'scroll',
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
				'group' => esc_html__( 'Arrow', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Style', 'thecraft' ),
				'param_name' => 'arrow_style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Arrow', 'thecraft' ),
				'dependency' => array( 'element' => 'scroll', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Scroll to Row (ID)', 'thecraft'),
				'param_name' => 'scroll_id',
				'value' => '',
				'description' => esc_html__('Enter the anchor ID you assigned to the row.', 'thecraft'),
				'group' => esc_html__( 'Arrow', 'thecraft' ),
				'dependency' => array( 'element' => 'scroll', 'value' => 'yes' ),
            ),
        )
    ) );
} );

// Fancy Text
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Fancy Text', 'thecraft'),
        'description' => esc_html__('Awesome Animation Text.', 'thecraft'),
        'base' => 'fancytext',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'thecraft' ),
				'param_name' => 'animation',
				'value'      => array(
					'Scrolling' => 'scroll',
					'Typing' => 'typed',
				),
				'std'		=> 'scroll',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 1 (Optional)', 'thecraft' ),
				'param_name' => 'text1',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 2 (Optional)', 'thecraft' ),
				'param_name' => 'text2',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 3 (Optional)', 'thecraft' ),
				'param_name' => 'text3',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 4 (Optional)', 'thecraft' ),
				'param_name' => 'text4',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 5 (Optional)', 'thecraft' ),
				'param_name' => 'text5',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Prefix Text (Optional)', 'thecraft' ),
				'param_name' => 'prefix_text',
				'group' => esc_html__( 'Prefix & Suffix', 'thecraft' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Suffix Text (Optional)', 'thecraft' ),
				'param_name' => 'suffix_text',
				'group' => esc_html__( 'Prefix & Suffix', 'thecraft' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'thecraft'),
				'param_name' => 'text_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Prefix Text Color', 'thecraft'),
				'param_name' => 'prefix_color',
				'value' => '',
				'group' => esc_html__( 'Prefix & Suffix', 'thecraft' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Suffix Text Color', 'thecraft'),
				'param_name' => 'suffix_color',
				'value' => '',
				'group' => esc_html__( 'Prefix & Suffix', 'thecraft' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Tag', 'thecraft' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'thecraft' ),
				'param_name' => 'font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'thecraft' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__( 'Font Size: Max', 'thecraft' ),
				'param_name' => 'font_max',
				'value' => 70,
				'suffix' => 'px',
				'group' => esc_html__( 'Typography', 'thecraft' ),
				'description'	=> esc_html__('Important! This size only appear exactly on the full-width grid, 65px max-size on the 1170 grid and 32px max-size on the 570px grid.', 'thecraft'),
		  	),
		  	array(
				'type' => 'number',
				'heading' => esc_html__( 'Font Size: Min', 'thecraft' ),
				'param_name' => 'font_min',
				'value' => 22,
				'suffix' => 'px',
				'group' => esc_html__( 'Typography', 'thecraft' ),
		  	),
        )
    ) );
} );

// Partner Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Partner Carousel', 'thecraft'),
	    'description' => esc_html__('Displaying partner posts in carousel.', 'thecraft'),
	    'base' => 'partners',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'thecraft'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'thecraft' ),
				'param_name' => 'style',
				'value'      => array(
					'Simple' => 'style-1',
					'Outline' => 'style-2',
					'White Background' => 'style-3',
					'Grey Background' => 'style-4',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'thecraft'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 40px 50px 40px 50px', 'thecraft'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background', 'thecraft'),
				'param_name' => 'background',
				'value' => '#f5f5f5',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'thecraft'),
				'param_name' => 'gap',
				'value' => '10',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'thecraft' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'thecraft' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'thecraft'),
			),
			// Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'thecraft'),
				'param_name' => 'items',
				'value' => '5',
				'group' => esc_html__( 'Query', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug', 'thecraft'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'thecraft' ),
				'description'	=> esc_html__('Only show posts from specific category-slug (optional).', 'thecraft'),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'thecraft'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'thecraft' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'thecraft' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'thecraft' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'thecraft'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'thecraft' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Style', 'thecraft' ),
				'param_name' => 'arrow_style',
				'value'      => array(
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'dark',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'thecraft' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'thecraft' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'thecraft' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'thecraft' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'thecraft' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
	    )
	) );
} );

// Subscribe
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Subscribe Form', 'thecraft'),
        'description' => esc_html__('Displaying mailchimp newsletter form.', 'thecraft'),
        'base' => 'subscribe',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
        'params' => array(
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap: Padding', 'thecraft'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 40px 50px 40px 50px', 'thecraft'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Wrap: Background', 'thecraft' ),
				'param_name' => 'background',
				'value'      => array(
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Transparent' => 'transparent',
				),
				'std'		=> 'accent',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'thecraft' ),
				'param_name' => 'heading',
				'value' => 'Newsletter Subscribe'
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Sub-Heading Text', 'thecraft' ),
				'param_name' => 'sheading',
				'value' => 'Looking down into the dark gulf below down.'
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Color', 'thecraft' ),
				'param_name' => 'text_color',
				'value'      => array(
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'dark',
			),
        )
    ) );
} );

// Tabs
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_dtabs extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Tabs', 'thecraft' ),
        'description' => esc_html__('Displaying Tabbed Content.', 'thecraft'),
		'base'        => 'dtabs',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'dtab' ),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'thecraft'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'thecraft' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title: Width', 'thecraft' ),
				'param_name' => 'title_width',
				'value'      => array(
					'150px' => 'w150',
					'160px' => 'w160',
					'170px' => 'w170',
					'180px' => 'w180',
					'190px' => 'w190',
					'200px' => 'w200',
					'220px' => 'w220',
					'240px' => 'w240',
					'260px' => 'w260',
					'280px' => 'w280',
					'300px' => 'w300',
				),
				'std'		=> 'w190',
				'dependency' => array( 'element' => 'style', 'value' => array('style-3','style-4')),
	        ),
		)
	) );
} );

// Tab
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Tab', 'thecraft' ),
    'description' => esc_html__('Displaying Tab.', 'thecraft'),
		'base'        => 'dtab',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'js_composer'),
		'as_child'    => array( 'only' => 'dtabs' ),
		'params'      => array(
			// Title
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'thecraft'),
				'param_name' => 'title',
				'value' => 'Tab',
				'group' => esc_html__( 'Title', 'thecraft' ),
            ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'thecraft'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'thecraft'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 20px 0px 0px 0px', 'thecraft'),
				'group' => esc_html__( 'Content', 'thecraft' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title Font Family', 'thecraft' ),
				'param_name' => 'title_font_family',
				'value'      =>  logistix_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title Font Weight', 'thecraft' ),
				'param_name' => 'title_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Font Size', 'thecraft'),
				'param_name' => 'title_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Line-Height', 'thecraft'),
				'param_name' => 'title_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
		)
	) );
} );

// Products Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Products Carousel', 'thecraft'),
        'description' => esc_html__('Displaying products in carousel.', 'thecraft'),
        'base' => 'dproducts',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
        'params' => array(
	        // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number', 'thecraft'),
				'param_name' => 'number',
				'value' => '4',
				'group' => esc_html__( 'Query', 'thecraft' ),
				'description'	=> esc_html__('The number of campaigns to show.', 'thecraft'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Space Between', 'thecraft'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'thecraft' ),
				'description'	=> esc_html__('Important! Include the blur distance of the shadow.', 'thecraft'),
	        ),
	        // Controls
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'thecraft' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'thecraft'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'thecraft' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'thecraft' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'thecraft' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'thecraft'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'thecraft' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'thecraft' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array( esc_html__( 'Yes, please.', 'thecraft' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Style', 'thecraft' ),
				'param_name' => 'arrow_style',
				'value'      => array(
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'dark',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'thecraft' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'thecraft' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'thecraft' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'thecraft' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'thecraft' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'thecraft' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'thecraft' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Countdown
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('CountDown', 'thecraft'),
        'description' => esc_html__('Displaying Countdown Timer.', 'thecraft'),
        'base' => 'countdown',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'thecraft'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'thecraft' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Time', 'thecraft' ),
				'param_name' => 'time',
				'value' => 'December 30, 2018 8:30:00'
			),
        )
    ) );
} );