<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

extract( shortcode_atts( array(
	'showcase' => 'style-1',
	'image_crop' => 'rectangle',
	'items'			=> '8',
	'gap'			=> '0',
	'cat_slug'	=> '',
	'auto_scroll' => 'false',
	'grid_full' => '',
	'column'		=> '3c',
	'column2'		=> '2c',
	'column3'		=> '1c',
	'show_bullets' => '',
	'show_arrows' => '',
    'arrow_style' => 'dark',
	'bullet_show' => 'bullet-square',
	'bullet_between' => '50',
    'arrow_offset' => 'center',
    'arrow_offset_v' => '0',
), $atts ) );

$items = intval( $items );
$gap = intval( $gap );
$column = intval( $column );
$column2 = intval( $column2 );
$column3 = intval( $column3 );

if ( empty( $items ) )
	return;

$loop = '';
$cls = 'arrow-'. $arrow_style .' arrow-center '. $bullet_show .' ';
$cls .= 'offset'. $arrow_offset .' offset-v'. $arrow_offset_v;
if ( $show_bullets ) $cls .= ' has-bullets'; 
if ( $show_arrows ) $cls .= ' has-arrows';
if ( $grid_full ) $cls .= ' grid-full';
if ( $grid_full == 'yes' ) { $loop = 'true'; }
else { $loop = 'false'; }

$item_cls = $showcase;

if ( $bullet_between == '45' ) $cls .= ' bullet45';
if ( $bullet_between == '40' ) $cls .= ' bullet40';
if ( $bullet_between == '35' ) $cls .= ' bullet35';
if ( $bullet_between == '30' ) $cls .= ' bullet30';
if ( $bullet_between == '25' ) $cls .= ' bullet25';
if ( $bullet_between == '20' ) $cls .= ' bullet20';
if ( $bullet_between == '15' ) $cls .= ' bullet15';
if ( $bullet_between == '10' ) $cls .= ' bullet10';

$query_args = array(
    'post_type' => 'project',
    'posts_per_page' => $items
);

if ( ! empty( $cat_slug ) ) {
	$query_args['tax_query'] = array(
		array(
			'taxonomy' => 'project_category',
			'field'    => 'slug',
			'terms'    => $cat_slug
		),
	);
}

$query = new WP_Query( $query_args );
if ( ! $query->have_posts() ) { echo "Project item not found!"; return; }
ob_start(); ?>

<div class="logistix-project <?php echo esc_attr( $cls ); ?>" data-loop="<?php echo esc_attr( $loop ); ?>" data-auto="<?php echo esc_attr( $auto_scroll ); ?>" data-column="<?php echo esc_attr( $column ); ?>" data-column2="<?php echo esc_attr( $column2 ); ?>" data-column3="<?php echo esc_attr( $column3 ); ?>" data-gap="<?php echo esc_html( $gap ); ?>">

<?php if ( $query->have_posts() ) : ?>
	<?php
		wp_enqueue_script( 'logistix-owlcarousel' );
		if ( $grid_full == 'yes' ) { echo '<div class="grid-full-wrap"><div class="logistix-container">'; }
	?>

	<div class="owl-carousel owl-theme">
	    <?php while ( $query->have_posts() ) : $query->the_post(); global $post; ?>
			<div class="project-box <?php echo esc_attr( $item_cls ); ?>">
				<div class="inner">
					<?php
						if ( has_post_thumbnail() ) {
					    	$img_size = 'logistix-rectangle';
							if ( $image_crop == 'full' ) $img_size = 'full';
							if ( $image_crop == 'square' ) $img_size = 'logistix-square';
							if ( $image_crop == 'square2' ) $img_size = 'logistix-square2';
							if ( $image_crop == 'rectangle2' ) $img_size = 'logistix-rectangle2';
							if ( $image_crop == 'rectangle3' ) $img_size = 'logistix-rectangle3';
							if ( $image_crop == 'rectangle4' ) $img_size = 'logistix-rectangle4';
							if ( $image_crop == 'auto2' ) $img_size = 'logistix-small-auto';
                    	}

                    	$icon_html = sprintf('<div class="icon">
                    		<a class="link" href="%1$s" title="%2$s"><i class="nz-plus2"></i></a>
                    		<a class="zoom-popup" href="%3$s" data-title="%2$s"><i class="nz-magnifier3"></i></a>
                    		</div>',
                    		esc_url( get_the_permalink() ),
                    		esc_attr( get_the_title() ),
                    		logistix_get_image( array( 'size' => 'full', 'format' => 'src' ) )
                    	);

                    	$heading_html = sprintf('<a href="%1$s" title="%2$s"><h2 data-title="%3$s">%3$s</h2></a>', esc_url( get_the_permalink() ), esc_attr( get_the_title() ), get_the_title() );

                    	if ( $showcase == 'style-1' ) {
                    		echo '<div class="project-wrap"><div class="project-image">'. get_the_post_thumbnail( get_the_ID(), $img_size ) . $icon_html .'</div><div class="project-text">' . $heading_html .'</div></div>';
                    	} else {
                    		echo '<div class="project-wrap"><div class="project-image">'. get_the_post_thumbnail( get_the_ID(), $img_size ) .'</div><div class="project-text">'. $icon_html .'</div></div>'. $heading_html;
                    	}
                  		
					?>
                </div>
			</div><!-- /.project-box -->
		<?php endwhile; ?>
	</div><!-- /.owl-carousel -->

<?php if ( $grid_full == 'yes' ) { echo '</div></div>'; }
endif; ?>
<?php wp_reset_postdata(); ?>

</div><!-- /.logistix-project -->
<?php
$return = ob_get_clean();
echo $return;