<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

extract( shortcode_atts( array(
	'image'    => '',
	'caption_text' => 'Caption Text',
	'caption_color' => '',
	'caption_background' => '#f5f5f5',
	'caption_padding' => '',
	'alignment' => 'text-center',
	'hyperlink' => 'simple',
	'video_url' => '',
	'link_url' => '',
	'new_tab' => 'yes',
	'font_family' => 'Default',
	'font_weight' => 'Default',
	'font_size' => '',
	'line_height' => '',
	'letter_spacing' => '',
), $atts ) );

$font_size = intval( $font_size );
$line_height = intval( $line_height );
$letter_spacing = intval( $letter_spacing );

$css = $icon_html = $image_html = $caption_html = $caption_css = $thumb_css = '';
$cls = $alignment;

if ( $caption_color ) $caption_css .= 'color:'. $caption_color .';';
if ( $caption_background ) $caption_css .= 'background-color:'. $caption_background .';';
if ( $caption_padding ) $caption_css .= 'padding:'. $caption_padding .';';

if ( $font_weight != 'Default' ) $css .= 'font-weight:'. $font_weight .';';
if ( $font_size ) $css .= 'font-size:'. $font_size .'px;';
if ( $line_height ) $css .= 'line-height:'. $line_height .'px;';
if ( $letter_spacing ) $css .= 'letter-spacing:'. $letter_spacing .'px;';
if ( $font_family != 'Default' ) {
	logistix_enqueue_google_font( $font_family );
	$css .= 'font-family:'. $font_family .';';
}

if ( $hyperlink == 'simple' ) {
	if ( $link_url ) {
		$new_tab = $new_tab == 'yes' ? '_blank' : '_self';
		$icon_html = sprintf( '<a class="icon-wrap" target="%3$s" href="%2$s">%1$s</a>', $icon_html, $link_url, $new_tab );
	}
} else {
	if ( $video_url ) {
		wp_enqueue_script( 'logistix-magnificpopup' );
		$icon_html = sprintf( '<a class="icon-wrap popup-video" href="%2$s">%1$s</a>', $icon_html, $video_url );
	}
}

if ( $image ) {
    $image_html .= sprintf(
        '<div class="thumb" style="%3$s">%1$s %2$s</div>',
         wp_get_attachment_image( $image, 'full' ), $icon_html, $thumb_css
    );
}

if ( $caption_text ) {
    $caption_html .= sprintf(
        '<div class="img-caption" style="%2$s">%1$s</div>',
         $caption_text, $caption_css
    );
}

printf( '<div class="logistix-img-advanced clearfix %1$s" style="%2$s">%3$s %4$s</div>', $cls, $css, $image_html, $caption_html );


