<?php 
/*
Plugin Name: WPRT Addons for Logistix
Plugin URI: https://ninzio.com/
Description: Extend WPBakery with Advanced Shortcodes.
Version: 1.0
Author: Ninzio Themes
Author URI: https://ninzio.com/
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Enqueue scripts
add_action( 'wp_enqueue_scripts', 'loadCssAndJs', 999999 );
function loadCssAndJs() {
	wp_enqueue_style( 'logistix-flexslider', plugins_url('assets/flexslider.css', __FILE__), array(), '2.3.6' );
	wp_register_script( 'logistix-flexslider', plugins_url('assets/flexslider.min.js', __FILE__), array('jquery'), '2.3.6', true );
	wp_enqueue_style( 'logistix-owlcarousel', plugins_url('assets/owl.carousel.css', __FILE__), array(), '2.2.1' );
	wp_register_script( 'logistix-owlcarousel', plugins_url('assets/owl.carousel.min.js', __FILE__), array('jquery'), '2.2.1', true );
	wp_enqueue_style( 'logistix-cubeportfolio', plugins_url('assets/cubeportfolio.min.css', __FILE__), array(), '3.4.0' );
	wp_register_script( 'logistix-cubeportfolio', plugins_url('assets/cubeportfolio.min.js', __FILE__), array('jquery'), '3.4.0', true );
	wp_register_script( 'logistix-countto', plugins_url('assets/countto.js', __FILE__), array('jquery'), '1.0.0', true );
	wp_enqueue_script( 'logistix-equalize', plugins_url('assets/equalize.min.js', __FILE__), array('jquery'), '1.0.0', true );
	wp_enqueue_script( 'logistix-imagesloaded', plugins_url('assets/imagesloaded.js', __FILE__), array('jquery'), '4.1.3', true );
	wp_enqueue_style( 'logistix-magnificpopup', plugins_url('assets/magnific.popup.css', __FILE__), array(), '1.0.0' );
	wp_register_script( 'logistix-magnificpopup', plugins_url('assets/magnific.popup.min.js', __FILE__), array('jquery'), '1.0.0', true );
	wp_enqueue_style( 'logistix-vegas', plugins_url('assets/vegas.css', __FILE__), array(), '2.3.1' );
	wp_register_script( 'logistix-vegas', plugins_url('assets/vegas.js', __FILE__), array('jquery'), '2.3.1', true );
	wp_enqueue_style( 'logistix-ytplayer', plugins_url('assets/ytplayer.css', __FILE__), array(), '3.0.2' );
	wp_register_script( 'logistix-ytplayer', plugins_url('assets/ytplayer.js', __FILE__), array('jquery'), '3.0.2', true );
	wp_register_script( 'logistix-fittext', plugins_url('assets/fittext.js', __FILE__), array('jquery'), '1.1.0', true );
	wp_register_script( 'logistix-flowtype', plugins_url('assets/flowtype.js', __FILE__), array('jquery'), '1.3.0', true );
	wp_register_script( 'logistix-typed', plugins_url('assets/typed.js', __FILE__), array('jquery'), '1.1.0', true );
	wp_register_script( 'logistix-countdown', plugins_url('assets/countdown.js', __FILE__), array('jquery'), '1.0.0', true );
	wp_enqueue_script( 'logistix-appear', plugins_url('assets/appear.js', __FILE__), array('jquery'), '0.3.6', true );
	
	wp_enqueue_style( 'logistix-shortcode', plugins_url('assets/shortcodes.css', __FILE__), array(), '1.0' );
	wp_enqueue_script( 'logistix-shortcode', plugins_url('assets/shortcodes.js', __FILE__), array('jquery'), '1.0', true );
}

// Add image sizes
add_action( 'after_setup_theme', 'add_image_sizes' );
function add_image_sizes() {
	add_image_size( 'logistix-square', 600, 600, true );
	add_image_size( 'logistix-square2', 400, 400, true );
	add_image_size( 'logistix-rectangle', 590, 550, true );
	add_image_size( 'logistix-rectangle2', 590, 520, true );
	add_image_size( 'logistix-rectangle3', 590, 440, true );
	add_image_size( 'logistix-rectangle4', 590, 405, true );
	add_image_size( 'logistix-medium-auto', 870, 9999 );
	add_image_size( 'logistix-small-auto', 600, 9999 );
	add_image_size( 'logistix-xsmall-auto', 480, 9999 );
}

// Map shortcodes to Visual Composer
require_once __DIR__ . '/vc-map.php';

// Include shortcodes files for Visual Composer
foreach ( glob( plugin_dir_path( __FILE__ ) . '/shortcodes/*.php' ) as $file ) {
	$filename = basename( $file );
	$tagname  = str_replace( '-', '_', pathinfo( $file, PATHINFO_FILENAME ) );

	add_shortcode( $tagname, function( $atts, $content = '' ) use( $file, $filename ) {
		ob_start();
		include $file;
		return ob_get_clean();
	} );
}

// Add user contact methods
if ( ! function_exists( 'weberium_socials_user_contact_methods' ) ) {
    function weberium_socials_user_contact_methods( $user_contact ) {

        $user_contact['rt_facebook']   = esc_html( 'Facebook URL' );
        $user_contact['rt_twitter'] = esc_html( 'Twitter URL' );
        $user_contact['rt_google_plus'] = esc_html( 'Google+ URL' );
        $user_contact['rt_linkedin'] = esc_html( 'LinkedIn URL' );
        $user_contact['rt_pinterest'] = esc_html( 'Pinterest URL' );
        $user_contact['rt_instagram'] = esc_html( 'Instagram URL' );

        // Unset fields you don’t need
        unset($user_contact['aim']);
        unset($user_contact['jabber']);

        return $user_contact;
    }

  add_filter( 'user_contactmethods', 'weberium_socials_user_contact_methods' );
}

// Custom Post Type
require_once __DIR__ . '/cpt/init.php';

// Widgets
require_once __DIR__ . '/widgets/init.php';

?>