<?php
get_header();

$related_title = logistix_get_mod( 'project_related_title' );
$related_title   = $related_title ? $related_title : esc_html__( 'YOU MAY ALSO LIKE', 'thecraft' );
$related_query = logistix_get_mod( 'project_related_query', '9' );
$related_column = logistix_get_mod( 'project_related_column', '3' );
$related_item_gap = logistix_get_mod( 'project_related_item_spacing', '17' );
$related_item_crop = logistix_get_mod( 'project_related_img_crop', 'square' );

$terms = get_the_terms( $post->ID, 'project_category' );
$term_ids = wp_list_pluck( $terms, 'term_id' );
?>
<div class="project-detail-wrap">
	<?php
	while ( have_posts() ) : the_post();
		the_content();
	endwhile;
	wp_reset_postdata();
	?>
</div>

<?php if ( logistix_get_mod( 'project_related', true )  ): ?>
<div class="project-related-wrap">
	<div class="logistix-container">
		<div class="title-wrap">
		<div class="logistix-divider has-icon">
			<div class="divider-icon">
				<span class="divider-icon-before divider-center divider-double-dotted" style="border-color:#a0a0a0;"></span>
				<h2 class="title"><span><?php echo esc_html( $related_title ); ?></span></h2>
				<span class="divider-icon-after divider-center divider-double-dotted" style="border-color:#a0a0a0;"></span>
			</div>
		</div>
		</div>

		<?php
		$query_args = array(
			'post_type' => 'project',
			'tax_query' => array(
				array(
				'taxonomy' => 'project_category',
				'field' => 'term_id',
				'terms' => $term_ids,
				'operator'=> 'IN'
				)),
			'ignore_sticky_posts' => 1,
			'post__not_in'=> array( $post->ID )
		);

		$query_args['posts_per_page'] = $related_query;
		$query = new WP_Query( $query_args );
		if ( $query->have_posts() ) : ?>
			<div class="project-related" data-gap="<?php echo esc_html( $related_item_gap ); ?>" data-column="<?php echo esc_html( $related_column ); ?>">
				<div class="owl-carousel owl-theme">
					<?php while ( $query->have_posts() ) : $query->the_post(); ?>
					<?php wp_enqueue_script( 'logistix-owlcarousel' ); ?>

					<div class="project-box style-3">
						<div class="inner">
							<?php
								if ( has_post_thumbnail() ) {
							    	$img_size = 'logistix-rectangle3';
		                    	}

		                    	$icon_html = sprintf('<div class="icon">
		                    		<a class="link" href="%1$s" title="%2$s"><i class="nz-plus2"></i></a>
		                    		<a class="zoom-popup" href="%3$s" data-title="%2$s"><i class="nz-magnifier3"></i></a>
		                    		</div>',
		                    		esc_url( get_the_permalink() ),
		                    		esc_attr( get_the_title() ),
		                    		logistix_get_image( array( 'size' => 'full', 'format' => 'src' ) )
		                    	);

		                    	$heading_html = sprintf('<a href="%1$s" title="%2$s"><h2 data-title="%3$s">%3$s</h2></a>', esc_url( get_the_permalink() ), esc_attr( get_the_title() ), get_the_title() );

		                		echo '<div class="project-wrap"><div class="project-image">'. get_the_post_thumbnail( get_the_ID(), $img_size ) .'</div><div class="project-text">'. $icon_html .'</div></div>'. $heading_html;
							?>
		                </div>
					</div><!-- /.project-box -->
					<?php endwhile; ?>
				</div><!-- /.owl-carousel -->
			</div><!-- /.project-related -->
		<?php
		endif; wp_reset_postdata();
		?>
	</div><!-- /.logistix-container -->
</div><!-- /.project-related-wrap -->
<?php endif; ?>

<?php get_footer(); ?>