<?php

// PDF Style 1

if($formtype == 'item'){
	$wpgv_hide_price = get_option('wpgv_hide_price_item') ? get_option('wpgv_hide_price_item') : 0;
}
else{
	$wpgv_hide_price = get_option('wpgv_hide_price_voucher') ? get_option('wpgv_hide_price_voucher') : 0;
}
$wpgv_hide_title_voucher = get_option('wpgv_hide_title_voucher') ? get_option('wpgv_hide_title_voucher') : 0;
$wpgv_barcode_on_voucher = get_option('wpgv_barcode_on_voucher') ? get_option('wpgv_barcode_on_voucher') : 0;
$wpgv_leftside_notice = (get_option('wpgv_leftside_notice') != '') ? get_option('wpgv_leftside_notice') : __('Cash payment is not possible. The terms and conditions apply.', 'gift-voucher' );
$text_preview = get_option('wpgv_voucher_text_preview') ? get_option('wpgv_voucher_text_preview') : __('This is preview voucher', 'gift-voucher');
$color_preview = get_option('wpgv_voucher_color_preview') ? get_option('wpgv_voucher_color_preview') : '#dd3333';
$color_preview = wpgv_hex2rgb($color_preview);
$pdf = new WPGV_PDF('P','pt',array(595,900));
$pdf->SetAutoPageBreak(0);
$pdf->AddPage();
if(get_locale() == "el"){
	$pdf->AddFont('Arial_Greek', '', 'Arial_Greek.php');
	$pdf->SetFont('Arial_Greek', '', 14);
}elseif(get_locale() == "cs_CZ"){
	$pdf->AddFont('arial_cz', '', 'arial.php');
	$pdf->SetFont('arial_cz', '', 14);
}
$pdf->Image($image, 0, 0, 595, 453);

$pdf->SetXY(0, 453);


$pdf->SetFillColor($voucher_bgcolor[0], $voucher_bgcolor[1], $voucher_bgcolor[2]);
$pdf->Cell(595,450,'',0,1,'L',1);

if($formtype == 'item') {
	//Title
	$pdf->SetXY(30, 460);
	if(get_locale() != "el"){
		$pdf->SetFont('Arial','B',16);
	}
	$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
	$pdf->SetFontSize(25);
	$pdf->MultiCell(550, 25, wpgv_em(get_the_title($itemid)), 0, 'C');
	
	//Description
	$pdf->SetXY(30, 500);
	if(get_locale() != "el"){
		$pdf->SetFont('Arial','B',12);
	}
	$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
	$pdf->MultiCell(550, 12, wpgv_em(get_post_meta( $itemid, 'description', true )), 0, 'C');
} 
else if($formtype == "voucher") {
	//Voucher
	$pdf->SetXY(30, 480);
	if(get_locale() != "el"){
		$pdf->SetFont('Arial','B',16);
	}
	$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
	$pdf->SetFontSize(25);
	if($wpgv_hide_title_voucher != 1){
		$pdf->MultiCell(550,25, wpgv_em($template_voucher),0,'C');
	}
}
else {
	//Title
	$pdf->SetXY(30, 460);
	if(get_locale() != "el"){
		$pdf->SetFont('Arial','B',16);
	}
	$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
	$pdf->SetFontSize(25);
	$pdf->MultiCell(550, 25, wpgv_em(get_the_title($product_id)), 0, 'C');
	
	//Description
	$pdf->SetXY(30, 500);
	if(get_locale() != "el"){
		$pdf->SetFont('Arial','B',12);
	}
	$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
	$pdf->MultiCell(550, 12, wpgv_em(get_post_meta( $product_id, 'description', true )), 0, 'C');
}
//For
if(get_locale() != "el"){
	$pdf->SetFont('Arial','',12);
}
$pdf->SetXY(30, 540);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(12);
$pdf->Cell(0,0,wpgv_em(__('Your Name', 'gift-voucher')),0,1,'L',0);
//For Input
$pdf->SetXY(33, 550);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(85,85,85);
$pdf->SetFontSize(15);
if(get_locale() == "cs_CZ"){
	$pdf->SetFont('arial_cz','',12);
	$pdf->Cell(265,30,' '.wpgv_em_cs_CZ($for),0,1,'L',1);
}else{
	$pdf->Cell(265,30,' '.wpgv_em($for),0,1,'L',1);
}


if($buyingfor != 'yourself') {
	//From
	$pdf->SetXY(310, 540);
	$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
	$pdf->SetFontSize(12);
	if(get_locale() == "cs_CZ"){
		$pdf->SetFont('arial_cz','',12);
		$pdf->Cell(0,0,wpgv_em_cs_CZ(__('Recipient Name', 'gift-voucher')),0,1,'L',0);
	}else{
		$pdf->Cell(0,0,wpgv_em(__('Recipient Name', 'gift-voucher')),0,1,'L',0);
	}
	
	//From Input
	$pdf->SetXY(313, 550);
	$pdf->SetFillColor(255,255,255);
	$pdf->SetTextColor(85,85,85);
	$pdf->SetFontSize(15);
	if(get_locale() == "cs_CZ"){
		$pdf->SetFont('arial_cz','',12);
		$pdf->Cell(265,30,' '.wpgv_em_cs_CZ($from),0,1,'L',1);
	}else{
		$pdf->Cell(265,30,' '.wpgv_em($from),0,1,'L',1);
	}
	
}
//Personal Message
$pdf->SetXY(30, 660);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(12);
$pdf->Cell(0,0,wpgv_em(__('Personal Message', 'gift-voucher')),0,1,'L',0);
//Personal Message Input
$pdf->SetXY(33, 670);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(85,85,85);
$pdf->SetFontSize(14);
$pdf->Cell(546,100,'',0,1,'L',1);
$pdf->SetXY(35, 672);
if(get_locale() == "cs_CZ"){
	$pdf->SetFont('arial_cz','',12);
	$pdf->MultiCell(543,20,wpgv_em_cs_CZ($message),0,1,'L',1);
}else{
	$pdf->MultiCell(543,20,wpgv_em($message),0,1,'L',1);
}


if(get_locale() != "el"){
	$pdf->SetFont('Arial','',12);
}
if(!$wpgv_hide_price) {
	//Voucher Value
	$pdf->SetXY(30, 600);
	
	$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
	$pdf->SetFontSize(12);
	if(get_locale() != "el"){
		$pdf->SetFont('Arial','',12);
	}
	$pdf->Cell(0,0,wpgv_em(__('Voucher Value', 'gift-voucher')),0,1,'L',0);
	//Voucher Value Input
	$pdf->SetXY(33, 610);
	$pdf->SetFillColor(255,255,255);
	$pdf->SetTextColor(85,85,85);
	$pdf->SetFontSize(16);
	if(get_locale() != "el"){
		$pdf->SetFont('Arial','',16);
	}
	if(get_locale() == "cs_CZ"){
		$pdf->SetFont('arial_cz','',16);
		$pdf->Cell(265,30,' '.$currency,0,1,'L',1);
	}else{
		$pdf->Cell(265,30,' '.wpgv_em($currency),0,1,'L',1);
	}
}

//Date of Expiry
$pdf->SetXY(310, 600);

$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(12);
$pdf->Cell(0,0,wpgv_em(__('Date of Expiry', 'gift-voucher')),0,1,'L',0);
//Date of Expiry Input
$pdf->SetXY(313, 610);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(85,85,85);
$pdf->SetFont('Arial','',16);
$pdf->SetFontSize(16);
if(get_locale() == "cs_CZ"){
	$pdf->SetFont('arial_cz','',16);
	$pdf->Cell(265,30,' '.wpgv_em_cs_CZ($expiry),0,1,'L',1);
}else{
	$pdf->Cell(265,30,' '.wpgv_em($expiry),0,1,'L',1);
}


//Coupon Code
$pdf->SetXY(30, 790);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(12);
$pdf->Cell(0,0,wpgv_em(__('Coupon Code', 'gift-voucher')),0,1,'L',0);
//Coupon Code Input
$pdf->SetXY(33, 800);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(85,85,85);
$pdf->SetFontSize(16);
$pdf->Cell(265,30,' '.wpgv_em($code),0,1,'L',1);

if($wpgv_barcode_on_voucher && !$preview) {
	$pdf->SetFillColor(0,0,0);
	$pdf->Code128(313,790,wpgv_em($code),265,50);
} elseif($wpgv_barcode_on_voucher) {
	$pdf->SetFillColor(0,0,0);
	$pdf->Code128(313,790,'4746489065070412',265,50);
}

//Company Details
$pdf->SetXY(30, 860);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(11);
$pdf->Cell(0,0,$setting_options->pdf_footer_url.' | '.wpgv_em($setting_options->pdf_footer_email),0,1,'C',0);

//Terms
$pdf->SetXY(0, 0);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(9);
$pdf->RotatedText(20,850,'* '.wpgv_em($wpgv_leftside_notice),90);

if($preview) {
	//Put the watermark
	$pdf->SetXY(0, 0);
	$pdf->SetFontSize(55);
	$pdf->SetFont('Arial','B',55);
	$pdf->SetTextColor($color_preview[0], $color_preview[1], $color_preview[2]);
	$pdf->RotatedText(75,700,wpgv_em($text_preview),45);
}