<?php

// namespace Sofort\SofortLib;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


use PayPalCheckoutSdk\Orders\OrdersCreateRequest;

function wpgv__doajax_voucher_pdf_save_func()
{

	$template = sanitize_text_field(base64_decode($_POST['template']));
	$wpgv_hide_title_voucher = get_option('wpgv_hide_title_voucher') ? get_option('wpgv_hide_title_voucher') : 0;
	if($wpgv_hide_title_voucher == 1) {
		$template_voucher = __('Gift voucher', 'gift-voucher');
	} else {
		$template_voucher = get_the_title($template);
	}

	$buyingfor = sanitize_text_field(base64_decode($_POST['buying_for']));
	$for = isset($_POST['for']) ? sanitize_text_field(base64_decode($_POST['for'])) : '';
	$from = isset($_POST['from']) ? sanitize_text_field(base64_decode($_POST['from'])) : '';
	$value = sanitize_text_field(base64_decode($_POST['value']));
	$message = isset($_POST['message']) ? sanitize_text_field(base64_decode($_POST['message'])) : '';
	$expiry = base64_decode($_POST['expiry']);
	$code = sanitize_text_field(base64_decode($_POST['code']));
	$shipping = sanitize_text_field(base64_decode($_POST['shipping']));
	$shipping_email = isset($_POST['shipping_email']) ? sanitize_email(base64_decode($_POST['shipping_email'])) : '';
	$firstname = isset($_POST['firstname']) ? sanitize_text_field(base64_decode($_POST['firstname'])) : '';
	$lastname = isset($_POST['lastname']) ? sanitize_text_field(base64_decode($_POST['lastname'])) : '';
	$email = isset($_POST['email']) ? sanitize_email(base64_decode($_POST['email'])) : '';
	$address = isset($_POST['address']) ? sanitize_text_field(base64_decode($_POST['address'])) : '';
	$pincode = isset($_POST['pincode']) ? sanitize_text_field(base64_decode($_POST['pincode'])) : '';
	$shipping_method = isset($_POST['shipping_method']) ? base64_decode($_POST['shipping_method']) : '';
	$paymentmethod = sanitize_text_field(base64_decode($_POST['paymentmethod']));
	$send_email_date_time = isset($_POST['send_email_date_time']) ? base64_decode($_POST['send_email_date_time']) : 'send_instantly';

	$your_phone = isset($_POST['your_phone']) ? sanitize_text_field(base64_decode($_POST['your_phone'])) : '';
	$your_email = isset($_POST['your_email']) ? sanitize_text_field(base64_decode($_POST['your_email'])) : '';


	// var_dump($your_phone);
	// var_dump($your_email);
	// exit;


	$paytext = '';
	if ($paymentmethod == 'Per Invoice') {
		$paytext = __('Per Invoice', 'gift-voucher');
	} else {
		$paytext = $paymentmethod;
	}
	$seller_company_name = isset($_POST['seller_company_name']) ? base64_decode($_POST['seller_company_name']) : '';
	$seller_addr_line1 = isset($_POST['seller_addr_line1']) ? base64_decode($_POST['seller_addr_line1']) : '';
	$seller_addr_line2 = isset($_POST['seller_addr_line2']) ? base64_decode($_POST['seller_addr_line2']) : '';
	$seller_addr_line3 = isset($_POST['seller_addr_line3']) ? base64_decode($_POST['seller_addr_line3']) : '';
	$seller_addr_line4 = isset($_POST['seller_addr_line4']) ? base64_decode($_POST['seller_addr_line4']) : '';

	global $wpdb;
	$voucher_table 	= $wpdb->prefix . 'giftvouchers_list';
	$setting_table 	= $wpdb->prefix . 'giftvouchers_setting';
	$template_table = $wpdb->prefix . 'giftvouchers_template';
	$invoice_setting_table = $wpdb->prefix . 'giftvouchers_invoice_settings';

	$setting_options = $wpdb->get_row("SELECT * FROM $setting_table WHERE id = 1");
	$template_options = $wpdb->get_row("SELECT * FROM $template_table WHERE id = $template");
	$invoice_options = $wpdb->get_row("SELECT * FROM $invoice_setting_table WHERE id = 1");

	$style1_image = get_post_meta($template, 'style1_image', true);
	$style2_image = get_post_meta($template, 'style2_image', true);
	$style3_image = get_post_meta($template, 'style3_image', true);

	$style_images_array = array(
		$style1_image,
		$style2_image,
		$style3_image,
	);

	$images = $style_images_array ? $style_images_array : ['', '', ''];

	$voucher_bgcolor = wpgv_hex2rgb($setting_options->voucher_bgcolor);
	$voucher_color = wpgv_hex2rgb($setting_options->voucher_color);
	$invoice_color = wpgv_hex2rgb($invoice_options->invoice_color);
	
	

	$wpgv_hide_expiry = get_option('wpgv_hide_expiry') ? get_option('wpgv_hide_expiry') : 'yes';
	$wpgv_customer_receipt = get_option('wpgv_customer_receipt') ? get_option('wpgv_customer_receipt') : 0;
	$wpgv_expiry_date_format = get_option('wpgv_expiry_date_format') ? get_option('wpgv_expiry_date_format') : 'd.m.Y';
	$wpgv_enable_pdf_saving = get_option('wpgv_enable_pdf_saving') ? get_option('wpgv_enable_pdf_saving') : 0;
	$wpgv_add_extra_charges = get_option('wpgv_add_extra_charges_voucher') ? get_option('wpgv_add_extra_charges_voucher') : 0;

	if (get_locale() == "cs_CZ") {
		$currency = wpgv_price_format_cs_CZ($value);
	} else {
		$currency = wpgv_price_format($value);
	}

	if ($wpgv_hide_expiry == 'no') {
		$expiry = __('No Expiry', 'gift-voucher');
	} else {
		$expiry = ($setting_options->voucher_expiry_type == 'days') ? date($wpgv_expiry_date_format, strtotime('+' . $setting_options->voucher_expiry . ' days', time())) . PHP_EOL : $setting_options->voucher_expiry;
	}

	if ($value == 0) {
		echo '<div class="wpgvmodaloverlay"><div class="wpgvmodalcontent">' . __('Error Occurred - Please check the amount and try again.', 'gift-voucher') . '<br><a href="">' . __('Load Page Again', 'gift-voucher') . '</a></div></div>';
		wp_die();
	}

	$upload = wp_upload_dir();
	$upload_dir = $upload['basedir'];
	$curr_time = time();
	$upload_dir = $upload_dir . '/voucherpdfuploads/' . $curr_time . $_POST['code'] . '.pdf';
	$upload_url = $curr_time . $_POST['code'];

	$formtype = 'voucher';
	$preview = false;

	if ($setting_options->is_style_choose_enable) {
		$voucher_style = sanitize_text_field(base64_decode($_POST['style']));
		$image_attributes = get_attached_file($images[$voucher_style]);
		$image = ($image_attributes) ? $image_attributes : get_option('wpgv_demoimageurl_voucher');
		$stripeimage = (wp_get_attachment_image_src($images[$voucher_style])) ? wp_get_attachment_image_src($images[$voucher_style]) : get_option('wpgv_demoimageurl_voucher');
	} else {
		$voucher_style = 0;
		$image_attributes = get_attached_file($images[0]);
		$image = ($image_attributes) ? $image_attributes : get_option('wpgv_demoimageurl_voucher');
		$stripeimage = (wp_get_attachment_image_src($images[0])) ? wp_get_attachment_image_src($images[0]) : get_option('wpgv_demoimageurl_voucher');
	}

	switch ($voucher_style) {
		case 0:
			require_once(WPGIFT__PLUGIN_DIR . '/templates/pdfstyles/style1.php');
			break;
		case 1:
			require_once(WPGIFT__PLUGIN_DIR . '/templates/pdfstyles/style2.php');
			break;
		case 2:
			require_once(WPGIFT__PLUGIN_DIR . '/templates/pdfstyles/style3.php');
			break;
		default:
			require_once(WPGIFT__PLUGIN_DIR . '/templates/pdfstyles/style1.php');
			break;
	}

	if ($wpgv_enable_pdf_saving) {
		$pdf->Output($upload_dir, 'F');
	} else {
		$pdf->Output('F', $upload_dir);
	}

	$wpdb->insert(
		$voucher_table,
		array(
			'order_type'		=> 'vouchers',
			'template_id' 		=> $template,
			'buying_for'		=> $buyingfor,
			'from_name' 		=> $for,
			'to_name' 			=> $from,
			'amount'			=> $value,
			'message'			=> $message,
			'shipping_type'		=> $shipping,
			'shipping_email'	=> $shipping_email,
			'firstname'			=> $firstname,
			'lastname'			=> $lastname,
			'email'				=> $email,
			'address'			=> $address,
			'postcode'			=> $pincode,
			'shipping_method'	=> $shipping_method,
			'pay_method'		=> $paymentmethod,
			'expiry'			=> $expiry,
			'couponcode'		=> $code,
			'voucherpdf_link'	=> $upload_url,
			'status'			=> 'unused',
			'payment_status'	=> 'Not Paid',
			'voucheradd_time'	=> current_time('mysql'),
			'email_send_date_time' => 'unsent',
			'your_phone' => $your_phone,
			'your_email' => $your_email,
		)
	);

	$lastid = $wpdb->insert_id;

	$voucher_order_by = __("Voucher ordered by", "gift-voucher");
	$message_e = __("Message:", "gift-voucher");
	WPGV_Gift_Voucher_Activity::record($lastid, 'create', '', $voucher_order_by . " " . $for . ',' . $message_e . " " . $message);

	$shipping_charges = 0;

	if ($shipping != 'shipping_as_email') {
		$preshipping_methods = explode(',', $setting_options->shipping_method);
		foreach ($preshipping_methods as $method) {
			$preshipping_method = explode(':', $method);
			if (trim(stripslashes($preshipping_method[1])) == trim(stripslashes($shipping_method))) {
				$value += trim($preshipping_method[0]);
				$shipping_charges = trim($preshipping_method[0]);
				break;
			}
		}
	}

	if ($wpgv_add_extra_charges != 0) {
		$value += $wpgv_add_extra_charges; // Add the extra charges to value
	}

	if ($invoice_options->is_invoice_active == 1) {
		$upload_dir = $upload['basedir'];
		$invoiceupload_dir = $upload_dir . '/voucherpdfuploads/' . $curr_time . $_POST['code'] . '-invoice.pdf';
		require_once(WPGIFT__PLUGIN_DIR . '/templates/pdfstyles/invoice-1.php');
		if ($wpgv_enable_pdf_saving) {
			$invoice->Output($invoiceupload_dir, 'F');
		} else {
			$invoice->Output('F', $invoiceupload_dir);
		}
	}

	//Customer Receipt
	if ($wpgv_customer_receipt) {
		$upload_dir = $upload['basedir'];
		$receiptupload_dir = $upload_dir . '/voucherpdfuploads/' . $curr_time . $_POST['code'] . '-receipt.pdf';
		require_once(WPGIFT__PLUGIN_DIR . '/templates/pdfstyles/receipt.php');
		if ($wpgv_enable_pdf_saving) {
			$receipt->Output($receiptupload_dir, 'F');
		} else {
			$receipt->Output('F', $receiptupload_dir);
		}
	}



	update_post_meta($lastid, 'wpgv_extra_charges', $wpgv_add_extra_charges);
	update_post_meta($lastid, 'wpgv_total_payable_amount', $value);

	$success_url = get_home_url() . '/voucher-payment-successful/?voucheritem=' . $lastid;
	$cancel_url = get_home_url() . '/voucher-payment-cancel/?voucheritem=' . $lastid;
	$notify_url = get_home_url() . '/voucher-payment-successful/?voucheritem=' . $lastid;

	$wpgv_paypal_client_id = get_option('wpgv_paypal_client_id') ? get_option('wpgv_paypal_client_id') : '';
	$wpgv_paypal_secret_key = get_option('wpgv_paypal_secret_key') ? get_option('wpgv_paypal_secret_key') : '';

	if ($paymentmethod == 'Paypal') {
		if (empty($wpgv_paypal_client_id) || empty($wpgv_paypal_secret_key)) {
			$error_message = "PayPal Client ID or Secret Key are both empty.";
			wp_send_json_error(array('message' => $error_message));
		} else {
			require_once(WPGIFT__PLUGIN_DIR . '/vendor/autoload.php');
			require_once(WPGIFT__PLUGIN_DIR . '/include/PayPalAuth.php');

			if (!PayPalAuth::isCredentialsValid()) {
				$error_message = "PayPal Client ID or Secret Key is invalid or the PayPal Mode is not compatible with the provided credentials.";
				wp_send_json_error(array('message' => $error_message));
			} else {
				require_once(WPGIFT__PLUGIN_DIR . '/vendor/autoload.php');
				require_once(WPGIFT__PLUGIN_DIR . '/include/PayPalAuth.php');

				$client = PayPalAuth::client();
				$request = new OrdersCreateRequest();
				$request->prefer('return=representation');
				$request->body = [
					"intent" => "CAPTURE",
					"purchase_units" => [[
						"reference_id" => $template_voucher,
						"amount" => [
							"value" => $value,
							"currency_code" => $setting_options->currency_code
						]
					]],
					"application_context" => [
						"cancel_url" => $cancel_url,
						"return_url" => $success_url
					]
				];

				try {
					// Call API with your client and get a response for your call
					$response = $client->execute($request);
					session_start();
					$_SESSION["paypal_order_id"] = strval($response->result->id);

					// Initialize an empty approve_link variable
					$approve_link = '';

					// If call returns body in response, you can get the deserialized version from the result attribute of the response
					foreach ($response->result->links as $link) {
						if ($link->rel == "approve") {
							$approve_link = $link->href;
						}
					}

					// Check if the approve_link is empty
					if (!empty($approve_link)) {
						wp_send_json_success(array('message' => "PayPal valid.", 'approve_link' => $approve_link));
					} else {
						wp_send_json_error(array('message' => "No PayPal approve link found."));
					}
				} catch (HttpException $ex) {
					echo $ex->statusCode;
					print_r($ex->getMessage());
				}
			}
		}
	} elseif ($paymentmethod == 'Sofort') {

		$Sofortueberweisung = new Sofortueberweisung($setting_options->sofort_configure_key);

		$Sofortueberweisung->setAmount($value);
		$Sofortueberweisung->setCurrencyCode($setting_options->currency_code);

		$Sofortueberweisung->setReason($setting_options->reason_for_payment, $lastid);
		$Sofortueberweisung->setSuccessUrl($success_url, true);
		$Sofortueberweisung->setAbortUrl($cancel_url);
		// $Sofortueberweisung->setNotificationUrl($notify_url);

		$Sofortueberweisung->sendRequest();

		if ($Sofortueberweisung->isError()) {
			//SOFORT-API didn't accept the data
			// echo $Sofortueberweisung->getError();
			$error_message = "Sofort is invalid.";
			wp_send_json_error(array('message' => $error_message));
		} else {
			//buyer must be redirected to $paymentUrl else payment cannot be successfully completed!
			$paymentUrl = $Sofortueberweisung->getPaymentUrl();
			wp_send_json_success(array('message' => "Sofort valid.", 'approve_link' => $paymentUrl));
		}
	} elseif ($paymentmethod == 'Stripe') {

		$stripesuccesspageurl = get_option('wpgv_stripesuccesspage');

		//set api key
		$stripe = array(
			"publishable_key" => $setting_options->stripe_publishable_key,
			"secret_key"      => $setting_options->stripe_secret_key,
		);

		$camount = ($value) * 100;
		$stripeemail = ($email) ? $email : $shipping_email;

		\Stripe\Stripe::setApiKey($stripe['secret_key']);

		$is_stripe_ideal_enable = get_option('wpgv_stripe_ideal');

		//fix new
		if ($is_stripe_ideal_enable == 1) {
			$session = \Stripe\Checkout\Session::create([
				'payment_method_types' => ['card', 'ideal'],
				'line_items' => [[
					'price_data' => [
						'currency' => $setting_options->currency_code,
						'unit_amount' => $camount,
						'product_data' => [
							'name' => $template_voucher,
							'images' => [wp_sanitize_redirect($stripeimage)],
						],
					],
					'quantity' => 1,
				]],
				'mode' => 'payment',
				'success_url' => get_page_link($stripesuccesspageurl) . '/?voucheritem=' . $lastid . '&sessionid={CHECKOUT_SESSION_ID}',
				'cancel_url' => $cancel_url,
			]);
		} else {

			$session = \Stripe\Checkout\Session::create([
				'payment_method_types' => ['card'],
				'line_items' => [[
					'price_data' => [
						'currency' => $setting_options->currency_code,
						'unit_amount' => $camount,
						'product_data' => [
							'name' => $template_voucher,
							'images' => [wp_sanitize_redirect($stripeimage)],
						],
					],
					'quantity' => 1,
				]],
				'mode' => 'payment',
				'success_url' => get_page_link($stripesuccesspageurl) . '/?voucheritem=' . $lastid . '&sessionid={CHECKOUT_SESSION_ID}',
				'cancel_url' => $cancel_url,
			]);
		}

		$stripesuccesspageurl = get_option('wpgv_stripesuccesspage');
		$stripeemail = ($email) ? $email : $shipping_email;
		wp_send_json_success(array('message' => "Stripe valid.", 'approve_link' => $session->url));
	} elseif ($paymentmethod == 'MultiSafepay') {
		$wpgv_multisafepay_test_mode = get_option('wpgv_multisafepay_test_mode') ? get_option('wpgv_multisafepay_test_mode') : '';
		$wpgv_multisafepay_api_id = get_option('wpgv_multisafepay_api_id') ? get_option('wpgv_multisafepay_api_id') : '0ff28d5cc3a6e7475be5fa174703788fa155fc94';
		$msp_api_url = $wpgv_multisafepay_test_mode ? 'https://testapi.multisafepay.com/v1/json/' : 'https://api.multisafepay.com/v1/json/';
		$msp = new \MultiSafepayAPI\Client;
		$msp->setApiKey($wpgv_multisafepay_api_id);
		$msp->setApiUrl($msp_api_url);
		$camount = ($value) * 100;
		try {
			$order_id = $lastid;

			$order = $msp->orders->post(array(
				"type" => "redirect",
				"order_id" => $order_id,
				"currency" => $setting_options->currency_code,
				"amount" => $camount,
				"description" => $template_options->title,
				"payment_options" => array(
					"notification_url" => $notify_url,
					"redirect_url" => $success_url,
					"cancel_url" => $cancel_url,
					"close_window" => "true"
				),
				"customer" => array(
					"ip_address" => $_SERVER['REMOTE_ADDR'],
					"forwarded_ip" => $_SERVER['REMOTE_ADDR'],
					"first_name" => $from,
					"email" => $email,
				),
			));

			wp_send_json_success(array('message' => "Per Invoice valid.", 'approve_link' => $msp->orders->getPaymentLink()));
		} catch (Exception $e) {
			wp_send_json_error(array('message' => "Error " . htmlspecialchars($e->getMessage())));
		}
	} elseif ($paymentmethod == 'Per Invoice') {
		wp_send_json_success(array('message' => "Per Invoice valid.", 'approve_link' => $success_url . '&per_invoice=1'));
	}

	wp_die();
}
add_action('wp_ajax_nopriv_wpgv_doajax_voucher_pdf_save_func', 'wpgv__doajax_voucher_pdf_save_func');
add_action('wp_ajax_wpgv_doajax_voucher_pdf_save_func', 'wpgv__doajax_voucher_pdf_save_func');
