<?php

if( !defined( 'ABSPATH' ) ) exit;  // Exit if accessed directly

// Register WPGV Item Post Type
function wpgv_voucher_product_function() {

	$labels = array(
		'name'                  => __( 'Giftcard standard Templates', 'Post Type General Name', 'gift-voucher' ),
		'singular_name'         => __( 'Giftcard standard', 'Post Type Singular Name', 'gift-voucher' ),
		'menu_name'             => __( 'Giftcard standard', 'gift-voucher' ),
		'name_admin_bar'        => __( 'Giftcard standard', 'gift-voucher' ),
		'archives'              => __( 'Giftcard standard Archives', 'gift-voucher' ),
		'attributes'            => __( 'Giftcard standard Attributes', 'gift-voucher' ),
		'parent_item_colon'     => __( 'Parent Giftcard standard:', 'gift-voucher' ),
		'all_items'             => __( 'All Giftcard standard', 'gift-voucher' ),
		'add_new_item'          => __( 'Add New', 'gift-voucher' ),
		'add_new'               => __( 'Add New', 'gift-voucher' ),
		'new_item'              => __( 'New Giftcard standard', 'gift-voucher' ),
		'edit_item'             => __( 'Edit Giftcard standard', 'gift-voucher' ),
		'update_item'           => __( 'Update Giftcard standard', 'gift-voucher' ),
		'view_item'             => __( 'View Giftcard standard', 'gift-voucher' ),
		'view_items'            => __( 'View Giftcard standard', 'gift-voucher' ),
		'search_items'          => __( 'Search', 'gift-voucher' ),
		'not_found'             => __( 'Not found', 'gift-voucher' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'gift-voucher' ),
		'featured_image'        => __( 'Featured Image', 'gift-voucher' ),
		'set_featured_image'    => __( 'Set Item image', 'gift-voucher' ),
		'remove_featured_image' => __( 'Remove featured image', 'gift-voucher' ),
		'use_featured_image'    => __( 'Use as featured image', 'gift-voucher' ),
		'insert_into_item'      => __( 'Insert into Giftcard standard', 'gift-voucher' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Giftcard standard', 'gift-voucher' ),
		'items_list'            => __( 'Items list', 'gift-voucher' ),
		'items_list_navigation' => __( 'Items list navigation', 'gift-voucher' ),
		'filter_items_list'     => __( 'Filter Items list', 'gift-voucher' ),
	);
	$args = array(
		'label'                 => __( 'Giftcard standard', 'gift-voucher' ),
		'description'           => __( 'Create your store Items as a product', 'gift-voucher' ),
		'labels'                => $labels,
		'supports'              => array( 'title' ),
		'taxonomies'            => array( 'wpgv_voucher_category' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => 'wpgv-gift-cards',
		'menu_position'         => 5,
		'menu_icon'             => 'dashicons-tickets-alt',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => false,
		'has_archive'           => false,
		'exclude_from_search'   => true,
		'publicly_queryable'    => false,
		'rewrite'               => false,
		'capability_type'       => 'post',
	);
	register_post_type( 'wpgv_voucher_product', $args );

}
add_action( 'init', 'wpgv_voucher_product_function', 0 );

function hide_gift_items_menu_item() {
	add_action( 'admin_menu', function() {
		remove_submenu_page( 'wpgv-gift-cards', 'edit.php?post_type=wpgv_voucher_product' );
		remove_submenu_page( 'wpgv-gift-cards', 'edit.php?post_type=voucher_template' );
	}, 999 );
}
add_action( 'init', 'hide_gift_items_menu_item' );


// Thêm cột "Templates Style"
function wpgv_add_templates_style_column($columns) {
    $columns['templates_style'] = __('View mode', 'gift-voucher');
    return $columns;
}
add_filter('manage_wpgv_voucher_product_posts_columns', 'wpgv_add_templates_style_column');

// Hiển thị giá trị của cột "Templates Style"
function wpgv_display_templates_style_column($column, $post_id) {
    if ($column === 'templates_style') {
        $templates_style = get_post_meta($post_id, 'wpgv_templates_style', true);
        if ($templates_style === 'gift_voucher') {
            echo 'Grid view';
        }else{
			echo 'List view';
		}
    }
}
add_action('manage_wpgv_voucher_product_posts_custom_column', 'wpgv_display_templates_style_column', 10, 2);


// Register WPGV Item Taxonomy
function wpgv_voucher_category_function() {

	$labels = array(
		'name'                       => __( 'Giftcard standard Categories', 'Taxonomy General Name', 'gift-voucher' ),
		'singular_name'              => __( 'Giftcard standard Category', 'Taxonomy Singular Name', 'gift-voucher' ),
		'menu_name'                  => __( 'Giftcard standard Category', 'gift-voucher' ),
		'all_items'                  => __( 'All Giftcard standard Categories', 'gift-voucher' ),
		'parent_item'                => __( 'Parent Category', 'gift-voucher' ),
		'parent_item_colon'          => __( 'Parent Category:', 'gift-voucher' ),
		'new_item_name'              => __( 'New Category Name', 'gift-voucher' ),
		'add_new_item'               => __( 'Add New Category', 'gift-voucher' ),
		'edit_item'                  => __( 'Edit Category', 'gift-voucher' ),
		'update_item'                => __( 'Update Category', 'gift-voucher' ),
		'view_item'                  => __( 'View Category', 'gift-voucher' ),
		'separate_items_with_commas' => __( 'Separate Categories with commas', 'gift-voucher' ),
		'add_or_remove_items'        => __( 'Add or remove Categories', 'gift-voucher' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'gift-voucher' ),
		'popular_items'              => __( 'Popular Categories', 'gift-voucher' ),
		'search_items'               => __( 'Search Categories', 'gift-voucher' ),
		'not_found'                  => __( 'Not Found', 'gift-voucher' ),
		'no_terms'                   => __( 'No Categories', 'gift-voucher' ),
		'items_list'                 => __( 'Categories list', 'gift-voucher' ),
		'items_list_navigation'      => __( 'Categories list navigation', 'gift-voucher' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => false,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'rewrite'                    => false,
	);
	register_taxonomy( 'wpgv_voucher_category', array( 'wpgv_voucher_product' ), $args );

}
add_action( 'init', 'wpgv_voucher_category_function', 0 );


// Register Voucher Template
function codemenschen_voucher_template() {
    $labels = array(
		'name'                  => __( 'Giftcard modern', 'Post Type General Name', 'gift-voucher' ),
		'singular_name'         => __( 'Giftcard modern', 'Post Type Singular Name', 'gift-voucher' ),
		'menu_name'             => __( 'Giftcard modern', 'gift-voucher' ),
		'name_admin_bar'        => __( 'Giftcard modern', 'gift-voucher' ),
		'archives'              => __( 'Giftcard modern Archives', 'gift-voucher' ),
		'attributes'            => __( 'Giftcard modern Attributes', 'gift-voucher' ),
		'parent_item_colon'     => __( 'Parent Giftcard modern:', 'gift-voucher' ),
		'all_items'             => __( 'All Giftcard modern', 'gift-voucher' ),
		'add_new_item'          => __( 'Add New Giftcard modern', 'gift-voucher' ),
		'add_new'               => __( 'Add New Giftcard modern', 'gift-voucher' ),
		'new_item'              => __( 'New Giftcard modern', 'gift-voucher' ),
		'edit_item'             => __( 'Edit Giftcard modern', 'gift-voucher' ),
		'update_item'           => __( 'Update Giftcard modern', 'gift-voucher' ),
		'view_item'             => __( 'View Giftcard modern', 'gift-voucher' ),
		'view_items'            => __( 'View Giftcard modern', 'gift-voucher' ),
		'search_items'          => __( 'Search Giftcard modern', 'gift-voucher' ),
		'not_found'             => __( 'Not found', 'gift-voucher' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'gift-voucher' ),
		'featured_image'        => __( 'Featured Image', 'gift-voucher' ),
		'set_featured_image'    => __( 'Set Giftcard modern image', 'gift-voucher' ),
		'remove_featured_image' => __( 'Remove featured image', 'gift-voucher' ),
		'use_featured_image'    => __( 'Use as featured image', 'gift-voucher' ),
		'insert_into_item'      => __( 'Insert into Giftcard modern', 'gift-voucher' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Giftcard modern', 'gift-voucher' ),
		'items_list'            => __( 'Vouchers list', 'gift-voucher' ),
		'items_list_navigation' => __( 'Vouchers list navigation', 'gift-voucher' ),
		'filter_items_list'     => __( 'Filter Vouchers list', 'gift-voucher' ),
	);
    $args = array(
        'label'                 => __( 'Giftcard modern', 'skycodec' ),
        'labels'                => $labels,
        'supports'              => array( 'title'),
        'taxonomies'            => array( 'category_voucher_template' ),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => 'wpgv-gift-cards',
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-admin-generic',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'page',
    );
    register_post_type( 'voucher_template', $args );

}
add_action( 'init', 'codemenschen_voucher_template', 0 );

// Register Voucher Categories
function codemenschen_voucher_template_category() {

    $labels = array(
        'name'                       => __( 'Giftcard modern Categories', 'Taxonomy General Name', 'gift-voucher' ),
		'singular_name'              => __( 'Giftcard modern Category', 'Taxonomy Singular Name', 'gift-voucher' ),
		'menu_name'                  => __( 'Giftcard modern Category', 'gift-voucher' ),
		'all_items'                  => __( 'All Giftcard modern Categories', 'gift-voucher' ),
		'parent_item'                => __( 'Parent Category', 'gift-voucher' ),
		'parent_item_colon'          => __( 'Parent Category:', 'gift-voucher' ),
		'new_item_name'              => __( 'New Category Name', 'gift-voucher' ),
		'add_new_item'               => __( 'Add New Category', 'gift-voucher' ),
		'edit_item'                  => __( 'Edit Category', 'gift-voucher' ),
		'update_item'                => __( 'Update Category', 'gift-voucher' ),
		'view_item'                  => __( 'View Category', 'gift-voucher' ),
		'separate_items_with_commas' => __( 'Separate Categories with commas', 'gift-voucher' ),
		'add_or_remove_items'        => __( 'Add or remove Categories', 'gift-voucher' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'gift-voucher' ),
		'popular_items'              => __( 'Popular Categories', 'gift-voucher' ),
		'search_items'               => __( 'Search Categories', 'gift-voucher' ),
		'not_found'                  => __( 'Not Found', 'gift-voucher' ),
		'no_terms'                   => __( 'No Categories', 'gift-voucher' ),
		'items_list'                 => __( 'Categories list', 'gift-voucher' ),
		'items_list_navigation'      => __( 'Categories list navigation', 'gift-voucher' ),
    );
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
        'rewrite'                    => true,
    );
    register_taxonomy( 'category_voucher_template', array( 'voucher_template' ), $args );

}
add_action( 'init', 'codemenschen_voucher_template_category', 0 );

