<?php
function wpgv_giftcard_standard_shortcode($atts) {
    // Default attributes for the shortcode
    $atts = shortcode_atts(array(
        'style' => 'list',        // Default style
        'item_id' => 0,           // Default item ID
        'voucher_id' => 0,           // Default item ID
        'item_cat_id' => 0        // Default item category ID
    ), $atts, 'wpgv_giftcard_standard');

    // Extract the attributes for easy access
    $style = $atts['style'];
    $item_id = $atts['item_id'];
    $voucher_id = $atts['voucher_id'];
    $item_cat_id = $atts['item_cat_id'];

    // Check the value of 'style' and apply the corresponding code
    if ($style === 'grid') {
        // Apply grid style display
        // Assuming wpgv_voucher_shortcode() can handle item_id and item_cat_id
        return wpgv_voucher_shortcode(array('voucher_id' => $voucher_id));
    } elseif ($style === 'list') {
        // Apply list style display
        return wpgv_giftitems_shortcode(array('item_id' => $item_id, 'item_cat_id' => $item_cat_id));
    } else {
        // Return an error message if the style value is invalid
        return 'Error: Invalid style value. Please use "grid" or "list" for the style parameter.';
    }
}

// Register the shortcode [wpgv_giftcard_standard]
add_shortcode('wpgv_giftcard_standard', 'wpgv_giftcard_standard_shortcode');
