<?php
/**
* The default template for displaying content
*
* Used for both single and index/archive/search.
*
* @package WordPress
* @subpackage nt_agricom
* @since nt_agricom 1.0
*/

$meta_display = ot_get_option( 'nt_agricom_blog_post_meta_display' );
$date_display = ot_get_option( 'nt_agricom_blog_post_date_display' );
$cat_display = ot_get_option( 'nt_agricom_blog_post_cat_display' );
$comments_display = ot_get_option( 'nt_agricom_blog_post_comment_display' );
$excerpt_display = ot_get_option( 'nt_agricom_blog_post_excerpt_display' );
$thumb_size = ot_get_option( 'nt_agricom_blog_post_thumb_size' );
$thumb_size = ! is_single() && $thumb_size ? $thumb_size : 'full';

?>

<div id="post-<?php the_ID(); ?>" <?php post_class('col-xs-12 col-md-6 col-lg-4  js-isotope__item'); ?>>
    <div class="blog__item  mx-auto">

        <?php if ( has_post_thumbnail() ) : ?>
            <figure>
                <a href="<?php echo esc_url( get_permalink() ); ?>">
                    <?php the_post_thumbnail( $thumb_size, array('class'=>'img-fluid') ); ?>
                </a>
            </figure>
        <?php endif; ?>

        <div class="blog__entry">

            <?php if ( 'off' != $meta_display ) : ?>
                <?php if ( 'off' != $date_display ) : ?>
                    <div class="blog__post-date">
                        <span><?php echo the_time('d'); ?></span>
                        <span><?php echo the_time('M'); ?><br /><?php echo the_time('Y'); ?></span>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <h3 class="blog__entry__title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h3>

            <?php if ( 'off' != $meta_display ) : ?>
                <?php $num_comments = get_comments_number(); // get_comments_number returns only a numeric value

                if ( comments_open() ) {
                    if ( $num_comments == 0 ) {
                        $comments = esc_html__('No Comments', 'nt-agricom');
                    } elseif ( $num_comments > 1 ) {
                        $comments = $num_comments . esc_html__(' Comments', 'nt-agricom');
                    } else {
                        $comments = esc_html__('1 Comment', 'nt-agricom');
                    }
                    $write_comments = '<a href="' . get_comments_link() .'">'. $comments.'</a>';
                } else {
                    $write_comments =  esc_html__('Comments are off for this post.', 'nt-agricom');
                }
                ?>

                <?php if ( 'off' != $cat_display || 'off' != $comments_display ) : ?>
                    <span class="blog__entry__meta">
                        <?php if ( 'off' != $cat_display ) : ?>
                            <?php the_category(' , '); ?>
                        <?php endif; ?>
                        <?php if ( 'off' != $cat_display && 'off' != $comments_display ) : ?> | <?php endif; ?>
                        <?php if ( 'off' != $comments_display ) : ?>
                            <?php echo nt_agricom_sanitize_data( $write_comments ); ?>
                        <?php endif; ?>
                    </span>
                <?php endif; ?>
            <?php endif; ?>

            <?php

            if ( ! is_single() ) {

                if ( 'off' != $excerpt_display ) {
                    if ( has_excerpt() ) {

                        the_excerpt();

                    } else {

                        $content = get_the_content();
                        $content = substr( $content, 0, 150 );

                    }
                }

            } else {
                /* translators: %s: Name of current post */
                the_content( sprintf(
                    esc_html__( 'Continue reading %s', 'nt-agricom' ),
                    the_title( '<span class="screen-reader-text">', '</span>', false )
                ) );

                wp_link_pages( array(
                    'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'nt-agricom' ) . '</span>',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                    'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'nt-agricom' ) . ' </span>%',
                    'separator'   => '<span class="screen-reader-text">, </span>',
                ) );
            }
            ?>
        </div>
    </div>
</div>
