/*
* Theme Overlay menu
*/
jQuery(document).ready(function($){
    'use strict';

    var rtl = $('body').hasClass('rtl') ? true : false;
    var win = $(window);
    /* Navbar Menu */

    win.on("scroll", function () {
        var bodyScroll = win.scrollTop();

        if ( bodyScroll > 100 ) {
            $("body").addClass("scroll-start");
        } else {
            $("body").removeClass("scroll-start");
        }
    });

    function agricomHeaderMenu() {

        var tlm = gsap.timeline();
        var tlg = gsap.timeline();

        gsap.to($('.main-menu .sub-menu > .menu-item > div > a'), {yPercent: 80,autoAlpha: 0})
        gsap.to($('.main-menu > .menu-item > div > a'), {yPercent: 0,autoAlpha: 1});

        $('.main-menu li.menu-item--has-child > div > a').on("click", function() {

            var parentUl = $(this).parent().next();
            var parentItems = $(this).parent().parent().parent().find('> .menu-item > div > a');
            var subItems = $(this).parent().next().find('> .menu-item > div > a');

            parentUl.addClass('opened');

            gsap.to(parentUl, .01, {height: 'auto',autoAlpha: 1,ease: Quad.easeOut})
            gsap.to(parentItems, {yPercent: 80,duration: .5,autoAlpha: 0,ease: Quad.easeOut})
            gsap.to(subItems, {yPercent: 0,duration: .5,delay:.3,autoAlpha: 1,ease: Quad.easeOut});
        });

        $('.main-menu .sub-menu .goback').on("click", function() {

            var parentUl   = $(this).parent();
            var subItems   = parentUl.find('> .menu-item > div > a');
            var paretItems = parentUl.parent().parent().find('> .menu-item > div > a');

            parentUl.toggleClass('opened');

            gsap.to(subItems, {yPercent: 80,duration: .5,autoAlpha: 0,ease: Quad.easeOut})
            gsap.to(parentUl, {autoAlpha: 0,height: 0,ease: Quad.easeOut})
            gsap.to(paretItems, {yPercent: 0,duration: .5,delay:.3,autoAlpha: 1,ease: Quad.easeOut});
        });
    }

    function agricomHeaderOverlay() {
        var open = false;

        if ( !$('.main-overlaymenu').length ) {
            return;
        }
        if ( $('body').hasClass('rtl') ) {
            gsap.to($('.overlaymenu-content'), {right: '-100%',autoAlpha: 0,});
            gsap.to($('.main-overlaymenu .menu-wrapper'), {xPercent: 40,autoAlpha: 0,});
            gsap.to($('.main-overlaymenu .menu-info'), {xPercent: 10, autoAlpha: 0,});
        } else {
            gsap.to($('.overlaymenu-content'), {left: '-100%',autoAlpha: 0,});
            gsap.to($('.main-overlaymenu .menu-wrapper'), {xPercent: -40,autoAlpha: 0,});
            gsap.to($('.main-overlaymenu .menu-info'), {xPercent: -10, autoAlpha: 0,});
        }

        $('.main-overlaymenu .menu-toggle, .main-overlaymenu .hamburger').on('click', function () {
            open = !open;

            $('.hamburger').toggleClass("is-active");

            if ( open ) {
                $('.main-overlaymenu').addClass("open");
                if ( $('body').hasClass('rtl') ) {
                    gsap.to($('.main-overlaymenu .overlaymenu-content'), {right: '0%',autoAlpha: 1});
                    gsap.to($('.main-overlaymenu .menu-wrapper'), {xPercent: 0,duration: .7,autoAlpha: 1,delay:.3,ease: Power1.easeInOut})
                    gsap.to($('.main-overlaymenu .menu-info'), {xPercent: 0,duration: .7,autoAlpha: 1,delay:.7,ease: Power1.easeInOut});
                } else {
                    gsap.to($('.main-overlaymenu .overlaymenu-content'), {left: '0%',autoAlpha: 1});
                    gsap.to($('.main-overlaymenu .menu-wrapper'), {xPercent: 0,duration: .7,autoAlpha: 1,delay:.3,ease: Power1.easeInOut})
                    gsap.to($('.main-overlaymenu .menu-info'), {xPercent: 0,duration: .7,autoAlpha: 1,delay:.7,ease: Power1.easeInOut});
                }

            } else {

                if ( $('body').hasClass('rtl') || $('body').hasClass('sidebar-menu-right') ) {
                    gsap.to($('.main-overlaymenu .menu-wrapper'), {autoAlpha: 0,duration: .5,xPercent: 40,ease: Quad.easeOut});
                    gsap.to($('.main-overlaymenu .menu-info'), {autoAlpha: 0,duration: .6,xPercent: 10,ease: Quad.easeOut});
                    gsap.to($('.main-overlaymenu .overlaymenu-content'), {right: '-100%',duration: .5,delay:.8,autoAlpha: 1,ease: Quad.easeOut});
                } else {
                    gsap.to($('.main-overlaymenu .menu-wrapper'), {autoAlpha: 0,duration: .5,xPercent: -40,ease: Quad.easeOut});
                    gsap.to($('.main-overlaymenu .menu-info'), {autoAlpha: 0,duration: .6,xPercent: -10,ease: Quad.easeOut});
                    gsap.to($('.main-overlaymenu .overlaymenu-content'), {left: '-100%',duration: .5,delay:.8,autoAlpha: 1,ease: Quad.easeOut});
                }
                setTimeout(function() {
                    $('.main-overlaymenu').removeClass("open");
                }, 1000);

            }

            var sublang = $('.sub-list');
            if ( sublang.hasClass( 'show' ) ) {
                sublang.removeClass( 'show' );
            }
        });
        $('.internal .link').on('click', function () {
            open = !open;
            $('.main-overlaymenu').toggleClass("open");
            $('.hamburger').toggleClass("is-active");

            if ( open ) {
                if ( $('body').hasClass('rtl') ) {
                    gsap.to($('.main-overlaymenu .overlaymenu-content'), {right: '0%',autoAlpha: 1});
                    gsap.to($('.main-overlaymenu .menu-wrapper'), {xPercent: 0,duration: .7,autoAlpha: 1,delay:.3,ease: Power1.easeInOut})
                    gsap.to($('.main-overlaymenu .menu-info'), {xPercent: 0,duration: .7,autoAlpha: 1,delay:.7,ease: Power1.easeInOut});
                } else {
                    gsap.to($('.main-overlaymenu .overlaymenu-content'), {left: '0%',autoAlpha: 1});
                    gsap.to($('.main-overlaymenu .menu-wrapper'), {xPercent: 0,duration: .7,autoAlpha: 1,delay:.3,ease: Power1.easeInOut})
                    gsap.to($('.main-overlaymenu .menu-info'), {xPercent: 0,duration: .7,autoAlpha: 1,delay:.7,ease: Power1.easeInOut});
                }

            } else {

                if ( $('body').hasClass('rtl') || $('body').hasClass('sidebar-menu-right') ) {
                    gsap.to($('.main-overlaymenu .menu-wrapper'), {autoAlpha: 0,duration: .5,xPercent: 40,ease: Quad.easeOut});
                    gsap.to($('.main-overlaymenu .menu-info'), {autoAlpha: 0,duration: .6,xPercent: 10,ease: Quad.easeOut});
                    gsap.to($('.main-overlaymenu .overlaymenu-content'), {right: '-100%',duration: .5,delay:.8,autoAlpha: 1,ease: Quad.easeOut});
                } else {
                    gsap.to($('.main-overlaymenu .menu-wrapper'), {autoAlpha: 0,duration: .5,xPercent: -40,ease: Quad.easeOut});
                    gsap.to($('.main-overlaymenu .menu-info'), {autoAlpha: 0,duration: .6,xPercent: -10,ease: Quad.easeOut});
                    gsap.to($('.main-overlaymenu .overlaymenu-content'), {left: '-100%',duration: .5,delay:.8,autoAlpha: 1,ease: Quad.easeOut});
                }
            }
        });

        agricomHeaderMenu();
    }

    // Header Overlay Menu
    agricomHeaderOverlay();

});
