<?php
/**
*
* @package WordPress
* @subpackage nt_agricom
* @since nt_agricom 1.0
*
**/

/*************************************************
## Google Font
*************************************************/

if ( ! function_exists( 'nt_agricom_fonts_url' ) ) {
    function nt_agricom_fonts_url() {
        $fonts_url = '';

        $poppins = _x( 'on', 'Poppins font: on or off', 'nt-agricom' );
        $raleway = _x( 'on', 'Raleway font: on or off', 'nt-agricom' );


        if ( 'off' !== $poppins || 'off' !== $raleway ) {
            $font_families = array();

            if ( 'off' !== $poppins )
            $font_families[] = 'Poppins:300,400,500,600,700';

            if ( 'off' !== $raleway )
            $font_families[] = 'Raleway:400,400i,500,500i,700,700i';

            $query_args = array(
                'family' => urlencode( implode( '|', $font_families ) ),
                'subset' => urlencode( 'latin,latin-ext' ),
            );
            $fonts_url = add_query_arg( $query_args, "//fonts.googleapis.com/css" );
        }

        return $fonts_url;
    }
}


/*************************************************
## Styles and Scripts
*************************************************/


function nt_agricom_scripts() {

    $rtl = is_rtl() ? '-rtl' : '';

    if ( is_singular() ) wp_enqueue_script( 'comment-reply' );

    // fontawesome icon
    wp_enqueue_style( 'nt-agricom-loader', get_template_directory_uri() . '/css/css-spin-loader.css', 	false, '1.0');
    wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css', 	false, '1.0');
    if ( is_rtl() ){
        wp_enqueue_style( 'bootstrap-rtl', get_template_directory_uri() . '/css/bootstrap-rtl.min.css', false, '1.0');
    }
    // fontawesome icon
    wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/css/fontawesome.min.css', false, '1.0');
    // theme main style
    wp_enqueue_style( 'nt-agricom-slider', get_template_directory_uri() . '/css/vegas-slider'.$rtl.'.css', false, '1.0');
    wp_enqueue_style( 'nt-agricom-main-style', get_template_directory_uri() . '/css/style'.$rtl.'.css', false, '1.0');
    wp_enqueue_style( 'aos', get_template_directory_uri() . '/css/aos.css', false, '1.0');

    // visual composer css for homepage
    wp_enqueue_style( 'nt-agricom-vc', get_template_directory_uri() . '/css/framework-visual-composer.css', false, '1.0');
    // flexslider css file for blog post
    wp_enqueue_style( 'nt-agricom-custom-flexslider', get_template_directory_uri() . '/js/flexslider/framework-flexslider.css', false, '1.0');
    // wordpress css file for blog post
    wp_enqueue_style( 'nt-agricom-wordpress', get_template_directory_uri() . '/css/framework-wordpress'.$rtl.'.css', false, '1.0');
    // update css file
    wp_enqueue_style( 'nt-agricom-extra', get_template_directory_uri() . '/css/framework-extra'.$rtl.'.css', false, '1.0');
    wp_enqueue_style( 'nt-agricom-update', get_template_directory_uri() . '/css/framework-update'.$rtl.'.css', false, '1.0');
    // woocommerce
    if ( class_exists( 'woocommerce' ) ) {
        wp_enqueue_style( 'nt-agricom-woocommerce', get_template_directory_uri() . '/css/framework-woocommerce'.$rtl.'.css', false, '1.0');
    }
    // theme default google webfont loader
    wp_enqueue_style( 'nt-agricom-fonts-load', nt_agricom_fonts_url(), array(), '1.0.0' );

    // custom css
    wp_enqueue_style('nt-agricom-custom-style', get_template_directory_uri() . '/css/framework-custom-style.css', false, '1.0');

    // default
    wp_enqueue_style( 'nt-agricom-style', get_stylesheet_uri() );

    // JS
    // Theme scripts for theme
    wp_enqueue_script('isotope', get_template_directory_uri() . '/js/isotope.pkgd.js', array('jquery'), '1.0', true);
    wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl.carousel.js', array('jquery'), '1.0', true);
    wp_enqueue_script('countTo', get_template_directory_uri() . '/js/jquery.countTo.js', array('jquery'), '1.0', true);
    wp_enqueue_script('appear', get_template_directory_uri() . '/js/jquery.appear.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('easypiechart', get_template_directory_uri() . '/js/jquery.easypiechart.js', array('jquery'), '1.0', true);
    wp_enqueue_script('stellar', get_template_directory_uri() .  '/js/jquery.stellar.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('fs-boxer', get_template_directory_uri() . '/js/jquery.fs.boxer.min.js', array('jquery'), '1.0', true);
    wp_register_script('vegas', get_template_directory_uri() . '/js/vegas-slider.js', array('jquery'), '1.0', true);
    wp_enqueue_script('aos', get_template_directory_uri() . '/js/aos.js', array('jquery'), '1.0', true);
    wp_register_script('gsap', get_template_directory_uri() . '/js/gsap/gsap.min.js', array('jquery'), '1.0', true);
    // overlay menu
    wp_register_style('hamburgers', get_template_directory_uri() . '/js/overlay-menu/hamburgers.css', false, '1.0');
    wp_register_style('overlay-menu', get_template_directory_uri() . '/js/overlay-menu/overlay-menu.css', false, '1.0');
    wp_register_script('overlay-menu', get_template_directory_uri() . '/js/overlay-menu/overlay-menu.js', array('jquery'), '1.0', true);

    wp_enqueue_script('nt-agricom-main', get_template_directory_uri() . '/js/main.js', array('jquery'), '1.0', true);
    wp_register_script('nt-agricom-map', get_template_directory_uri() . '/js/map-settings.js', array('jquery'), '1.0', true);

    // WP default scripts for theme
    wp_enqueue_script('nt-agricom-custom-flexslider', get_template_directory_uri() . '/js/flexslider/framework-flexslider.js', array('jquery'), '1.0', true);
    wp_enqueue_script('agricom-fitvids', get_template_directory_uri() . '/js/framework-fitvids.js', array('jquery'), '1.0', true);
    wp_enqueue_script('nt-agricom-blog-settings', get_template_directory_uri() .  '/js/framework-blog-settings.js', array('jquery'), '1.0', true);

    wp_enqueue_script('device', get_template_directory_uri() . '/js/device.js', array('jquery'), '1.0', false);
}

add_action( 'wp_enqueue_scripts', 'nt_agricom_scripts' );


/*************************************************
## Admin style and scripts
*************************************************/

function nt_agricom_admin_style() {

    // Update CSS within in Admin
    wp_enqueue_style( 'nt-agricom-custom-admin', get_template_directory_uri().'/css/framework-admin.css');
    wp_enqueue_script('nt-agricom-custom-admin', get_template_directory_uri() . '/js/framework-custom.admin.js');

}
add_action('admin_enqueue_scripts', 'nt_agricom_admin_style');


/*************************************************
## Theme option & Metaboxes & shortcodes
*************************************************/

// theme homepage visual composer shortcodes settings
if(function_exists('vc_set_as_theme')) {
    require_once get_template_directory() . '/includes/visual-shortcodes.php';
}

// Metabox plugin check
if ( ! function_exists( 'rwmb_meta' ) ) {
    function rwmb_meta( $key, $args = '', $post_id = null ) {
        return false;
    }
}
// Theme post and page meta plugin for customization and more features
require_once get_template_directory() . '/includes/page-metaboxes.php';

// Theme navigation and pagination options
require_once get_template_directory() . '/includes/template-tags.php';

// Theme parts
require_once get_template_directory() . '/includes/template-parts.php';

// TGM plugin activation
require_once get_template_directory() . '/includes/class-tgm-plugin-activation.php';

// Option tree controllers
if ( ! class_exists( 'OT_Loader' )){

    function ot_get_option() {
        return false;
    }
}

// add filter for  options panel loader
add_filter( 'ot_show_pages', '__return_false' );
add_filter( 'ot_show_new_layout', '__return_false' );

// Theme options admin panel setings file
include_once get_template_directory() . '/includes/theme-options.php';

// Theme customize css setting file
require_once get_template_directory() . '/includes/custom-style.php';



/*************************************************
## Theme Setup
*************************************************/

if ( ! isset( $content_width ) ) $content_width = 960;

function nt_agricom_theme_setup() {

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );

    /*
    * Enable support for Post Thumbnails on posts and pages.
    *
    * See: https://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
    */
    add_theme_support( 'post-thumbnails' );

    // woocommerce
    if ( class_exists( 'woocommerce' ) ) {
        add_theme_support( 'woocommerce' );
        add_theme_support( 'wc-product-gallery-zoom' );
        add_theme_support( 'wc-product-gallery-lightbox' );
        add_theme_support( 'wc-product-gallery-slider' );
    }

    add_theme_support( 'title-tag' );
    add_theme_support( 'custom-background' );
    add_theme_support( 'custom-header' );
    add_theme_support( 'html5', array( 'search-form' ) );

    /*
    * Enable support for Post Formats.
    *
    * See: https://codex.wordpress.org/Post_Formats
    */
    add_theme_support( 'post-formats', array('gallery', 'quote', 'video', 'audio'));

    // Make theme available for translation
    // Translations can be filed in the /languages/ directory
    load_theme_textdomain( 'nt-agricom', get_template_directory() . '/languages' );

    register_nav_menus( array(
        'primary' => esc_html__( 'Primary Menu', 'nt-agricom' ),
    ) );
}
add_action( 'after_setup_theme', 'nt_agricom_theme_setup' );


// remove RSD link for validation
remove_action ('wp_head', 'rsd_link');


/*************************************************
## OPTION TREE WEBFONTS API
*************************************************/

add_filter( 'ot_google_fonts_api_key', 'nt_agricom_change_ot_google_fonts_api_key' );

function nt_agricom_change_ot_google_fonts_api_key( $key ) {
      $api = ot_get_option( 'ot_font_api' );
      return "$api";
}

/*************************************************
## ADMIN NOTICES
*************************************************/


function nt_agricom_theme_activation_notice()
{
    global $current_user;

    $user_id = $current_user->ID;

    if (!get_user_meta($user_id, 'nt_agricom_theme_activation_notice')) {
        ?>

        <div class="updated notice">
            <p>
                <?php
                echo sprintf(
                esc_html__('If you need help about demodata installation, please read docs and %s', 'nt-agricom'),
                '<a target="_blank" href="' . esc_url('https://ninetheme.com/contact/') . '">' . esc_html__('Open a ticket', 'nt-agricom') . '</a> ' . esc_html__('or', 'nt-agricom') . ' <a href="?nt-agricom-ignore-notice">' . esc_html__('Dismiss', 'nt-agricom') . '</a>'
); ?>
            </p>
        </div>
        <?php
    }
}


add_action('admin_notices', 'nt_agricom_theme_activation_notice');

function nt_agricom_theme_activation_notice_ignore()
{
    global $current_user;

    $user_id = $current_user->ID;

    if ( isset( $_GET['nt-agricom-ignore-notice'] ) ) {
        add_user_meta($user_id, 'nt_agricom_theme_activation_notice', 'true', true);
    }
}
add_action('admin_init', 'nt_agricom_theme_activation_notice_ignore');


/*************************************************
## SANITIZE MODIFIED VC-ELEMENTS OUTPUT
*************************************************/

if (!function_exists('nt_agricom_vc_sanitize_data')) {
    function nt_agricom_vc_sanitize_data( $html_data )
    {
        return $html_data;
    }
}

/*************************************************
## HTML5 SEARCH FORM
*************************************************/

function nt_agricom_custom_search_form( $form ) {
    $nt_agricom_search_pleaceholder = ot_get_option('nt_agricom_search_pleaceholder');
    $nt_agricom_search_pleaceholder = $nt_agricom_search_pleaceholder ? esc_attr($nt_agricom_search_pleaceholder) : esc_attr__( 'Search', 'nt-agricom' );
    $nt_agricom_search_button = ot_get_option('nt_agricom_search_button_title');
    $nt_agricom_search_button = $nt_agricom_search_button ? esc_attr($nt_agricom_search_button) : esc_attr__( 'Find', 'nt-agricom' );
    $form = '<form role="search" method="get" id="searchform" class="searchform" action="' . esc_url( home_url( '/' ) ) . '" >
    <div>
    <input type="text" value="' . get_search_query() . '" placeholder="'. $nt_agricom_search_pleaceholder .'" name="s" id="s" />
    <input type="submit" id="searchsubmit" value="'. $nt_agricom_search_button .'" />
    </div>
    </form>';

    return $form;
}
add_filter( 'get_search_form', 'nt_agricom_custom_search_form' );

/*************************************************
## Widget columns
*************************************************/

function nt_agricom_widgets_init() {
    $nt_agricom_cs = ( ot_get_option('nt_agricom_widgetize_clmn_style') );
    $nt_agricom_ww = ( ot_get_option('nt_agricom_footer_clmn') );
    $nt_agricom_cst = $nt_agricom_cs == 'c' ? $nt_agricom_ww : 4;

    register_sidebar( array(
        'name' => esc_html__( 'Blog Sidebar', 'nt-agricom' ),
        'id' => 'sidebar-1',
        'description'=> esc_html__( 'These are widgets for the Blog page.','nt-agricom' ),
        'before_widget' => '<div class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="widget-title"><span>',
        'after_title' => '</span></h4>'
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Woo Single Sidebar', 'nt-agricom' ),
        'id' => 'shop-single-page-sidebar',
        'description' => esc_html__( 'These are widgets for the Blog page.','nt-agricom' ),
        'before_widget' => '<div class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="widget-title"><span>',
        'after_title' => '</span></h4>'
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Woo Shop Page Sidebar', 'nt-agricom' ),
        'id' => 'shop-page-sidebar',
        'description' => esc_html__( 'These are widgets for the Blog page.','nt-agricom' ),
        'before_widget' => '<div class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="widget-title"><span>',
        'after_title' => '</span></h4>'
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Footer Style 1', 'nt-agricom' ),
        'id' => 'nt_agricom_footer_widgetize',
        'description' => esc_html__( 'Theme footer default area','nt-agricom' ),
        'before_widget' => '<div class="widget %2$s col-md-6 col-lg-'.$nt_agricom_cst.'">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-head">',
        'after_title' => '</h3>'
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Footer Style 2 area', 'nt-agricom' ),
        'id' => 'nt_agricom_footer_widgetize2',
        'description' => esc_html__( 'Theme footer widgetize area','nt-agricom' ),
        'before_widget' => '<div class="widget %2$s col-md-6 col-lg-'.$nt_agricom_cst.'">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-head">',
        'after_title' => '</h3>'
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Footer Style 3 area', 'nt-agricom' ),
        'id' => 'nt_agricom_footer_widgetize3',
        'description' => esc_html__( 'Theme footer widgetize area','nt-agricom' ),
        'before_widget' => '<div class="widget %2$s col-md-6 col-lg-'.$nt_agricom_cst.'">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-head">',
        'after_title' => '</h3>'
    ) );
}
add_action( 'widgets_init', 'nt_agricom_widgets_init' );

/*************************************************
## Include the TGM_Plugin_Activation class.
*************************************************/

function nt_agricom_register_required_plugins() {

    $plugins = array(
        array(
            'name' => esc_html__('Breadcrumb NavXT', 'nt-agricom'),
            'slug' => 'breadcrumb-navxt'
        ),
        array(
            'name' => esc_html__('WooCommerce', 'nt-agricom'),
            'slug' => 'woocommerce'
        ),
        array(
            'name' => esc_html__('Contact Form 7', 'nt-agricom'),
            'slug' => 'contact-form-7'
        ),
        array(
            'name' => esc_html__('Meta Box', 'nt-agricom'),
            'slug' => 'meta-box',
            'required' => true
        ),
        array(
            'name' => esc_html__('Theme Options Panel', 'nt-agricom'),
            'slug' => 'option-tree',
            'required' => true
        ),
        array(
            'name' => esc_html__('Metabox Show/Hide', "nt-agricom"),
            'slug' => 'meta-box-show-hide',
            'source' => 'https://ninetheme.com/documentation/plugins/meta-box-show-hide.zip',
            'required' => true,
            'version' => '1.3'
        ),
        array(
            'name' => esc_html__('Envato Auto Update Theme', "nt-agricom"),
            'slug' => 'envato-market',
            'source' => 'https://ninetheme.com/documentation/plugins/envato-market.zip',
            'required' => false,
            'version' => '2.0.3'
        ),
        array(
            'name' => esc_html__('Page Builder', "nt-agricom"),
            'slug' => 'js_composer',
            'source' => 'https://ninetheme.com/documentation/plugins/js_composer.zip',
            'required' => true
        ),
        array(
            'name' => esc_html__('Revolution Slider', "nt-agricom"),
            'slug' => 'revolution_slider',
            'source' => 'https://ninetheme.com/documentation/plugins/revolution_slider.zip',
            'required' => false
        ),
        array(
            'name' => esc_html__('WP Agricom Shortcodes', 'nt-agricom'),
            'slug' => 'nt-agricom-shortcodes',
            'source' => get_template_directory() . '/plugins/nt-agricom-shortcodes.zip',
            'required' => true,
            'version' => '1.6.0'
        )
    );

    $config = array(
        'id' => 'tgmpa',
        'default_path' => '',
        'menu' => 'tgmpa-install-plugins',
        'parent_slug' => apply_filters( 'ninetheme_parent_slug', 'themes.php' ),
        'has_notices' => true,
        'dismissable' => true,
        'dismiss_msg' => '',
        'is_automatic' => true,
        'message' => ''
    );

    tgmpa( $plugins, $config );
}

add_action( 'tgmpa_register', 'nt_agricom_register_required_plugins' );


/*************************************************
## Custom body class
*************************************************/
function nt_agricom_body_classes( $classes ) {

    if( basename( get_page_template() ) === 'one-page-template.php' ){

        $classes[] = ' nt-theme-homepage page page-home';

    }else{

        $classes[] = ' nt-theme-blogpage page page-blog';

    }

    return $classes;

}
add_filter( 'body_class', 'nt_agricom_body_classes' );


/*************************************************
## return $post_typess for cpt
*************************************************/
function nt_agricom_get_all_cpts(){

    $args = array(
        'public'   => true,
        '_builtin' => false
    );
    $output = 'names'; // names or objects, note names is the default
    $operator = 'and'; // 'and' or 'or'
    $post_types = get_post_types( $args, $output, $operator );

    foreach ( $post_types  as $post_type ) {
        $post_typess = $post_type;
    }

    return $post_typess ;
}

/*************************************************
## return $post_typess for cpt
*************************************************/
function nt_agricom_get_all_image_sizes(){

    $options = array();
	$image_sizes = get_intermediate_image_sizes();
    if ( !empty($image_sizes) ) {
        foreach ( $image_sizes as $size_name ) {

            $options[] = array(
                'value' => $size_name,
                'label' => $size_name
            );
        }
    }
    return $options;
}


/*************************************************
## Allowed tags
*************************************************/
function nt_agricom_sanitize_data( $nt_agricom_data ) {

    $nt_agricom_sanitize_data = wp_kses( $nt_agricom_data, array(
        'a' => array(
            'class' => array(),
            'href'  => array(),
            'rel'   => array(),
            'title' => array(),
            'target' => array('_blank', '_top'),
        ),
        'b' => array(),
        'br' => array(),
        'span' => array(
            'class' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'del' => array(
            'datetime' => array(),
            'title' => array(),
        ),
        'dd' => array(),
        'div' => array(
            'class' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'em' => array(),
        'ul' => array(
            'class' => array(),
        ),
        'ol' => array(
            'class' => array(),
        ),
        'li' => array(
            'class' => array(),
        ),
        'dl' => array(),
        'dt' => array(),
        'em' => array(),
        'h1' => array(),
        'h2' => array(),
        'h3' => array(),
        'h4' => array(),
        'h5' => array(),
        'h6' => array(),
        'img' => array(
            'alt'    => array(),
            'class'  => array(),
            'height' => array(),
            'src'    => array(),
            'width'  => array(),
        ),
        'input' => array(
            'accept' => array(),
            'class' => array(),
            'id' => array(),
            'align' => array(),
            'alt' => array(),
            'autocomplete' => array(),
            'autofocus' => array(),
            'clicked' => array(),
            'dirname' => array(),
            'disabled' => array(),
            'form' => array(),
            'formenctype' => array(),
            'formmethod' => array(),
            'formnovalidate' => array(),
            'formtarget' => array(),
            'height' => array(),
            'list' => array(),
            'max' => array(),
            'maxlength' => array(),
            'min' => array(),
            'multiple' => array(),
            'name' => array(),
            'pattern' => array(),
            'placeholder' => array(),
            'readonly' => array(),
            'required' => array(),
            'size' => array(),
            'step' => array(),
            'type' => array(),
            'value' => array(),
            'width' => array(),
        ),
        'strong' => array(),
        'pre' => array(),
        'code' => array(),
        'blockquote' => array(
            'cite' => true,
        ),
        'i' => array(
            'class' => array(),
        ),
        'cite' => array(
            'title' => array(),
        ),
        'abbr' => array(
            'title' => true,
        ),
        'select' => array(
            'id'   => array(),
            'class' => array(),
            'name' => array(),
        ),
        'option' => array(
            'value' => array(),
            'selected' => array(),
        ),
        'strike' => array(),
    ) );

    return $nt_agricom_sanitize_data;
}

add_filter('walker_nav_menu_start_el', 'wpse_226884_replace_hash', 999);
/**
 * Replace # with js
 * @param string $menu_item item HTML
 * @return string item HTML
 */
function wpse_226884_replace_hash($menu_item) {
    if (strpos($menu_item, 'href="#"') !== false) {
        $menu_item = str_replace('href="#"', 'href="javascript:void(0);"', $menu_item);
    }
    return $menu_item;
}

/*************************************************
## Register Menu
*************************************************/

class Nt_Agricom_Wp_Bootstrap_Navwalker extends Walker_Nav_Menu {
    public function start_lvl(&$output, $depth = 0, $args = array())
    {
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<div class=\"submenu depth_$depth\"><ul>\n";
    }
    public function end_lvl(&$output, $depth=0, $args=array()) {
        $output .= "</ul></div>\n";
    }
    public function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
    {
        $indent = ($depth) ? str_repeat("\t", $depth) : '';

        $li_attributes = '';
        $class_names = $value = '';

        $classes = empty($item->classes) ? array() : (array) $item->classes;

        // managing divider: add divider class to an element to get a divider before it.
        $divider_class_position = array_search('divider', $classes);

        if ($divider_class_position !== false) {
            $output .= "<li class=\"divider\"></li>\n";
            unset($classes[$divider_class_position]);
        }

        $classes[] = ($args->has_children) ? 'has-submenu' : '';
        $classes[] = ($item->current || $item->current_item_ancestor) ? 'active' : '';
        $classes[] = 'menu-item-' . $item->ID;

        if ($depth && $args->has_children) {
            $classes[] = 'has-submenu';
        }

        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
        $class_names = ' class="' . esc_attr($class_names) . '"';

        $id = apply_filters('nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args);
        $id = strlen($id) ? ' id="' . esc_attr($id) . '"' : '';

        $output .= $indent . '<li' . $id . $value . $class_names . $li_attributes . '>';

        $attributes = ! empty($item->attr_title) ? ' title="' . esc_attr($item->attr_title) .'"' : '';
        $attributes .= ! empty($item->target) ? ' target="' . esc_attr($item->target) .'"' : '';
        $attributes .= ! empty($item->xfn) ? ' rel="' . esc_attr($item->xfn) .'"' : '';
        $attributes .= ! empty($item->url) ? ' href="' . esc_attr($item->url) .'"' : '';

        $item_output = $args->before;
        $item_output .= '<a'. $attributes .'>';
        $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;

        $item_output .= (($depth == 0 || 1) && $args->has_children) ? '</a><span class="caret fa fa-chevron-down"></span>' : '</a>';
        $item_output .= $args->after;


        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    } // start_el

    public function display_element($element, &$children_elements, $max_depth, $depth, $args, &$output)
    {
        if (!$element) {
            return;
        }

        $id_field = $this->db_fields['id'];

        //display this element
        if (is_array($args[0])) {
            $args[0]['has_children'] = ! empty($children_elements[$element->$id_field]);
        } elseif (is_object($args[0])) {
            $args[0]->has_children = ! empty($children_elements[$element->$id_field]);
        }
        $cb_args = array_merge(array(&$output, $element, $depth), $args);
        call_user_func_array(array(&$this, 'start_el'), $cb_args);

        $id = $element->$id_field;

        // descend only when the depth is right and there are childrens for this element
        if (($max_depth == 0 || $max_depth > $depth+1) && isset($children_elements[$id])) {
            foreach ($children_elements[ $id ] as $child) {
                if (!isset($newlevel)) {
                    $newlevel = true;

                    // start the child delimiter
                    $cb_args = array_merge(array(&$output, $depth), $args);
                    call_user_func_array(array(&$this, 'start_lvl'), $cb_args);
                }

                $this->display_element($child, $children_elements, $max_depth, $depth + 1, $args, $output);
            }

            unset($children_elements[ $id ]);
        }

        if (isset($newlevel) && $newlevel) {

            // end the child delimiter
            $cb_args = array_merge(array(&$output, $depth), $args);
            call_user_func_array(array(&$this, 'end_lvl'), $cb_args);
        }

        // end this element
        $cb_args = array_merge(array(&$output, $element, $depth), $args);
        call_user_func_array(array(&$this, 'end_el'), $cb_args);
    }

    /**
    * Menu Fallback
    *
    * @since 1.0.0
    *
    * @param array $args passed from the wp_nav_menu function.
    */
    public static function fallback($args)
    {
        if (current_user_can('edit_theme_options')) {
            echo '<li><a href="' . admin_url('nav-menus.php') . '">' . esc_html__('Add a menu', 'nt-agricom') . '</a></li>';
        }
    }
}

/*************************************************
## agricom Comment
*************************************************/

	if ( ! function_exists( 'agricom_comment' ) ) {
    function agricom_comment( $comment, $args, $depth ) {
        $GLOBALS['comment'] = $comment;
        switch ( $comment->comment_type ) :
            case 'pingback' :
            case 'trackback' :
                // Display trackbacks differently than normal comments. ?>
                <li id="comment-<?php comment_ID(); ?>" <?php comment_class(); ?>>
                <p><strong><?php esc_html_e( 'Pingback:', 'nt-agricom' ); ?></strong> <?php comment_author_link(); ?></p>
            <?php
            break;
            default :
                // Proceed with normal comments. ?>
                <li id="li-comment-<?php comment_ID(); ?>" class="comments">
                    <div id="comment-<?php comment_ID(); ?>" <?php comment_class( 'clr' ); ?>>
                        <span class="avatar-class">
                            <?php echo get_avatar( $comment, 50 ); ?>
                        </span><!-- .comment-author -->
                        <div class="comment-details clr who-comment">
                            <header class="comment-meta">
                                <cite class="fn name"><?php comment_author_link(); ?></cite>
                                <span class="comment-date">
                                <?php
                                    printf( '<a href="%1$s"><time datetime="%2$s">%3$s</time></a>',
                                        esc_url( get_comment_link( $comment->comment_ID ) ),
                                        get_comment_time( 'c' ),
                                        sprintf( _x( '%1$s', '1: date', 'nt-agricom' ), get_comment_date() )
                                    ); ?>
                                </span><!-- .comment-date -->
                            </header><!-- .comment-meta -->
                            <?php if ( '0' == $comment->comment_approved ) : ?>
                                <p class="comment-awaiting-moderation">
                                    <?php esc_html_e( 'Your comment is awaiting moderation.', 'nt-agricom' ); ?>
                                </p><!-- .comment-awaiting-moderation -->
                            <?php endif; ?>
                            <div class="comment-content entry clr">
                                <?php comment_text(); ?>
                            </div><!-- .comment-content -->
                            <footer class="comment-footer clr">
                                <?php
                                // Cancel comment link
                                comment_reply_link( array_merge( $args, array(
                                    'reply_text'    => esc_html__( 'Reply', 'nt-agricom' ) . '',
                                    'depth' => $depth,
                                    'max_depth' => $args['max_depth']
                                ) ) ); ?>
                                <?php
                                // Edit comment link
                                edit_comment_link( esc_html__( 'Edit', 'nt-agricom' ), '<div class="edit-comment">', '</div>' ); ?>
                            </footer>
                        </div><!-- .comment-details -->
                    </div><!-- #comment-## -->
            <?php
            break;
        endswitch;
    }
}


/*************************************************
## THEME SETUP WIZARD
    https://github.com/richtabor/MerlinWP
*************************************************/

require_once get_parent_theme_file_path( '/includes/merlin/admin-menu.php' );
require_once get_parent_theme_file_path( '/includes/merlin/class-merlin.php' );
require_once get_parent_theme_file_path( '/includes/demo-wizard-config.php' );

function agricom_merlin_local_import_files() {
    return array(
        array(
            'import_file_name' => 'Demo Import',
            // xml data
            'local_import_file' => get_parent_theme_file_path( 'includes/merlin/demodata/data.xml' ),
            // widget data
            'local_import_widget_file' => get_parent_theme_file_path( 'includes/merlin/demodata/widgets.wie' ),
            // option tree -> theme options
            'local_import_option_tree_file' => get_parent_theme_file_path( 'includes/merlin/demodata/optiontree.txt' ),
        )
    );
}
add_filter( 'merlin_import_files', 'agricom_merlin_local_import_files' );

function agricom_disable_size_images_during_import() {
    add_filter( 'intermediate_image_sizes_advanced', function( $sizes ){
        unset( $sizes['thumbnail'] );
        unset( $sizes['medium'] );
        unset( $sizes['medium_large'] );
        unset( $sizes['large'] );
        unset( $sizes['1536x1536'] );
        unset( $sizes['2048x2048'] );
        unset( $sizes['woocommerce_thumbnail'] );
        unset( $sizes['woocommerce_single'] );
        unset( $sizes['woocommerce_gallery_thumbnail'] );
        unset( $sizes['shop_catalog'] );
        unset( $sizes['shop_single'] );
        unset( $sizes['shop_thumbnail'] );
        return $sizes;
    });
}
add_action( 'import_start', 'agricom_disable_size_images_during_import');
/**
* Execute custom code after the whole import has finished.
*/
function agricom_merlin_after_import_setup() {

    // Assign menus to their locations.
    $primary = get_term_by( 'name', 'primary', 'nav_menu' );

    set_theme_mod(
        'nav_menu_locations', array(
            'primary' => $primary->term_id,
            'primary-menu-2' => $footer->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

    // removes block widgets from sidebars after demodata install
    if ( is_active_sidebar( 'sidebar-1' ) ) {
        $sidebars_widgets = get_option( 'sidebars_widgets' );
        $sidebar_1_array  = $sidebars_widgets['sidebar-1'];
        foreach( $sidebar_1_array as $k => $v ) {
            if( substr( $v, 0, strlen("block-") ) === "block-" ) {
                unset($sidebars_widgets['sidebar-1'][$k]);
            }
        }
        update_option( 'sidebars_widgets', $sidebars_widgets);
    }
}
add_action( 'merlin_after_all_import', 'agricom_merlin_after_import_setup' );

function agricom_vc_is_inline() {
    return function_exists( 'vc_is_inline' ) && vc_is_inline() ? true : false;
}
if(agricom_vc_is_inline() == false){
    add_action('init', 'do_output_buffer'); function do_output_buffer() { ob_start(); }
}
add_filter( 'woocommerce_prevent_automatic_wizard_redirect', '__return_true' );

/*************************************************
## CUSTOM POST CLASS
*************************************************/

if (! function_exists('nt_agricom_post_theme_class')) {
    function nt_agricom_post_theme_class($classes)
    {

        if ( is_single() ) {
            $classes[] =  has_blocks() ? 'nt-single-has-block' : '';
        }

        return $classes;
    }
    add_filter('post_class', 'nt_agricom_post_theme_class');
}

/*************************************************
## VC COMPOSER PAGE CSS
*************************************************/
/*
*	get vc composer custom css from by page id
*	and add css to head by wp_head hook
*/
if( ! function_exists('nt_agricom_vc_inject_shortcode_css') )  {
    function nt_agricom_vc_inject_shortcode_css( $id ){
        $shortcodes_custom_css = get_post_meta( $id, '_wpb_shortcodes_custom_css', true );
        if ( ! empty( $shortcodes_custom_css ) ) {
            $shortcodes_custom_css = strip_tags( $shortcodes_custom_css );
            echo '<style type="text/css" data-type="nt-shortcodes-custom-css-page-'.$id.'">';
            echo esc_attr( $shortcodes_custom_css );
            echo '</style>';
        }
    }
    add_action('wp_head', 'nt_agricom_vc_inject_shortcode_css');
}



/*************************************************
## VC COMPOSER SAVED TEMPLATE LIST
*************************************************/
if( ! function_exists('nt_agricom_vc_saved_template_list') )  {
    function nt_agricom_vc_saved_template_list(){

        $options = array();
        $saved_templates = get_option( 'wpb_js_templates' );
        if ( !empty($saved_templates) ) {
            foreach ( $saved_templates as $template => $key ) {

                $options[] = array(
                    'value' => $template,
                    'label' => $key['name']
                );
            }
        }
        return $options;
    }
}


/*************************************************
## VC COMPOSER SAVED TEMPLATE CONTENT
*************************************************/
if( ! function_exists( 'nt_agricom_vc_print_saved_template' ) ) {

    function nt_agricom_vc_print_saved_template( $template_id = '')
    {
        $content  = '';
        if ( $template_id ) {
            $saved_templates = get_option( 'wpb_js_templates' );
            $content = trim( $saved_templates[ $template_id ][ 'template' ] );
            $content = str_replace( '\"', '"', $content );
            $pattern = get_shortcode_regex();
            $content = preg_replace_callback( "/{$pattern}/s", 'vc_convert_shortcode', $content );
        }
        return do_shortcode( $content );
    }
}


/*************************************************
## PARSE VC COMPOSER SAVED TEMPLATE CONTENT CSS
*************************************************/
if( ! function_exists( 'nt_agricom_parse_shortcodes_template_css' ) ) {

    function nt_agricom_parse_shortcodes_template_css( $content )
    {

        $css = '';
        if ( ! preg_match( '/\s*(\.[^\{]+)\s*\{\s*([^\}]+)\s*\}\s*/', $content ) ) {
            return $css;
        }

        preg_match_all( '/' . get_shortcode_regex() . '/', $content, $shortcodes );
        foreach ( $shortcodes[2] as $index => $tag ) {
            $shortcode = class_exists( 'WPBMap' ) ? WPBMap::getShortCode( $tag ) : '';
            $attr_array = shortcode_parse_atts( trim( $shortcodes[3][ $index ] ) );
            if ( isset( $shortcode['params'] ) && ! empty( $shortcode['params'] ) ) {
                foreach ( $shortcode['params'] as $param ) {
                    if ( isset( $param['type'] ) && 'css_editor' === $param['type'] && isset( $attr_array[ $param['param_name'] ] ) ) {
                        $css .= $attr_array[ $param['param_name'] ];
                    }
                }
            }
        }

        foreach ( $shortcodes[5] as $shortcode_content ) {
            $css .= nt_agricom_parse_shortcodes_template_css( $shortcode_content );
        }

        return $css;
    }
}


/*************************************************
## ADD HEAD VC COMPOSER SAVED TEMPLATE CONTENT CSS
*************************************************/
if( ! function_exists( 'nt_agricom_add_template_css_to_head' ) ) {
    function nt_agricom_add_template_css_to_head()
    {
        $template = array(
            ot_get_option( 'nt_agricom_footer_template' ),
        );

        $saved_templates = get_option( 'wpb_js_templates' );
        $theCSS = '';

        if ( !empty( $template ) ) {
            foreach ( $template as $template_id ) {
                if ( $template_id ) {
                    $content = trim( $saved_templates[ $template_id ][ 'template' ] );
                    $content = str_replace( '\"', '"', $content );
                    $pattern = get_shortcode_regex();
                    $content = preg_replace_callback( "/{$pattern}/s", 'vc_convert_shortcode', $content );
                    $theCSS .= nt_agricom_parse_shortcodes_template_css( $content );
                }
            }
            if ( !empty( $theCSS ) ) {
                wp_register_style( 'nt_agricom-vc-template-custom', false );
                wp_enqueue_style( 'nt_agricom-vc-template-custom' );
                wp_add_inline_style( 'nt_agricom-vc-template-custom', $theCSS );
            }
        }
    }
    add_action( 'wp_enqueue_scripts', 'nt_agricom_add_template_css_to_head' );
}

add_action('admin_notices', 'agricom_notice_for_activation');
if (!function_exists('agricom_notice_for_activation')) {
    function agricom_notice_for_activation() {
        global $pagenow;

        if ( !get_option('envato_purchase_code_19515876') ) {

            echo '<div class="notice notice-warning">
                <p>' . sprintf(
                esc_html__( 'Enter your Envato Purchase Code to receive agricom Theme and plugin updates  %s', 'nt-agricom' ),
                '<a href="' . admin_url('admin.php?page=merlin&step=license') . '">' . esc_html__( 'Enter Purchase Code', 'nt-agricom' ) . '</a>') . '</p>
            </div>';
        }
    }
}


if ( !get_option('envato_purchase_code_19515876') ) {
    add_filter('auto_update_theme', '__return_false');
}

add_action('upgrader_process_complete', 'agricom_upgrade_function', 10, 2);
if ( !function_exists('agricom_upgrade_function') ) {
    function agricom_upgrade_function($upgrader_object, $options) {
        $purchase_code =  get_option('envato_purchase_code_19515876');

        if (($options['action'] == 'update' && $options['type'] == 'theme') && !$purchase_code) {
            wp_redirect(admin_url('admin.php?page=merlin&step=license'));
        }
    }
}

if ( !function_exists( 'agricom_is_theme_registered') ) {
    function agricom_is_theme_registered() {
        $purchase_code =  get_option('envato_purchase_code_19515876');
        $registered_by_purchase_code =  !empty($purchase_code);

        // Purchase code entered correctly.
        if ($registered_by_purchase_code) {
            return true;
        }
    }
}

function agricom_deactivate_envato_plugin() {
    if (  function_exists( 'envato_market' ) && !get_option('envato_purchase_code_19515876') ) {
        deactivate_plugins('envato-market/envato-market.php');
    }
}
add_action( 'admin_init', 'agricom_deactivate_envato_plugin' );
