<?php
/**
* The template for displaying the footer
*
*
* @package WordPress
* @subpackage nt_agricom
* @since nt_agricom 1.0
*/

    if ( 'vc_template' == ot_get_option( 'nt_agricom_footer_style' ) ) {

        if ( function_exists( 'nt_agricom_vc_print_saved_template' ) ) {
            echo'<footer class="agricom-footer agricom-custom-'.ot_get_option( 'nt_agricom_footer_template' ).'">';
                echo nt_agricom_vc_print_saved_template( ot_get_option( 'nt_agricom_footer_template' ) );
            echo'</footer>';
        }

    } elseif ( 'page' == ot_get_option( 'nt_agricom_footer_style' ) ) {

        if ( '' != ot_get_option( 'nt_agricom_footer_custom_template' ) ) {

            nt_agricom_vc_inject_shortcode_css( ot_get_option( 'nt_agricom_footer_custom_template' ) );

            $content = get_post_field( 'post_content', ot_get_option( 'nt_agricom_footer_custom_template' ) );

            echo do_shortcode( $content );
        }

    } elseif ( 'custom' == ot_get_option( 'nt_agricom_footer_style' ) ) {

        if ( '' != ot_get_option( 'nt_agricom_footer_custom_html' ) ) {

            echo do_shortcode( ot_get_option( 'nt_agricom_footer_custom_html' ) );

        }

    } else {

        if ( is_active_sidebar( 'nt_agricom_footer_widgetize' ) ) {

            do_action( 'nt_agricom_before_footer_action' );
            do_action( 'nt_agricom_widgetize_action' );
            do_action( 'nt_agricom_copyright_action' );
            do_action( 'nt_agricom_after_footer_action' );

        }

    }

    if ( ! class_exists( 'OT_Loader' ) ) {

        nt_agricom_default_footer();

    }

    do_action('nt_agricom_backtop_action');
    do_action( 'nt_agricom_before_wp_footer' );
    wp_footer();
    ?>

    </body>
</html>
