<?php
/*
Plugin Name: EventoZilla - Event Calendar WordPress Plugin
Description: This plugin will allow you to insert an advanced events calendar on your page.
Version: 1.5.4
Author: Lambert Group
Author URI: https://1.envato.market/OZ5Zr
Text Domain: lbg-evento
*/

$lbg_evento_path = trailingslashit(dirname(__FILE__));  //empty

//all the messages
$lbg_evento_messages = array(
		'version' => esc_html( '<div class="error">EVENTOZILLA - Event Calendar WordPress Pugin requires WordPress 3.0 or newer. <a href="https://codex.wordpress.org/Upgrading_WordPress">Please update!</a></div>' , 'lbg-evento' ),
		'data_saved' => esc_html( 'Data Saved!', 'lbg-evento' ),
		'empty_title' => esc_html( 'Event Title - required', 'lbg-evento' ),
		'empty_startdate' => esc_html( 'Event Start Date - required', 'lbg-evento' ),
		'empty_enddate' => esc_html( 'Event End Date - required', 'lbg-evento' ),
		'invalid_request' => esc_html( 'Invalid Request!', 'lbg-evento' ),
		'generate_for_this_event' => esc_html( 'You can start customizing this event.', 'lbg-evento' ),
		'duplicate_complete' => esc_html( 'Duplication process is complete!', 'lbg-evento' )
	);


global $wp_version;

if ( !version_compare($wp_version,"3.0",">=")) {
	wp_die (esc_html($lbg_evento_messages['version'], 'lbg-evento' ));
}




function lbg_evento_activate() {
	//db creation, create admin options etc.
	global $wpdb;

	$lbg_evento_collate = ' COLLATE utf8_general_ci';

	$sql0 = "CREATE TABLE `" . $wpdb->prefix . "lbg_evento_events` (
			`id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
			`name` VARCHAR( 255 ) NOT NULL ,
			PRIMARY KEY ( `id` )
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	$sql1 = "CREATE TABLE `" . $wpdb->prefix . "lbg_evento_settings` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `width` smallint(5) unsigned NOT NULL DEFAULT '720',
	`months_area_width` smallint(5) unsigned NOT NULL DEFAULT '170',
	`months_area_color` varchar(10) NOT NULL DEFAULT 'ffffff',
	`centerPlugin` varchar(8) NOT NULL DEFAULT 'true',
	`eventsListVerticalPadding` smallint(5) unsigned NOT NULL DEFAULT '20',
	`eventsListHorizontalPadding` smallint(5) unsigned NOT NULL DEFAULT '10',
  `eventTitleLeftMargin` smallint(5) unsigned NOT NULL DEFAULT '15',
	`eventFirstDateFontSize` smallint(5) unsigned NOT NULL DEFAULT '92',
	`eventSecondDateFontSize` smallint(5) unsigned NOT NULL DEFAULT '20',
	`eventSecondDateMonthFontSize` smallint(5) unsigned NOT NULL DEFAULT '13',
	`eventTitleFontSize` smallint(5) unsigned NOT NULL DEFAULT '27',
	`eventInitialDetailsFontSize` smallint(5) unsigned NOT NULL DEFAULT '14',
	`eventBottomBorderColor` varchar(10) NOT NULL DEFAULT 'CCCCCC',
	`eventBackgroundColor_odd` varchar(10) NOT NULL DEFAULT 'ffffff',
	`eventBackgroundColor_even` varchar(10) NOT NULL DEFAULT 'ebebeb',
	`eventBgDayColor_odd` varchar(10) NOT NULL DEFAULT 'da0000',
	`eventBgDayColor_even` varchar(10) NOT NULL DEFAULT '000000',
	`eventDateColor_odd` varchar(10) NOT NULL DEFAULT '444444',
	`eventDateColor_even` varchar(10) NOT NULL DEFAULT '444444',
	`eventTitleColor_odd` varchar(10) NOT NULL DEFAULT '444444',
	`eventTitleColor_even` varchar(10) NOT NULL DEFAULT '444444',
	`eventInitialDetailsColor_odd` varchar(10) NOT NULL DEFAULT '444444',
	`eventInitialDetailsColor_even` varchar(10) NOT NULL DEFAULT '444444',
	`dressCode` varchar(150) NOT NULL DEFAULT 'Dress code',
	`dressCodeFontSize` smallint(5) unsigned NOT NULL DEFAULT '13',
	`dressCodeColor_odd` varchar(10) NOT NULL DEFAULT '808080',
	`dressCodeColor_even` varchar(10) NOT NULL DEFAULT '808080',
	`socialIconsColor_odd` varchar(10) NOT NULL DEFAULT '000000',
	`socialIconsColor_even` varchar(10) NOT NULL DEFAULT 'FFFFFF',
	`shortmonth_Jan` varchar(130) NOT NULL DEFAULT 'Jan',
	`shortmonth_Feb` varchar(130) NOT NULL DEFAULT 'Feb',
	`shortmonth_Mar` varchar(130) NOT NULL DEFAULT 'Mar',
	`shortmonth_Apr` varchar(130) NOT NULL DEFAULT 'Apr',
	`shortmonth_May` varchar(130) NOT NULL DEFAULT 'May',
	`shortmonth_Jun` varchar(130) NOT NULL DEFAULT 'Jun',
	`shortmonth_Jul` varchar(130) NOT NULL DEFAULT 'Jul',
	`shortmonth_Aug` varchar(130) NOT NULL DEFAULT 'Aug',
	`shortmonth_Sep` varchar(130) NOT NULL DEFAULT 'Sep',
	`shortmonth_Oct` varchar(130) NOT NULL DEFAULT 'Oct',
	`shortmonth_Nov` varchar(130) NOT NULL DEFAULT 'Nov',
	`shortmonth_Dec` varchar(130) NOT NULL DEFAULT 'Dec',
	`longdays_Sunday` varchar(130) NOT NULL DEFAULT 'Sunday',
	`longdays_Monday` varchar(130) NOT NULL DEFAULT 'Monday',
	`longdays_Tuesday` varchar(130) NOT NULL DEFAULT 'Tuesday',
	`longdays_Wednesday` varchar(130) NOT NULL DEFAULT 'Wednesday',
	`longdays_Thursday` varchar(130) NOT NULL DEFAULT 'Thursday',
	`longdays_Friday` varchar(130) NOT NULL DEFAULT 'Friday',
	`longdays_Saturday` varchar(130) NOT NULL DEFAULT 'Saturday',
	`Sunday_color` varchar(10) NOT NULL DEFAULT 'fff000',
	`Monday_color` varchar(10) NOT NULL DEFAULT '00ffe0',
	`Tuesday_color` varchar(10) NOT NULL DEFAULT 'ff780a',
	`Wednesday_color` varchar(10) NOT NULL DEFAULT 'c96bb6',
	`Thursday_color` varchar(10) NOT NULL DEFAULT '00ff36',
	`Friday_color` varchar(10) NOT NULL DEFAULT 'ff00a8',
	`Saturday_color` varchar(10) NOT NULL DEFAULT '008aff',
	`eventDaysColor` varchar(10) NOT NULL DEFAULT 'FFFFFF',
	`use24HoursFormat` varchar(8) NOT NULL DEFAULT 'false',
	`noEventsAvailableText` varchar(250) NOT NULL DEFAULT 'No event available for this month',
	`eventCancelledText` varchar(250) NOT NULL DEFAULT 'Cancelled',
	`fullCalendarOnLeft` varchar(8) NOT NULL DEFAULT 'true',
	`leftSideCalendarDaysColor` varchar(10) NOT NULL DEFAULT '707275',
	`leftSideCalendarPastMonthDaysColor` varchar(10) NOT NULL DEFAULT 'aaaaaa',
	`leftSideCalendarNextMonthDaysColor` varchar(10) NOT NULL DEFAULT 'aaaaaa',
	`leftSideCalendarCurrentDayColor` varchar(10) NOT NULL DEFAULT '00ffe0',
	`leftSideCalendarEventDaysColor` varchar(10) NOT NULL DEFAULT '0000CC',
	`leftSideCalendarEventDaysBgColor` varchar(10) NOT NULL DEFAULT '00ffe0',
	`leftSideCalendarDaysNameColor` varchar(10) NOT NULL DEFAULT '000000',
	`yearColor` varchar(10) NOT NULL DEFAULT 'a3a3a3',
	`monthColor` varchar(10) NOT NULL DEFAULT '444444',
	`monthYearLineSeparatorColor` varchar(10) NOT NULL DEFAULT 'da0000',
	`monthsNextPrevArrowsColor` varchar(10) NOT NULL DEFAULT 'd1d1d1',
	`detailsTitle` varchar(200) NOT NULL DEFAULT 'Details',
	`whenWhereTitle` varchar(200) NOT NULL DEFAULT 'When & Where',
	`organizerTitle` varchar(200) NOT NULL DEFAULT 'Organizer',
	`moreDetailsText` varchar(200) NOT NULL DEFAULT 'more details here',
	`moreDetailsTarget` varchar(10) NOT NULL DEFAULT '_blank',
	`showFacebookBut` varchar(8) NOT NULL DEFAULT 'true',
	`showTwitterBut` varchar(8) NOT NULL DEFAULT 'true',
	`showPinterestBut` varchar(8) NOT NULL DEFAULT 'true',
	`showMonthFirstForDate` varchar(8) NOT NULL DEFAULT 'true',
	`showEndDate` varchar(8) NOT NULL DEFAULT 'true',
	`showEndedEvents` varchar(8) NOT NULL DEFAULT 'true',
	`showMonthsWithoutEvents` varchar(8) NOT NULL DEFAULT 'true',
	`searchInputText` varchar(10) NOT NULL DEFAULT 'search...',
	`bookNowText` varchar(100) NOT NULL DEFAULT 'Book Now',
	`bookNowLinkTarget` varchar(8) NOT NULL DEFAULT '_self',
	`endedText` varchar(100) NOT NULL DEFAULT 'Ended',
	`lbgEventFistDate_min_width` smallint(5) unsigned NOT NULL DEFAULT '0',
	`thumbOffHeight` smallint(5) unsigned NOT NULL DEFAULT '165',
	`automaticallyGenerateEventPost` varchar(8) NOT NULL DEFAULT 'true',
	  PRIMARY KEY  (`id`)
	) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	$sql2 = "CREATE TABLE `". $wpdb->prefix . "lbg_evento_playlist` (
	  `id` int(10) unsigned NOT NULL auto_increment,
	  `eventid` int(10) unsigned NOT NULL,
	  `xtitle` varchar(255),
		`xstartdate` varchar(255),
		`xstartdate_hours` smallint(5) unsigned,
		`xstartdate_minutes` smallint(5) unsigned,
		`xenddate` varchar(255),
		`xenddate_hours` smallint(5) unsigned,
		`xenddate_minutes` smallint(5) unsigned,
	  `xaddress` text,
	  `xmainimage` text,
	  `xdetails` text,
	  `xorganizer_logo` text,
	  `xorganizer_info` text,
	  `xmoreinfolink` text,
		`xbooknowlink` text,
		`postid` int(10) unsigned,
	  `xdresscode` text,
	  `xcancelled` smallint(5) unsigned NOT NULL,
		`ord` int(10) unsigned NOT NULL,
	  PRIMARY KEY  (`id`)
	) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql0.$lbg_evento_collate);
	dbDelta($sql1.$lbg_evento_collate);
	dbDelta($sql2.$lbg_evento_collate);


	//initialize the events table with the first event type
	$rows_count = $wpdb->get_var( "SELECT COUNT(*) FROM ". $wpdb->prefix ."lbg_evento_events" );
	if (!$rows_count) {
		$wpdb->insert(
			$wpdb->prefix . "lbg_evento_events",
			array(
				'name' => 'Default'
			),
			array(
				'%s'
			)
		);
	}

	// initialize the settings
	$rows_count = $wpdb->get_var( "SELECT COUNT(*) FROM ". $wpdb->prefix ."lbg_evento_settings" );
	if (!$rows_count) {
		lbg_evento_insert_settings_record(1);
	}

	//create category
	if (!category_exists('CalendarEvents')) {
			//Define the category
			$wpdocs_cat = array('cat_name' => 'CalendarEvents', 'category_description' => 'Evento Category', 'category_nicename' => 'lbg-category', 'category_parent' => '');
			// Create the category
			$wpdocs_cat_id = wp_insert_category($wpdocs_cat);
	}

}


function lbg_evento_insert_settings_record($event_id) {
	global $wpdb;
	$wpdb->insert(
			$wpdb->prefix . "lbg_evento_settings",
			array(
				'shortmonth_Jan' => 'Jan'
			),
			array(
				'%s'
			)
		);
}


function lbg_evento_init_cookies() {
		if (is_admin()) {
					if ( array_key_exists('id', $_GET) && isset($_GET['id']) ) {
							if (!array_key_exists('xid', $_COOKIE) || (array_key_exists('xid', $_COOKIE) && $_COOKIE['xid']!=$_GET['id'])) {
									setcookie('xid', $_GET['id'], time() + (86400 * 30), "/");
									wp_redirect($_SERVER['REQUEST_URI']);
									exit;
							}
					}


					if ( array_key_exists('name', $_GET) && isset($_GET['name']) && !array_key_exists('name', $_POST) ) {
							if (!array_key_exists('xname', $_COOKIE) || (array_key_exists('xname', $_COOKIE) && $_COOKIE['xname']!=$_GET['name'])) {
									setcookie('xname', $_GET['name'], time() + (86400 * 30), "/");
									wp_redirect($_SERVER['REQUEST_URI']);
									exit;
							}
					}

					if ( array_key_exists('name', $_POST) && isset($_POST['name']) ) {
							setcookie('xname', $_POST['name'], time() + (86400 * 30), "/");
					}
		}
}


function lbg_evento_load_styles() {
	if(strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false) { //loads css in admin
		$page = (isset($_GET['page'])) ? $_GET['page'] : '';
		if(preg_match('/LBG_EVENTO/i', $page)) {
			wp_enqueue_style('jquery-ui-pepper-grinder', plugins_url('css/jquery-ui.min.css', __FILE__));
			wp_enqueue_style('lbg-lbg-evento-shoutcast-css', plugins_url('css/styles.css', __FILE__));
			wp_enqueue_style('lbg-lbg-evento-shoutcast-colorpicker-css', plugins_url('css/colorpicker/colorpicker.css', __FILE__));

			wp_enqueue_style('thickbox');
		}
	} else if (!is_admin()) { //loads css in front-end
		wp_enqueue_style('lbg-evento-dcalendar-css', plugins_url('evento/css/dcalendar.picker.css', __FILE__));
		wp_enqueue_style('lbg-evento-site-css', plugins_url('evento/css/lbg_evento.css', __FILE__));
	}
}

function lbg_evento_load_scripts() {
	$page = (isset($_GET['page'])) ? $_GET['page'] : '';
	if(preg_match('/LBG_EVENTO/i', $page)) {
		//loads scripts in admin
			wp_enqueue_script('jquery');
			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-widget');
			wp_enqueue_script('jquery-ui-mouse');
			wp_enqueue_script('jquery-ui-accordion');
			wp_enqueue_script('jquery-ui-autocomplete');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_script('jquery-ui-tabs');
			wp_enqueue_script('jquery-ui-sortable');
			wp_enqueue_script('jquery-ui-draggable');
			wp_enqueue_script('jquery-ui-droppable');
			wp_enqueue_script('jquery-ui-selectable');
			wp_enqueue_script('jquery-ui-position');
			wp_enqueue_script('jquery-ui-datepicker');
			wp_enqueue_script('jquery-ui-resizable');
			wp_enqueue_script('jquery-ui-dialog');
			wp_enqueue_script('jquery-ui-button');

			wp_enqueue_script('jquery-form');
			wp_enqueue_script('jquery-color');
			wp_enqueue_script('jquery-masonry');
			wp_enqueue_script('jquery-ui-progressbar');
			wp_enqueue_script('jquery-ui-tooltip');

			wp_enqueue_script('jquery-effects-core');
			wp_enqueue_script('jquery-effects-blind');
			wp_enqueue_script('jquery-effects-bounce');
			wp_enqueue_script('jquery-effects-clip');
			wp_enqueue_script('jquery-effects-drop');
			wp_enqueue_script('jquery-effects-explode');
			wp_enqueue_script('jquery-effects-fade');
			wp_enqueue_script('jquery-effects-fold');
			wp_enqueue_script('jquery-effects-highlight');
			wp_enqueue_script('jquery-effects-pulsate');
			wp_enqueue_script('jquery-effects-scale');
			wp_enqueue_script('jquery-effects-shake');
			wp_enqueue_script('jquery-effects-slide');
			wp_enqueue_script('jquery-effects-transfer');

			wp_register_script('lbg-admin-colorpicker', plugins_url('js/colorpicker/colorpicker.js', __FILE__),array('jquery'),false,false);
			wp_enqueue_script('lbg-admin-colorpicker');

			wp_register_script('lbg-admin-editinplace', plugins_url('js/jquery.editinplace.js', __FILE__),array('jquery'),false,false);
			wp_enqueue_script('lbg-admin-editinplace');

			wp_register_script('lbg-admin-toggle', plugins_url('js/myToggle.js', __FILE__),array('jquery'),false,false);
			wp_enqueue_script('lbg-admin-toggle');


			wp_enqueue_script('media-upload'); // before w.p 3.5
			wp_enqueue_media();// from w.p 3.5
			wp_enqueue_script('thickbox');
	} else if (!is_admin()) { //loads scripts in front-end
		wp_enqueue_script('jquery');

			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_script('jquery-effects-core');

		wp_register_script('lbg-evento-26e31fe740', plugins_url('evento/js/26e31fe740.js', __FILE__),array('jquery'),false,false);
		wp_enqueue_script('lbg-evento-26e31fe740');

		wp_register_script('lbg-evento', plugins_url('evento/js/lbg_evento.js', __FILE__),array('jquery'),false,false);
		wp_enqueue_script('lbg-evento');

		wp_register_script('lbg-dcalendar', plugins_url('evento/js/dcalendar.picker.js', __FILE__),array('jquery'),false,false);
		wp_enqueue_script('lbg-dcalendar');

	}

}



// adds the menu pages
function lbg_evento_plugin_menu() {
	add_menu_page('LBG EVENTO Admin Interface', 'EVENTOZILLA', 'edit_posts', 'LBG_EVENTO', 'lbg_evento_overview_page',
	plugins_url('images/plg_icon.png', __FILE__));
	add_submenu_page( 'LBG_EVENTO', 'LBG EVENTO Overview', 'Overview', 'edit_posts', 'LBG_EVENTO', 'lbg_evento_overview_page');
	add_submenu_page( 'LBG_EVENTO', 'LBG EVENTO Manage Calendars', 'Manage Calendars', 'edit_posts', 'LBG_EVENTO_Manage_Calendars', 'lbg_evento_event_manage_calendars_page');
	add_submenu_page( 'LBG_EVENTO', 'LBG EVENTO Manage Calendars Add New', 'Add New', 'edit_posts', 'LBG_EVENTO_Add_New', 'lbg_evento_event_manage_calendars_add_new_page');
	add_submenu_page( 'LBG EVENTO Manage Calendars', 'LBG EVENTO Calendar Settings', 'Calendar Settings', 'edit_posts', 'LBG_EVENTO_Settings', 'lbg_evento_event_settings_page');
	add_submenu_page( 'LBG EVENTO Manage Calendars', 'LBG EVENTO Calendar Playlist', 'Playlist', 'edit_posts', 'LBG_EVENTO_Playlist', 'lbg_evento_playlist_page');
	add_submenu_page( 'LBG_EVENTO_Settings', 'LBG EVENTO Calendar Settings', 'Duplicate Calendar', 'edit_posts', 'LBG_EVENTO_Duplicate_Calendar', 'lbg_evento_duplicate_calendar_page');
	add_submenu_page( 'LBG_EVENTO', 'LBG EVENTO Help', 'Help', 'edit_posts', 'LBG_EVENTO_Help', 'lbg_evento_event_help_page');
}


//HTML content for overview page
function lbg_evento_overview_page()
{
	global $lbg_evento_path;
	include_once($lbg_evento_path . 'tpl/overview.php');
}

//HTML content for Manage Events
function lbg_evento_event_manage_calendars_page()
{
	global $wpdb;
	global $lbg_evento_messages;
	global $lbg_evento_path;

	//delete event
	if (isset($_GET['id'])) {
		//delete from wp_lbg_evento_events
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."lbg_evento_events WHERE id = %d",$_GET['id']));

		//delete from wp_lbg_evento_settings
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."lbg_evento_settings WHERE id = %d",$_GET['id']));

		//delete from wp_lbg_evento_playlist
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."lbg_evento_playlist WHERE eventid = %d",$_GET['id']));

		//initialize the cookies
		$safe_sql="SELECT * FROM (".$wpdb->prefix ."lbg_evento_events) ORDER BY id";
		$row = $wpdb->get_row($safe_sql,ARRAY_A);
		$row=lbg_evento_unstrip_array($row);

	}


	$safe_sql="SELECT * FROM (".$wpdb->prefix ."lbg_evento_events) ORDER BY id";
	$result = $wpdb->get_results($safe_sql,ARRAY_A);
	include_once($lbg_evento_path . 'tpl/events.php');

}



//HTML content for Manage Events - Add New
function lbg_evento_event_manage_calendars_add_new_page()
{
	global $wpdb;
	global $lbg_evento_messages;
	global $lbg_evento_path;

	if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Add New') {
		$errors_arr=array();
		if (empty($_POST['name']))
			$errors_arr[]=$lbg_evento_messages['empty_name'];

		if (count($errors_arr)) {
				include_once($lbg_evento_path . 'tpl/add_event.php'); ?>
				<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
		  	<?php } else { // no errors
					$wpdb->insert(
						$wpdb->prefix . "lbg_evento_events",
						array(
							'name' => sanitize_text_field($_POST['name'])
						),
						array(
							'%s'
						)
					);
					//insert default event settings for this new event
					lbg_evento_insert_settings_record($wpdb->insert_id);
					?>
						<div class="wrap">
							<div id="lbg_logo">
								<h2><?php esc_html_e( 'Manage Events - Add New Event' , 'lbg-evento' );?></h2>
				 			</div>
							<div id="message" class="updated"><p><?php esc_html_e($lbg_evento_messages['data_saved']);?></p><p><?php esc_html_e($lbg_evento_messages['generate_for_this_event']);?></p></div>
							<div>
								<p>&raquo; <a href="?page=LBG_EVENTO_Add_New"><?php esc_html_e( 'Add New (event)' , 'lbg-evento' );?></a></p>
								<p>&raquo; <a href="?page=LBG_EVENTO_Manage_Calendars"><?php esc_html_e( 'Back to Manage Events' , 'lbg-evento' );?></a></p>
							</div>
						</div>
		  	<?php }
	} else {
		include_once($lbg_evento_path . 'tpl/add_event.php');
	}

}




//HTML content for eventsettings
function lbg_evento_event_settings_page()
{
	global $wpdb;
	global $lbg_evento_messages;
	global $lbg_evento_path;


	if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Update Event Settings') {
		$_GET['xmlf']='';
		$except_arr=array('Submit','name','page_scroll_to_id_instances','pll_ajax_backend','page_scroll_to_id_instances');
			$wpdb->update(
				$wpdb->prefix .'lbg_evento_events',
				array(
				'name' => sanitize_text_field($_POST['name'])
				),
				array( 'id' => $_COOKIE['xid'] )
			);
			$_COOKIE['xname']=stripslashes($_POST['name']);


			foreach ($_POST as $key=>$val){
				if (in_array($key,$except_arr)) {
					unset($_POST[$key]);
				}
			}

			$wpdb->update(
				$wpdb->prefix .'lbg_evento_settings',
				$_POST,
				array( 'id' => sanitize_text_field($_COOKIE['xid']) )
			);

			?>
			<div id="message" class="updated"><p><?php esc_html_e($lbg_evento_messages['data_saved']);?></p></div>
	<?php
	}

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."lbg_evento_settings) WHERE id = %d",$_COOKIE['xid'] );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$row=lbg_evento_unstrip_array($row);
	$_POST = $row;
	$_POST=lbg_evento_unstrip_array($_POST);

	$cur_name= $wpdb->get_var( $wpdb->prepare( "SELECT name FROM ".$wpdb->prefix."lbg_evento_events WHERE id = %d", $_COOKIE['xid'] ) );


	include_once($lbg_evento_path . 'tpl/settings_form.php');

}


function lbg_evento_playlist_page()
{
	global $wpdb;
	global $lbg_evento_messages;
	global $lbg_evento_path;


	if (array_key_exists('xmlf', $_GET) && $_GET['xmlf']=='add_playlist_record') {
		if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Add Record') {
			$errors_arr=array();
			if (empty($_POST['xtitle']))
				 $errors_arr[]=$lbg_evento_messages['empty_title'];
			if (empty($_POST['xstartdate']))
				 $errors_arr[]=$lbg_evento_messages['empty_startdate'];
			if (empty($_POST['xenddate']))
				 $errors_arr[]=$lbg_evento_messages['empty_enddate'];


			if (count($errors_arr)) {
				include_once($lbg_evento_path . 'tpl/add_playlist_record.php'); ?>
				<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
	  <?php } else { // all requested fields are filled



		if (count($errors_arr)) {
			include_once($lbg_evento_path . 'tpl/add_playlist_record.php'); ?>
			<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
	  	<?php } else { // no upload errors
					//check if 'Automatically Generate Event Post' is set
					$aux_automaticallyGenerateEventPost=$wpdb->get_var( $wpdb->prepare( "SELECT automaticallyGenerateEventPost FROM ". $wpdb->prefix ."lbg_evento_settings WHERE id = %d",$_POST['eventid'] ) );

					$lbg_evento_post_id=0;
					if ($aux_automaticallyGenerateEventPost=='true') {
							//create post start
							$lbg_evento_post_content=lbg_evento_generate_post_content($_POST,$_POST['eventid']);

							$lbg_evento_post_arr = array(
							  'post_title'    => sanitize_text_field($_POST['xtitle']),
							  'post_content'  => $lbg_evento_post_content,
							  'post_status'   => 'publish',
								'post_category' => array( get_cat_ID('CalendarEvents') )
							);
							// Insert the post into the database
							$lbg_evento_post_id=wp_insert_post( $lbg_evento_post_arr );
							//create post end
					}


				$max_ord = 1+$wpdb->get_var( $wpdb->prepare( "SELECT max(ord) FROM ". $wpdb->prefix ."lbg_evento_playlist WHERE eventid = %d",$_COOKIE['xid'] ) );
				if (empty($_POST['xcancelled'])) {
					$_POST['xcancelled']=0;
				}
				$wpdb->insert(
					$wpdb->prefix . "lbg_evento_playlist",
					array(
						'eventid' => sanitize_text_field($_POST['eventid']),
						'xtitle' => sanitize_text_field($_POST['xtitle']),
						'xstartdate' => sanitize_text_field($_POST['xstartdate']),
						'xstartdate_hours' => sanitize_text_field($_POST['xstartdate_hours']),
						'xstartdate_minutes' => sanitize_text_field($_POST['xstartdate_minutes']),
						'xenddate' => sanitize_text_field($_POST['xenddate']),
						'xenddate_hours' => sanitize_text_field($_POST['xenddate_hours']),
						'xenddate_minutes' => sanitize_text_field($_POST['xenddate_minutes']),
						'xaddress' => sanitize_text_field($_POST['xaddress']),
						'xmainimage' => sanitize_text_field($_POST['xmainimage']),
						'xdetails' => sanitize_text_field($_POST['xdetails']),
						'xbooknowlink' => sanitize_text_field($_POST['xbooknowlink']),
						'xorganizer_logo' => sanitize_text_field($_POST['xorganizer_logo']),
						'xorganizer_info' => sanitize_text_field($_POST['xorganizer_info']),
						'xmoreinfolink' => sanitize_text_field(get_the_permalink($lbg_evento_post_id)),
						'xdresscode' => sanitize_text_field($_POST['xdresscode']),
						'xcancelled' => sanitize_text_field($_POST['xcancelled']),
						'postid' => sanitize_text_field($lbg_evento_post_id),
						'ord' => sanitize_text_field($max_ord)
					),
					array(
						'%d',
						'%s',
						'%s',
						'%d',
						'%d',
						'%s',
						'%d',
						'%d',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%d',
						'%d',
						'%d'
					)
				);



	  			if (isset($_POST['setitfirst'])) {
					$sql_arr=array();
					$ord_start=$max_ord;
					$ord_stop=1;
					$elem_id=$wpdb->insert_id;
					$ord_direction='+1';

					$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."lbg_evento_playlist SET ord=ord+1  WHERE eventid = %d and ord>=".$ord_stop." and ord<".$ord_start, $_COOKIE['xid']);
					$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."lbg_evento_playlist SET ord=%d WHERE id=%d",$ord_stop, $elem_id);

					foreach ($sql_arr as $sql)
						$wpdb->query($sql);
				}
				?>
					<div class="wrap">
						<div id="lbg_logo">
							<h2><?php esc_html_e( 'Playlist for player:' , 'lbg-evento' );?> <span style="color:#FF0000; font-weight:bold;"><?php echo esc_html($_COOKIE['xname'])?> - ID #<?php echo esc_html($_COOKIE['xid'])?></span> - <?php esc_html_e( 'Add New' , 'lbg-evento' );?></h2>
			 			</div>
						<div id="message" class="updated"><p><?php echo esc_html($lbg_evento_messages['data_saved']);?></p></div>
						<div>
							<p>&raquo; <a href="?page=LBG_EVENTO_Playlist&xmlf=add_playlist_record"><?php esc_html_e( 'Add New' , 'lbg-evento' );?></a></p>
							<p>&raquo; <a href="?page=LBG_EVENTO_Playlist"><?php esc_html_e( 'Back to Playlist' , 'lbg-evento' );?></a></p>
						</div>
					</div>
	  	<?php }
	  		}
		} else {
			include_once($lbg_evento_path . 'tpl/add_playlist_record.php');
		}

	} else {
		if (array_key_exists('duplicate_id', $_GET) && $_GET['duplicate_id']!='') {
						$max_ord = 1+$wpdb->get_var( $wpdb->prepare( "SELECT max(ord) FROM ". $wpdb->prefix ."lbg_evento_playlist WHERE eventid = %d",$_COOKIE['xid'] ) );
						$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."lbg_evento_playlist ( `eventid`, `xtitle`, `xstartdate`, `xstartdate_hours`, `xstartdate_minutes`, `xenddate`, `xenddate_hours`, `xenddate_minutes`, `xaddress`, `xmainimage`, `xdetails`, `xbooknowlink`, `xorganizer_logo`, `xorganizer_info`, `xmoreinfolink`, `xdresscode`, `xcancelled`, `ord` )  SELECT `eventid`, `xtitle`, `xstartdate`, `xstartdate_hours`, `xstartdate_minutes`, `xenddate`, `xenddate_hours`, `xenddate_minutes`, `xaddress`, `xmainimage`, `xdetails`, `xbooknowlink`, `xorganizer_logo`, `xorganizer_info`, `xmoreinfolink`, `xdresscode`, `xcancelled`, ".$max_ord." FROM (".$wpdb->prefix ."lbg_evento_playlist) WHERE id = %d",$_GET['duplicate_id'] );
						$wpdb->query($safe_sql);

						//create post start
						$aux_automaticallyGenerateEventPost=$wpdb->get_var( $wpdb->prepare( "SELECT automaticallyGenerateEventPost FROM ". $wpdb->prefix ."lbg_evento_settings WHERE id = %d",$_COOKIE['xid'] ) );
						if ($aux_automaticallyGenerateEventPost=='true') {
							$lastid = $wpdb->insert_id;
							$safe_sql=$wpdb->prepare("SELECT * FROM ".$wpdb->prefix."lbg_evento_playlist WHERE id = %d",$lastid);
							$row = $wpdb->get_row($safe_sql, ARRAY_A);
							$row=lbg_evento_unstrip_array($row);

							$lbg_evento_post_content=lbg_evento_generate_post_content($row,$row['eventid']);

							$lbg_evento_post_arr = array(
								'post_title'    => sanitize_text_field($row['xtitle']),
								'post_content'  => $lbg_evento_post_content,
								'post_status'   => 'publish',
								'post_category' => array( get_cat_ID('CalendarEvents') )
							);
							// Insert the post into the database
							$lbg_evento_post_id=wp_insert_post( $lbg_evento_post_arr );
						}	
						//create post end
						
						//update xmoreinfolink start
						$wpdb->update(
							$wpdb->prefix .'lbg_evento_playlist',
							array(
							'xmoreinfolink' => sanitize_text_field(get_the_permalink($lbg_evento_post_id)),
							'postid' => sanitize_text_field($lbg_evento_post_id)
							),
							array( 'id' => $lastid )
						);
						//update xmoreinfolink end

						echo "<script>location.href='?page=LBG_EVENTO_Playlist&id=".$_COOKIE['xid']."&name=".$_COOKIE['xname']."'</script>";
		}

		$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."lbg_evento_playlist) WHERE eventid = %d ORDER BY STR_TO_DATE(xstartdate, '%%m/%%d/%%Y') DESC",$_COOKIE['xid'] );
		$result = $wpdb->get_results($safe_sql,ARRAY_A);

		include_once($lbg_evento_path . 'tpl/playlist.php');
	}
}



//HTML duplicate event
function lbg_evento_duplicate_calendar_page()
{
	global $wpdb;
	global $lbg_evento_messages;
	global $lbg_evento_path;

	//insert event
	$wpdb->insert(
			$wpdb->prefix . "lbg_evento_events",
			array(
				'name' => 'Duplicate of Calendar '.sanitize_text_field($_COOKIE['xid'])
			),
			array(
				'%s'
			)
		);

	//duplicate settings
	$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."lbg_evento_settings (`width`, `months_area_width`, `months_area_color`, `centerPlugin`, `eventsListVerticalPadding`, `eventsListHorizontalPadding`, `eventTitleLeftMargin`, `eventFirstDateFontSize`, `eventSecondDateFontSize`, `eventSecondDateMonthFontSize`, `eventTitleFontSize`, `eventInitialDetailsFontSize`, `eventBottomBorderColor`, `eventBackgroundColor_odd`, `eventBackgroundColor_even`, `eventBgDayColor_odd`, `eventBgDayColor_even`, `eventDateColor_odd`, `eventDateColor_even`, `eventTitleColor_odd`, `eventTitleColor_even`, `eventInitialDetailsColor_odd`, `eventInitialDetailsColor_even`, `dressCode`, `dressCodeFontSize`, `dressCodeColor_odd`, `dressCodeColor_even`, `socialIconsColor_odd`, `socialIconsColor_even`, `shortmonth_Jan`, `shortmonth_Feb`, `shortmonth_Mar`, `shortmonth_Apr`, `shortmonth_May`, `shortmonth_Jun`, `shortmonth_Jul`, `shortmonth_Aug`, `shortmonth_Sep`, `shortmonth_Oct`, `shortmonth_Nov`, `shortmonth_Dec`, `longdays_Sunday`, `longdays_Monday`, `longdays_Tuesday`, `longdays_Wednesday`, `longdays_Thursday`, `longdays_Friday`, `longdays_Saturday`, `Sunday_color`, `Monday_color`, `Tuesday_color`, `Wednesday_color`, `Thursday_color`, `Friday_color`, `Saturday_color`, `eventDaysColor`, `use24HoursFormat`, `noEventsAvailableText`, `eventCancelledText`, `fullCalendarOnLeft`, `leftSideCalendarDaysColor`, `leftSideCalendarPastMonthDaysColor`, `leftSideCalendarNextMonthDaysColor`, `leftSideCalendarCurrentDayColor`, `leftSideCalendarEventDaysColor`, `leftSideCalendarEventDaysBgColor`, `leftSideCalendarDaysNameColor`, `yearColor`, `monthColor`, `monthYearLineSeparatorColor`, `monthsNextPrevArrowsColor`, `detailsTitle`, `whenWhereTitle`, `organizerTitle`, `moreDetailsText`, `moreDetailsTarget`, `showFacebookBut`, `showTwitterBut`, `showPinterestBut`, `showMonthFirstForDate`, `showEndDate`, `showEndedEvents`, `showMonthsWithoutEvents`, `searchInputText`,`bookNowText`, `bookNowLinkTarget`, `endedText`, `lbgEventFistDate_min_width`, `thumbOffHeight`, `automaticallyGenerateEventPost`) SELECT `width`, `months_area_width`, `months_area_color`, `centerPlugin`, `eventsListVerticalPadding`, `eventsListHorizontalPadding`, `eventTitleLeftMargin`, `eventFirstDateFontSize`, `eventSecondDateFontSize`, `eventSecondDateMonthFontSize`, `eventTitleFontSize`, `eventInitialDetailsFontSize`, `eventBottomBorderColor`, `eventBackgroundColor_odd`, `eventBackgroundColor_even`, `eventBgDayColor_odd`, `eventBgDayColor_even`, `eventDateColor_odd`, `eventDateColor_even`, `eventTitleColor_odd`, `eventTitleColor_even`, `eventInitialDetailsColor_odd`, `eventInitialDetailsColor_even`, `dressCode`, `dressCodeFontSize`, `dressCodeColor_odd`, `dressCodeColor_even`, `socialIconsColor_odd`, `socialIconsColor_even`, `shortmonth_Jan`, `shortmonth_Feb`, `shortmonth_Mar`, `shortmonth_Apr`, `shortmonth_May`, `shortmonth_Jun`, `shortmonth_Jul`, `shortmonth_Aug`, `shortmonth_Sep`, `shortmonth_Oct`, `shortmonth_Nov`, `shortmonth_Dec`, `longdays_Sunday`, `longdays_Monday`, `longdays_Tuesday`, `longdays_Wednesday`, `longdays_Thursday`, `longdays_Friday`, `longdays_Saturday`, `Sunday_color`, `Monday_color`, `Tuesday_color`, `Wednesday_color`, `Thursday_color`, `Friday_color`, `Saturday_color`, `eventDaysColor`, `use24HoursFormat`, `noEventsAvailableText`, `eventCancelledText`, `fullCalendarOnLeft`, `leftSideCalendarDaysColor`, `leftSideCalendarPastMonthDaysColor`, `leftSideCalendarNextMonthDaysColor`, `leftSideCalendarCurrentDayColor`, `leftSideCalendarEventDaysColor`, `leftSideCalendarEventDaysBgColor`, `leftSideCalendarDaysNameColor`, `yearColor`, `monthColor`, `monthYearLineSeparatorColor`, `monthsNextPrevArrowsColor`, `detailsTitle`, `whenWhereTitle`, `organizerTitle`, `moreDetailsText`, `moreDetailsTarget`, `showFacebookBut`, `showTwitterBut`, `showPinterestBut`, `showMonthFirstForDate`, `showEndDate`, `showEndedEvents`, `showMonthsWithoutEvents`, `searchInputText`,`bookNowText`, `bookNowLinkTarget`, `endedText`, `lbgEventFistDate_min_width`, `thumbOffHeight`, `automaticallyGenerateEventPost` FROM (".$wpdb->prefix ."lbg_evento_settings) WHERE id = %d",$_COOKIE['xid'] );
	$wpdb->query($safe_sql);
	?>
	<div id="message" class="updated"><p><?php esc_html_e($lbg_evento_messages['duplicate_complete']);?></p></div>
	<?php

	$safe_sql="SELECT * FROM (".$wpdb->prefix ."lbg_evento_events) ORDER BY id";
	$result = $wpdb->get_results($safe_sql,ARRAY_A);
	include_once($lbg_evento_path . 'tpl/events.php');

}


function lbg_evento_event_help_page()
{
	global $lbg_evento_path;
	include_once($lbg_evento_path . 'tpl/help.php');
}

function lbg_evento_event_color_parameter($the_param)
{
	$to_return="#";
	if ($the_param=="transparent" || $the_param=="") {
		$to_return="";
	}
	return $to_return;
}


function lbg_evento_generate_preview_code($sliderID) {
	global $wpdb;

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."lbg_evento_settings) WHERE id = %d",$sliderID );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$row=lbg_evento_unstrip_array($row);


	$path_to_plugin = plugin_dir_url(__FILE__);


	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."lbg_evento_playlist) WHERE eventid = %d ORDER BY STR_TO_DATE(xstartdate, '%%m/%%d/%%Y'), xstartdate_hours, xstartdate_minutes ASC",$sliderID );
	$result = $wpdb->get_results($safe_sql,ARRAY_A);
	$playlist_str='';
	foreach ( $result as $row_playlist ) {
		$row_playlist=lbg_evento_unstrip_array($row_playlist);
		$playlist_str.='<ul>
		                   <li class="xtitle">'.$row_playlist["xtitle"].'</li>
		                   <li class="xstartdate">'.$row_playlist["xstartdate"].'-'.$row_playlist["xstartdate_hours"].':'.$row_playlist["xstartdate_minutes"].'</li>
		                   <li class="xenddate">'.$row_playlist["xenddate"].'-'.$row_playlist["xenddate_hours"].':'.$row_playlist["xenddate_minutes"].'</li>
		                   <li class="xaddress">'.$row_playlist["xaddress"].'</li>
		                   <li class="xmainimage">'.$row_playlist["xmainimage"].'</li>
		                   <li class="xdetails">'.$row_playlist["xdetails"].'</li>
											 <li class="xbooknowlink">'.$row_playlist["xbooknowlink"].'</li>
		                   <li class="xorganizer_logo">'.$row_playlist["xorganizer_logo"].'</li>
		                   <li class="xorganizer_info">'.$row_playlist["xorganizer_info"].'</li>
		                   <li class="xmoreinfolink">'.$row_playlist["xmoreinfolink"].'</li>
		                   <li class="xdresscode">'.$row_playlist["xdresscode"].'</li>
		                   <li class="xcancelled">'.$row_playlist["xcancelled"].'</li>
		              </ul>';
	}

	$currentY=date("Y");
	$currentM=date("n");
	$currentD=date("j");
	$currentH=date("H");
	$currentMin=date("i");
	$currentS=date("s");

	$servertime=$currentY.','.$currentM.','.$currentD.','.$currentH.','.$currentMin.','.$currentS;


	$content='<script>
		jQuery(function() {
setTimeout(function(){
			jQuery("#lbg_evento_'.$row["id"].'").lbg_evento({
				nowDate:"'.$currentY.'/'.$currentM.'/'.$currentD.'-'.$currentH.':'.$currentMin.'",
				width:'.$row["width"].',
				months_area_width:'.$row["months_area_width"].',
				months_area_color:"'.lbg_evento_event_color_parameter($row["months_area_color"]).$row["months_area_color"].'",
				centerPlugin:'.$row["centerPlugin"].',
				eventsListVerticalPadding:'.$row["eventsListVerticalPadding"].',
				eventsListHorizontalPadding:'.$row["eventsListHorizontalPadding"].',
				eventTitleLeftMargin:'.$row["eventTitleLeftMargin"].',
				eventFirstDateFontSize:'.$row["eventFirstDateFontSize"].',
				eventSecondDateFontSize:'.$row["eventSecondDateFontSize"].',
				eventSecondDateMonthFontSize:'.$row["eventSecondDateMonthFontSize"].',
				eventTitleFontSize:'.$row["eventTitleFontSize"].',
				eventInitialDetailsFontSize:'.$row["eventInitialDetailsFontSize"].',
				eventBottomBorderColor:"'.lbg_evento_event_color_parameter($row["eventBottomBorderColor"]).$row["eventBottomBorderColor"].'",
				eventBackgroundColor_odd:"'.lbg_evento_event_color_parameter($row["eventBackgroundColor_odd"]).$row["eventBackgroundColor_odd"].'",
				eventBackgroundColor_even:"'.lbg_evento_event_color_parameter($row["eventBackgroundColor_even"]).$row["eventBackgroundColor_even"].'",
				eventBgDayColor_odd:"'.lbg_evento_event_color_parameter($row["eventBgDayColor_odd"]).$row["eventBgDayColor_odd"].'",
				eventBgDayColor_even:"'.lbg_evento_event_color_parameter($row["eventBgDayColor_even"]).$row["eventBgDayColor_even"].'",
				eventDateColor_odd:"'.lbg_evento_event_color_parameter($row["eventDateColor_odd"]).$row["eventDateColor_odd"].'",
				eventDateColor_even:"'.lbg_evento_event_color_parameter($row["eventDateColor_even"]).$row["eventDateColor_even"].'",
				eventTitleColor_odd:"'.lbg_evento_event_color_parameter($row["eventTitleColor_odd"]).$row["eventTitleColor_odd"].'",
				eventTitleColor_even:"'.lbg_evento_event_color_parameter($row["eventTitleColor_even"]).$row["eventTitleColor_even"].'",
				eventInitialDetailsColor_odd:"'.lbg_evento_event_color_parameter($row["eventInitialDetailsColor_odd"]).$row["eventInitialDetailsColor_odd"].'",
				eventInitialDetailsColor_even:"'.lbg_evento_event_color_parameter($row["eventInitialDetailsColor_even"]).$row["eventInitialDetailsColor_even"].'",
				dressCode:"'.$row["dressCode"].'",
				dressCodeFontSize:'.$row["dressCodeFontSize"].',
				dressCodeColor_odd:"'.lbg_evento_event_color_parameter($row["dressCodeColor_odd"]).$row["dressCodeColor_odd"].'",
				dressCodeColor_even:"'.lbg_evento_event_color_parameter($row["dressCodeColor_even"]).$row["dressCodeColor_even"].'",
				socialIconsColor_odd:"'.lbg_evento_event_color_parameter($row["socialIconsColor_odd"]).$row["socialIconsColor_odd"].'",
				socialIconsColor_even:"'.lbg_evento_event_color_parameter($row["socialIconsColor_even"]).$row["socialIconsColor_even"].'",
				shortmonth_arr:["'.$row["shortmonth_Jan"].'", "'.$row["shortmonth_Feb"].'", "'.$row["shortmonth_Mar"].'", "'.$row["shortmonth_Apr"].'", "'.$row["shortmonth_May"].'", "'.$row["shortmonth_Jun"].'", "'.$row["shortmonth_Jul"].'", "'.$row["shortmonth_Aug"].'", "'.$row["shortmonth_Sep"].'", "'.$row["shortmonth_Oct"].'", "'.$row["shortmonth_Nov"].'", "'.$row["shortmonth_Dec"].'"],
				longdays_arr:["'.$row["longdays_Sunday"].'", "'.$row["longdays_Monday"].'", "'.$row["longdays_Tuesday"].'", "'.$row["longdays_Wednesday"].'", "'.$row["longdays_Thursday"].'", "'.$row["longdays_Friday"].'", "'.$row["longdays_Saturday"].'"],
				eventDaysBgColors_arr:["'.lbg_evento_event_color_parameter($row["Sunday_color"]).$row["Sunday_color"].'", "'.lbg_evento_event_color_parameter($row["Monday_color"]).$row["Monday_color"].'", "'.lbg_evento_event_color_parameter($row["Tuesday_color"]).$row["Tuesday_color"].'", "'.lbg_evento_event_color_parameter($row["Wednesday_color"]).$row["Wednesday_color"].'", "'.lbg_evento_event_color_parameter($row["Thursday_color"]).$row["Thursday_color"].'", "'.lbg_evento_event_color_parameter($row["Friday_color"]).$row["Friday_color"].'", "'.lbg_evento_event_color_parameter($row["Saturday_color"]).$row["Saturday_color"].'"],
				eventDaysColor:"'.lbg_evento_event_color_parameter($row["eventDaysColor"]).$row["eventDaysColor"].'",
				use24HoursFormat:'.$row["use24HoursFormat"].',
				noEventsAvailableText:"'.$row["noEventsAvailableText"].'",
				eventCancelledText:"'.$row["eventCancelledText"].'",
				fullCalendarOnLeft:'.$row["fullCalendarOnLeft"].',
				leftSideCalendarDaysColor:"'.lbg_evento_event_color_parameter($row["leftSideCalendarDaysColor"]).$row["leftSideCalendarDaysColor"].'",
				leftSideCalendarPastMonthDaysColor:"'.lbg_evento_event_color_parameter($row["leftSideCalendarPastMonthDaysColor"]).$row["leftSideCalendarPastMonthDaysColor"].'",
				leftSideCalendarNextMonthDaysColor:"'.lbg_evento_event_color_parameter($row["leftSideCalendarNextMonthDaysColor"]).$row["leftSideCalendarNextMonthDaysColor"].'",
				leftSideCalendarCurrentDayColor:"'.lbg_evento_event_color_parameter($row["leftSideCalendarCurrentDayColor"]).$row["leftSideCalendarCurrentDayColor"].'",
				leftSideCalendarEventDaysColor:"'.lbg_evento_event_color_parameter($row["leftSideCalendarEventDaysColor"]).$row["leftSideCalendarEventDaysColor"].'",
				leftSideCalendarEventDaysBgColor:"'.lbg_evento_event_color_parameter($row["leftSideCalendarEventDaysBgColor"]).$row["leftSideCalendarEventDaysBgColor"].'",
				leftSideCalendarDaysNameColor:"'.lbg_evento_event_color_parameter($row["leftSideCalendarDaysNameColor"]).$row["leftSideCalendarDaysNameColor"].'",
				yearColor:"'.lbg_evento_event_color_parameter($row["yearColor"]).$row["yearColor"].'",
				monthColor:"'.lbg_evento_event_color_parameter($row["monthColor"]).$row["monthColor"].'",
				monthYearLineSeparatorColor:"'.lbg_evento_event_color_parameter($row["monthYearLineSeparatorColor"]).$row["monthYearLineSeparatorColor"].'",
				monthsNextPrevArrowsColor:"'.lbg_evento_event_color_parameter($row["monthsNextPrevArrowsColor"]).$row["monthsNextPrevArrowsColor"].'",
				detailsTitle:"'.$row["detailsTitle"].'",
				whenWhereTitle:"'.$row["whenWhereTitle"].'",
				organizerTitle:"'.$row["organizerTitle"].'",
				moreDetailsText:"'.$row["moreDetailsText"].'",
				moreDetailsTarget:"'.$row["moreDetailsTarget"].'",
				showFacebookBut:'.$row["showFacebookBut"].',
				showTwitterBut:'.$row["showTwitterBut"].',
				showPinterestBut:'.$row["showPinterestBut"].',
				showMonthFirstForDate:'.$row["showMonthFirstForDate"].',
				showEndDate:'.$row["showEndDate"].',
				showEndedEvents:'.$row["showEndedEvents"].',
				showMonthsWithoutEvents:'.$row["showMonthsWithoutEvents"].',
				searchInputText:"'.$row["searchInputText"].'",
				bookNowText:"'.$row["bookNowText"].'",
				bookNowLinkTarget:"'.$row["bookNowLinkTarget"].'",
				endedText:"'.$row["endedText"].'"
			});

}, 100);
		});
	</script>
    <div id="lbg_evento_'.$row["id"].'">
				<div class="lbg_xeventslist">'.$playlist_str.'</div>
     </div>
		 <br style="clear:both;">';

	return str_replace("\r\n", '', $content);
}

function lbg_evento_shortcode($atts, $content=null) {
	global $wpdb;

	shortcode_atts( array('settings_id'=>''), $atts);
	if ($atts['settings_id']=='')
		$atts['settings_id']=1;


	return lbg_evento_generate_preview_code($atts['settings_id']);
}



register_activation_hook(__FILE__,"lbg_evento_activate"); //activate plugin and create the database
add_action('init', 'lbg_evento_init_cookies');	// initialize cookies
add_action('init', 'lbg_evento_load_styles');	// loads required styles
add_action('init', 'lbg_evento_load_scripts');			// loads required scripts
add_action('admin_menu', 'lbg_evento_plugin_menu'); // create menus
add_shortcode('lbg_evento', 'lbg_evento_shortcode');				// LBG EVENTO shortcode




function lbg_evento_generate_post_content($THE_POST,$calendarID) {
					global $wpdb;

					// get translations
					$safe_sql=$wpdb->prepare( "SELECT detailsTitle,whenWhereTitle,organizerTitle,dressCode,bookNowText,bookNowLinkTarget FROM (".$wpdb->prefix ."lbg_evento_settings) WHERE id = %d",$calendarID );
					$row = $wpdb->get_row($safe_sql,ARRAY_A);
					$row=lbg_evento_unstrip_array($row);

					$lbg_evento_post_content='';
					if ($THE_POST['xmainimage']!='') {
						$lbg_evento_post_content.='<p><img src="'.sanitize_text_field($THE_POST['xmainimage']).'" title="'.sanitize_text_field($THE_POST['xtitle']).'" alt="'.sanitize_text_field($THE_POST['xtitle']).'" />';
					}
					if ($THE_POST['xdetails']!='') {
						$lbg_evento_post_content.='</p><h2>'.sanitize_text_field($row['detailsTitle']).'</h2><p>'.sanitize_text_field($THE_POST['xdetails']).'</p>';
					}
					if ($THE_POST['xbooknowlink']!='') {
						$lbg_evento_post_content.='</p><h2>'.sanitize_text_field($row['bookNowText']).'</h2><p><a href="'.sanitize_text_field($THE_POST['xbooknowlink']).'" target="'.sanitize_text_field($row['bookNowLinkTarget']).'">'.sanitize_text_field($THE_POST['xbooknowlink']).'</a></p>';
					}
					if ($THE_POST['xstartdate']!='') {
						$lbg_evento_post_content.='</p><h2>'.sanitize_text_field($row['whenWhereTitle']).'</h2>';
						$lbg_evento_post_content.=date('F j, Y (g:i a)', strtotime(sanitize_text_field($THE_POST['xstartdate']).' '.sanitize_text_field($THE_POST['xstartdate_hours']).':'.sanitize_text_field($THE_POST['xstartdate_minutes']))).' - '.date('F j, Y (g:i a)', strtotime(sanitize_text_field($THE_POST['xenddate']).' '.sanitize_text_field($THE_POST['xenddate_hours']).':'.sanitize_text_field($THE_POST['xenddate_minutes'])));
						if ($THE_POST['xaddress']!='') {
								$lbg_evento_post_content.='<p>'.sanitize_text_field($THE_POST['xaddress']).'</p>';
						}
					}
					if ($THE_POST['xorganizer_info']!='') {
						$lbg_evento_post_content.='</p><h2>'.sanitize_text_field($row['organizerTitle']).'</h2>';
						if ($THE_POST['xorganizer_logo']!='') {
							$lbg_evento_post_content.='<p><img src="'.sanitize_text_field($THE_POST['xorganizer_logo']).'" title="'.sanitize_text_field($THE_POST['xorganizer_info']).'" alt="'.sanitize_text_field($THE_POST['xorganizer_info']).'" />';
						}
						$lbg_evento_post_content.='<p>'.sanitize_text_field($THE_POST['xorganizer_info']).'</p>';
					}
					if ($THE_POST['xdresscode']!='') {
						$lbg_evento_post_content.='</p><h2>'.sanitize_text_field($row['dressCode']).'</h2><p>'.sanitize_text_field($THE_POST['xdresscode']).'</p>';
					}


					return $lbg_evento_post_content;

}


/** OTHER FUNCTIONS **/

//stripslashes for an entire array
function lbg_evento_unstrip_array($array){
	if (is_array($array)) {
		foreach($array as &$val){
			if(is_array($val)){
				$val = unstrip_array($val);
			} else {
				$val = stripslashes($val);

			}
		}
	}
	return $array;
}






/* ajax update playlist record */
add_action('admin_head', 'lbg_evento_update_playlist_record_javascript');

function lbg_evento_update_playlist_record_javascript() {
	global $wpdb;
	//Set Your Nonce
	$lbg_evento_update_playlist_record_ajax_nonce = wp_create_nonce("lbg_evento_update_playlist_record-special-string");
	$lbg_evento_preview_record_ajax_nonce = wp_create_nonce("lbg_evento_preview_record-special-string");

	if(strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false) {
			$page = (isset($_GET['page'])) ? $_GET['page'] : '';
			if(preg_match('/LBG_EVENTO/i', $page)) {
?>



<script type="text/javascript" >
//delete the entire record
function lbg_evento_delete_entire_record (delete_id,ord_id,post_id) {
	if (confirm('Are you sure?')) {
		jQuery("#lbg_evento_sortable").sortable('disable');
		jQuery("#"+delete_id).css("display","none");
		jQuery("#lbg_evento_updating_witness").css("display","block");
		var data = "action=lbg_evento_update_playlist_record&security=<?php echo esc_js($lbg_evento_update_playlist_record_ajax_nonce); ?>&updateType=lbg_evento_delete_entire_record&delete_id="+delete_id+"&post_id="+post_id;
		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {
			jQuery("#lbg_evento_sortable").sortable('enable');
			jQuery("#lbg_evento_updating_witness").css("display","none");
		});
	}
}




function showDialogPreview(theSliderID) {  //load content and open dialog
	var data ="action=lbg_evento_preview_record&security=<?php echo esc_js($lbg_evento_preview_record_ajax_nonce); ?>&theSliderID="+theSliderID;

	// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
	jQuery.post(ajaxurl, data, function(response) {
		jQuery('#previewDialogIframe').attr('src','<?php echo plugins_url("tpl/preview.html?d=".time(), __FILE__)?>');
		jQuery("#previewDialog").dialog("open");
	});
}


jQuery(document).ready(function($) {
	/*PREVIEW DIALOG BOX*/
	jQuery( "#previewDialog" ).dialog({
	  minWidth:1200,
	  minHeight:500,
	  title:"Plugin Preview",
	  modal: true,
	  autoOpen:false,
	  hide: "fade",
	  resizable: false,
	  open: function() {
	  },
	  close: function() {
		jQuery('#previewDialogIframe').attr('src','');
	  }
	});


	<?php
		$rows_count = $wpdb->get_var("SELECT COUNT(*) FROM ". $wpdb->prefix . "lbg_evento_playlist;");
		for ($i=1;$i<=$rows_count;$i++) {
	?>

				jQuery('#upload_xmainimage_button_<?php echo esc_js($i)?>').click(function(event) {
						var file_frame;
						event.preventDefault();
						// If the media frame already exists, reopen it.
						if ( file_frame ) {
							file_frame.open();
							return;
						}
						// Create the media frame.
						file_frame = wp.media.frames.file_frame = wp.media({
							title: jQuery( this ).data( 'uploader_title' ),
							button: {
							text: jQuery( this ).data( 'uploader_button_text' ),
							},
							multiple: false // Set to true to allow multiple files to be selected
						});
						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
							// We set multiple to false so only get one image from the uploader
							attachment = file_frame.state().get('selection').first().toJSON();
							// Do something with attachment.id and/or attachment.url here
							document.forms["form-playlist-evento-"+<?php echo esc_js($i)?>].xmainimage.value=attachment.url;
							jQuery('#xmainimage_'+<?php echo esc_js($i)?>).attr('src',attachment.url);
						});
						// Finally, open the modal
						file_frame.open();
				});


				jQuery('#upload_xorganizer_logo_button_<?php echo esc_js($i)?>').click(function(event) {
						var file_frame;
						event.preventDefault();
						// If the media frame already exists, reopen it.
						if ( file_frame ) {
							file_frame.open();
							return;
						}
						// Create the media frame.
						file_frame = wp.media.frames.file_frame = wp.media({
							title: jQuery( this ).data( 'uploader_title' ),
							button: {
							text: jQuery( this ).data( 'uploader_button_text' ),
							},
							multiple: false // Set to true to allow multiple files to be selected
						});
						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
							// We set multiple to false so only get one image from the uploader
							attachment = file_frame.state().get('selection').first().toJSON();
							// Do something with attachment.id and/or attachment.url here
							document.forms["form-playlist-evento-"+<?php echo esc_js($i)?>].xorganizer_logo.value=attachment.url;
							jQuery('#xorganizer_logo_'+<?php echo esc_js($i)?>).attr('src',attachment.url);
						});
						// Finally, open the modal
						file_frame.open();
				});





	jQuery("#form-playlist-evento-<?php echo esc_js($i)?>").submit(function(event) {

		/* stop form from submitting normally */
		event.preventDefault();

		//show loading image
		jQuery('#ajax-message-<?php echo esc_js($i)?>').html('<img src="<?php echo plugins_url('lbg_evento/images/ajax-loader.gif', dirname(__FILE__))?>" />');

		var data ="action=lbg_evento_update_playlist_record&security=<?php echo esc_js($lbg_evento_update_playlist_record_ajax_nonce); ?>&"+jQuery("#form-playlist-evento-<?php echo esc_js($i)?>").serialize();

		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {
			var mov_title = '';
			if (document.forms["form-playlist-evento-<?php echo esc_js($i)?>"].xtitle.value!='')
				mov_title=document.forms["form-playlist-evento-<?php echo esc_js($i)?>"].xtitle.value;
				mov_date=document.forms["form-playlist-evento-<?php echo esc_js($i)?>"]["xstartdate_<?php echo esc_js($i)?>"].value;
				mov_title=mov_date+' --- '+mov_title;
			jQuery('#mov_title_'+document.forms["form-playlist-evento-<?php echo esc_js($i)?>"].id.value).html(mov_title);
			jQuery('#ajax-message-<?php echo esc_js($i)?>').html(response);
		});
	});
	<?php } ?>

});
</script>
<?php
		}
	}
}


add_action('wp_ajax_lbg_evento_update_playlist_record', 'lbg_evento_update_playlist_record_callback');

function lbg_evento_update_playlist_record_callback() {

	check_ajax_referer( 'lbg_evento_update_playlist_record-special-string', 'security' ); //security=<?php echo $lbg_evento_update_playlist_record_ajax_nonce;
	global $wpdb;
	global $lbg_evento_messages;
	$errors_arr=array();

	if (array_key_exists('updateType', $_POST) && $_POST['updateType']=='lbg_evento_delete_entire_record') {
		$delete_id=$_POST['delete_id'];
		$safe_sql=$wpdb->prepare("SELECT * FROM ".$wpdb->prefix."lbg_evento_playlist WHERE id = %d",$delete_id);
		$row = $wpdb->get_row($safe_sql, ARRAY_A);
		$row=lbg_evento_unstrip_array($row);


		//delete the entire record
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."lbg_evento_playlist WHERE id = %d",$delete_id));
		//update the oreder for the rest ord=ord-1 for > ord
		$wpdb->query($wpdb->prepare("UPDATE ".$wpdb->prefix."lbg_evento_playlist SET ord=ord-1 WHERE eventid = %d and  ord>".$row['ord'],$_COOKIE['xid']));
		//delete post
		if (isset($_POST['post_id'])) {
				wp_delete_post($_POST['post_id']);

				//delete post revisisons start
				$lbg_post_type = "revision";
				$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."posts WHERE post_parent = %d and post_type = %s",$_POST['post_id'], 	$lbg_post_type));
				//delete post revisisons end
		}
	}

	//update elements order
	if (array_key_exists('updateType', $_POST) && $_POST['updateType']=='change_ord') {
		$sql_arr=array();
		$ord_start=$_POST['ord_start'];
		$ord_stop=$_POST['ord_stop'];
		$elem_id=(int)$_POST['elem_id'];
		$ord_direction='+1';
		if ($ord_start<$ord_stop)
			$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."lbg_evento_playlist SET ord=ord-1  WHERE eventid = %d and ord>".$ord_start." and ord<=".$ord_stop, $_COOKIE['xid']);
		else
			$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."lbg_evento_playlist SET ord=ord+1  WHERE eventid = %d and ord>=".$ord_stop." and ord<".$ord_start, $_COOKIE['xid']);
		$sql_arr[]=$wpdb->prepare( "UPDATE ".$wpdb->prefix."lbg_evento_playlist SET ord=%d WHERE id=%d",$ord_stop, $elem_id);

		foreach ($sql_arr as $sql)
			$wpdb->query($sql);
	}


	$theid=isset($_POST['id'])?$_POST['id']:0;
	$theord=isset($_POST['ord'])?$_POST['ord']:0;
	//submit update
	if (!isset($_POST['updateType'])) {
		if (empty($_POST['xtitle']))
			 $errors_arr[]=$lbg_evento_messages['empty_title'];
		if (empty($_POST['xstartdate_'.$theord]))
			 $errors_arr[]=$lbg_evento_messages['empty_startdate'];
		if (empty($_POST['xenddate_'.$theord]))
			 $errors_arr[]=$lbg_evento_messages['empty_enddate'];
	}


	if($theid>0 && !count($errors_arr)) {
		$except_arr=array('Submit'.$theord,'xstartdate_'.$theord,'xstartdate_hours_'.$theord,'xstartdate_minutes_'.$theord,'xenddate_'.$theord,'xenddate_hours_'.$theord,'xenddate_minutes_'.$theord,'id','ord','action','security','updateType','pll_ajax_backend','page_scroll_to_id_instances');
		$_POST['xstartdate']=$_POST['xstartdate_'.$theord];
		$_POST['xstartdate_hours']=$_POST['xstartdate_hours_'.$theord];
		$_POST['xstartdate_minutes']=$_POST['xstartdate_minutes_'.$theord];
		$_POST['xenddate']=$_POST['xenddate_'.$theord];
		$_POST['xenddate_hours']=$_POST['xenddate_hours_'.$theord];
		$_POST['xenddate_minutes']=$_POST['xenddate_minutes_'.$theord];
		if (empty($_POST['xcancelled'])) {
			$_POST['xcancelled']=0;
		}
		foreach ($_POST as $key=>$val){
			if (in_array($key,$except_arr)) {
				unset($_POST[$key]);
			}
		}

		$wpdb->update(
			$wpdb->prefix .'lbg_evento_playlist',
			$_POST,
			array( 'id' => $theid )
		);

		//update post start
		$aux_automaticallyGenerateEventPost=$wpdb->get_var( $wpdb->prepare( "SELECT automaticallyGenerateEventPost FROM ". $wpdb->prefix ."lbg_evento_settings WHERE id = %d",$_COOKIE['xid'] ) );
		if ($aux_automaticallyGenerateEventPost=='true') {
			$lbg_evento_post_content=lbg_evento_generate_post_content($_POST,$_COOKIE['xid']);

			$lbg_evento_post_arr = array(
				'ID'    => sanitize_text_field($_POST['postid']),
				'post_title'    => sanitize_text_field($_POST['xtitle']),
				'post_content'  => $lbg_evento_post_content,
				'post_status'   => 'publish',
				'post_category' => array( get_cat_ID('CalendarEvents') )
			);
			// update the post into the database
			wp_update_post( $lbg_evento_post_arr );
			//delete post revisisons start
			$lbg_post_type = "revision";
			$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."posts WHERE post_parent = %d and post_type = %s",$_POST['postid'], 	$lbg_post_type));
			//delete post revisisons end
		}
		//update post end
		?>
			<div id="message" class="updated"><p><?php echo esc_html($lbg_evento_messages['data_saved']);?></p></div>
	<?php
	} else if (!isset($_POST['updateType'])) {
		$errors_arr[]=$lbg_evento_messages['invalid_request'];
	}

	if (count($errors_arr)) { ?>
		<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
	<?php }

	wp_die(); // this is required to return a proper result
}




add_action('wp_ajax_lbg_evento_preview_record', 'lbg_evento_preview_record_callback');

function lbg_evento_preview_record_callback() {
	check_ajax_referer( 'lbg_evento_preview_record-special-string', 'security' );
  global $wp_filesystem;
	if (empty($wp_filesystem)) {
    require_once (ABSPATH . '/wp-admin/includes/file.php');
    WP_Filesystem();
	}
	$aux_val='<html>
					<head>
						<link href="'.plugins_url('evento/css/dcalendar.picker.css', __FILE__).'" rel="stylesheet" type="text/css">
						<link href="'.plugins_url('evento/css/lbg_evento.css', __FILE__).'" rel="stylesheet" type="text/css">

						<script src="'.plugins_url('js/jquery-3.5.1.js', __FILE__).'" type="text/javascript"></script>
						<script src="'.plugins_url('js/jquery-ui-1.12.1.js', __FILE__).'"></script>
						<script src="'.plugins_url('evento/js/26e31fe740.js', __FILE__).'" type="text/javascript"></script>
						<script src="'.plugins_url('evento/js/lbg_evento.js', __FILE__).'" type="text/javascript"></script>
						<script src="'.plugins_url('evento/js/dcalendar.picker.js', __FILE__).'" type="text/javascript"></script>

					</head>
					<body style="padding:0px;margin:0px;">';

	$aux_val.=lbg_evento_generate_preview_code($_POST['theSliderID']);
	$aux_val.="</body>
				</html>";
	$filename=plugin_dir_path(__FILE__) . 'tpl/preview.html';
	if ( ! $wp_filesystem->put_contents(  $filename, $aux_val, FS_CHMOD_FILE) ) {
    echo "error saving file!";
  }


	wp_die(); // this is required to return a proper result
}



?>
